/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.support;

import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.core.BlackboardKt;
import com.embabel.agent.core.Condition;
import com.embabel.agent.core.ProcessContext;
import com.embabel.agent.core.support.BlackboardWorldState;
import com.embabel.agent.spi.expression.LogicalExpression;
import com.embabel.agent.spi.expression.LogicalExpressionParser;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.plan.common.condition.ConditionDetermination;
import com.embabel.plan.common.condition.ConditionWorldState;
import com.embabel.plan.common.condition.WorldStateDeterminer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/core/support/BlackboardWorldStateDeterminer;", "Lcom/embabel/plan/common/condition/WorldStateDeterminer;", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "logicalExpressionParser", "Lcom/embabel/agent/spi/expression/LogicalExpressionParser;", "<init>", "(Lcom/embabel/agent/core/ProcessContext;Lcom/embabel/agent/spi/expression/LogicalExpressionParser;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "knownConditions", "", "", "determineWorldState", "Lcom/embabel/agent/core/support/BlackboardWorldState;", "determineCondition", "Lcom/embabel/plan/common/condition/ConditionDetermination;", "condition", "resolveAsAgentCondition", "Lcom/embabel/agent/core/Condition;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nBlackboardWorldStateDeterminer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackboardWorldStateDeterminer.kt\ncom/embabel/agent/core/support/BlackboardWorldStateDeterminer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1863#2,2:187\n1755#2,3:189\n*S KotlinDebug\n*F\n+ 1 BlackboardWorldStateDeterminer.kt\ncom/embabel/agent/core/support/BlackboardWorldStateDeterminer\n*L\n58#1:187,2\n130#1:189,3\n*E\n"})
public final class BlackboardWorldStateDeterminer
implements WorldStateDeterminer {
    @NotNull
    private final ProcessContext processContext;
    @NotNull
    private final LogicalExpressionParser logicalExpressionParser;
    private final Logger logger;
    @NotNull
    private final Set<String> knownConditions;

    public BlackboardWorldStateDeterminer(@NotNull ProcessContext processContext, @NotNull LogicalExpressionParser logicalExpressionParser) {
        Intrinsics.checkNotNullParameter((Object)processContext, (String)"processContext");
        Intrinsics.checkNotNullParameter((Object)logicalExpressionParser, (String)"logicalExpressionParser");
        this.processContext = processContext;
        this.logicalExpressionParser = logicalExpressionParser;
        this.logger = LoggerFactory.getLogger(BlackboardWorldStateDeterminer.class);
        this.knownConditions = this.processContext.getAgentProcess().getAgent().getPlanningSystem().knownConditions();
    }

    @Override
    @NotNull
    public BlackboardWorldState determineWorldState() {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = this.knownConditions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String condition2 = (String)element$iv;
            boolean bl = false;
            map.put(condition2, this.determineCondition(condition2));
        }
        return new BlackboardWorldState(ConditionWorldState.Companion.invoke(map), this.processContext.getBlackboard());
    }

    @Override
    @NotNull
    public ConditionDetermination determineCondition(@NotNull String condition2) {
        ConditionDetermination conditionDetermination;
        Object object;
        Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
        LogicalExpression logicalExpression = this.logicalExpressionParser.parse(condition2);
        if (logicalExpression != null) {
            v0 = logicalExpression.evaluate(this.processContext.getBlackboard());
        } else if (StringsKt.contains$default((CharSequence)condition2, (CharSequence)":", (boolean)false, (int)2, null)) {
            boolean bl;
            Map maybeMap;
            var5_3 = new String[]{":"};
            object = StringsKt.split$default((CharSequence)condition2, (String[])var5_3, (boolean)false, (int)0, (int)6, null);
            variable = (Object[])object.get(0);
            String type2 = (String)object.get(1);
            Object found = this.processContext.getBlackboard().get((String)variable);
            Map map = maybeMap = found instanceof Map ? (Map)found : null;
            if (maybeMap != null) {
                return ConditionDetermination.Companion.invoke(true);
            }
            Object value = this.processContext.getAgentProcess().getValue((String)variable, type2);
            if (Intrinsics.areEqual((Object)type2, (Object)"List")) {
                bl = value != null && value instanceof List;
            } else if (Intrinsics.areEqual((Object)variable, (Object)"all")) {
                bl = true;
            } else {
                boolean determination = value != null && BlackboardKt.satisfiesType(value, type2);
                Object[] objectArray = new Object[]{condition2, determination, variable, type2, value};
                this.logger.debug("Determined binding condition {}={}: variable={}, type={}, value={}", objectArray);
                bl = determination;
            }
            boolean determination = bl;
            v0 = ConditionDetermination.Companion.invoke(determination);
        } else if (StringsKt.startsWith$default((String)condition2, (String)"hasRun_", (boolean)false, (int)2, null)) {
            determination = ConditionDetermination.Companion.invoke(this.processContext.getBlackboard().getCondition(condition2)).asTrueOrFalse();
            variable = new Object[]{condition2, determination, CollectionsKt.sorted((Iterable)this.knownConditions), HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
            this.logger.debug("Determined hasRun condition {}={}: known conditions={}, bindings={}", variable);
            v0 = determination;
        } else {
            boolean bl;
            block17: {
                Iterable $this$any$iv = this.knownConditions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String knownCondition = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)knownCondition, (Object)condition2)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl && this.resolveAsAgentCondition(condition2) != null) {
                Condition condition3 = this.resolveAsAgentCondition(condition2);
                Intrinsics.checkNotNull((Object)condition3);
                Condition condition4 = condition3;
                ConditionDetermination determination = condition4.evaluate(OperationContext.Companion.invoke(this.processContext, condition4, SetsKt.emptySet()));
                Object[] objectArray = new Object[]{condition4, determination, HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
                this.logger.debug("Determined known condition {}={}, bindings={}", objectArray);
                v0 = determination;
            } else {
                determination = ConditionDetermination.Companion.invoke(this.processContext.getBlackboard().getCondition(condition2)).asTrueOrFalse();
                var5_3 = new Object[]{condition2, determination, CollectionsKt.sorted((Iterable)this.knownConditions), HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
                this.logger.debug("Looked for explicitly set condition: determined condition {}={}: known conditions={}, bindings={}", var5_3);
                v0 = conditionDetermination = determination;
            }
        }
        if (conditionDetermination == ConditionDetermination.UNKNOWN) {
            object = new Object[]{condition2, CollectionsKt.sorted((Iterable)this.knownConditions), HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
            this.logger.info("Determined condition {} to be unknown: knownConditions={}, bindings={}", (Object[])object);
        }
        return conditionDetermination;
    }

    private final Condition resolveAsAgentCondition(String condition2) {
        Object v1;
        block1: {
            Iterable iterable = this.processContext.getAgentProcess().getAgent().getConditions();
            for (Object t : iterable) {
                Condition it = (Condition)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getName(), (Object)condition2) || StringsKt.endsWith$default((String)it.getName(), (String)("." + condition2), (boolean)false, (int)2, null);
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }
}

