/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common;

import com.embabel.agent.api.common.StuckHandler;
import com.embabel.agent.api.common.StuckHandlerResult;
import com.embabel.agent.api.common.StuckHandlingResultCode;
import com.embabel.agent.core.AgentProcess;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/api/common/MulticastStuckHandler;", "Lcom/embabel/agent/api/common/StuckHandler;", "stuckHandlers", "", "<init>", "(Ljava/util/List;)V", "handleStuck", "Lcom/embabel/agent/api/common/StuckHandlerResult;", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "embabel-agent-api"})
public final class MulticastStuckHandler
implements StuckHandler {
    @NotNull
    private final List<StuckHandler> stuckHandlers;

    public MulticastStuckHandler(@NotNull List<? extends StuckHandler> stuckHandlers) {
        Intrinsics.checkNotNullParameter(stuckHandlers, (String)"stuckHandlers");
        this.stuckHandlers = stuckHandlers;
    }

    @Override
    @NotNull
    public StuckHandlerResult handleStuck(@NotNull AgentProcess agentProcess) {
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        for (StuckHandler handler : this.stuckHandlers) {
            StuckHandlerResult result = handler.handleStuck(agentProcess);
            if (result.getCode() == StuckHandlingResultCode.NO_RESOLUTION) continue;
            return result;
        }
        String string = "No stuck handler could resolve the issue: Tried " + CollectionsKt.joinToString$default((Iterable)this.stuckHandlers, (CharSequence)", ", null, null, (int)0, null, MulticastStuckHandler::handleStuck$lambda$0, (int)30, null);
        StuckHandlingResultCode stuckHandlingResultCode = StuckHandlingResultCode.NO_RESOLUTION;
        return new StuckHandlerResult(string, null, stuckHandlingResultCode, agentProcess);
    }

    private static final CharSequence handleStuck$lambda$0(StuckHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

