/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.file;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.common.support.SelfToolCallbackPublisher;
import com.embabel.agent.tools.DirectoryBased;
import com.embabel.agent.tools.file.FileAccessLog;
import com.embabel.agent.tools.file.FileChangeLog;
import com.embabel.agent.tools.file.FileModification;
import com.embabel.agent.tools.file.FileModificationType;
import com.embabel.agent.tools.file.FileTools;
import com.embabel.agent.tools.file.FileUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0017J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0017J \u0010\b\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\b\u0001\u0010\u000f\u001a\u00020\u00072\b\b\u0001\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0017J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0017J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/tools/file/FileWriteTools;", "Lcom/embabel/agent/tools/DirectoryBased;", "Lcom/embabel/agent/tools/file/FileAccessLog;", "Lcom/embabel/agent/tools/file/FileChangeLog;", "Lcom/embabel/agent/api/common/support/SelfToolCallbackPublisher;", "getPathsAccessed", "", "", "createFile", "path", "content", "Ljava/nio/file/Path;", "overwrite", "", "editFile", "oldContent", "newContent", "createDirectory", "appendFile", "appendToFile", "", "createIfNotExists", "delete", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nFileWriteTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWriteTools.kt\ncom/embabel/agent/tools/file/FileWriteTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1557#2:236\n1628#2,3:237\n*S KotlinDebug\n*F\n+ 1 FileWriteTools.kt\ncom/embabel/agent/tools/file/FileWriteTools\n*L\n36#1:236\n36#1:237,3\n*E\n"})
public interface FileWriteTools
extends DirectoryBased,
FileAccessLog,
FileChangeLog,
SelfToolCallbackPublisher {
    @NotNull
    public static final Companion Companion = com.embabel.agent.tools.file.FileWriteTools$Companion.$$INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    default public List<String> getPathsAccessed() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getChanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileModification fileModification = (FileModification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @LlmTool(description="Create a file with the given content")
    @NotNull
    default public String createFile(@NotNull String path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.createFile(path, content, false);
        this.recordChange(new FileModification(path, FileModificationType.CREATE));
        return "file created";
    }

    @NotNull
    default public Path createFile(@NotNull String path, @NotNull String content, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path resolvedPath = FileUtilsKt.resolvePath(this.getRoot(), path);
        if (Files.exists(resolvedPath, new LinkOption[0]) && !overwrite) {
            com.embabel.agent.tools.file.FileWriteTools$Companion.logger.warn("File already exists at {}", (Object)path);
            throw new IllegalArgumentException("File already exists: " + path);
        }
        Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
        Path path2 = Files.writeString(resolvedPath, (CharSequence)content, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"writeString(...)");
        return path2;
    }

    @LlmTool(description="Edit the file at the given location. Replace oldContent with newContent. oldContent is typically just a part of the file. e.g. use it to replace a particular method to add another method")
    @NotNull
    default public String editFile(@NotNull String path, @LlmTool.Param(description="content to replace") @NotNull String oldContent, @LlmTool.Param(description="replacement content") @NotNull String newContent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        com.embabel.agent.tools.file.FileWriteTools$Companion.logger.info("Editing file at path {}", (Object)path);
        Object[] objectArray = new Object[]{path, oldContent, newContent};
        com.embabel.agent.tools.file.FileWriteTools$Companion.logger.debug("File edit at path {}: {} -> {}", objectArray);
        Path resolvedPath = FileUtilsKt.resolveAndValidateFile(this.getRoot(), path);
        String oldFileContent = Files.readString(resolvedPath);
        Intrinsics.checkNotNull((Object)oldFileContent);
        String newFileContent = StringsKt.replace$default((String)oldFileContent, (String)oldContent, (String)newContent, (boolean)false, (int)4, null);
        if (!Intrinsics.areEqual((Object)newFileContent, (Object)oldFileContent)) {
            Files.writeString(resolvedPath, (CharSequence)newFileContent, new OpenOption[0]);
            com.embabel.agent.tools.file.FileWriteTools$Companion.logger.info("Edited file at {}", (Object)path);
            this.recordChange(new FileModification(path, FileModificationType.EDIT));
            return "file edited";
        }
        Object[] objectArray2 = new Object[]{resolvedPath, oldContent, newContent};
        com.embabel.agent.tools.file.FileWriteTools$Companion.logger.warn("editFile on {} produced no changes: oldContent=[{}], newContent=[{}]", objectArray2);
        return "no changes made";
    }

    @LlmTool(description="Create a directory at the given path")
    @NotNull
    default public String createDirectory(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path resolvedPath = FileUtilsKt.resolvePath(this.getRoot(), path);
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            if (Files.isDirectory(resolvedPath, new LinkOption[0])) {
                return "directory already exists";
            }
            throw new IllegalArgumentException("A file already exists at this path: " + path);
        }
        Files.createDirectories(resolvedPath, new FileAttribute[0]);
        com.embabel.agent.tools.file.FileWriteTools$Companion.logger.info("Created directory at path: " + path);
        this.recordChange(new FileModification(path, FileModificationType.CREATE_DIRECTORY));
        return "directory created";
    }

    @LlmTool(description="Append content to an existing file. The file must already exist.")
    @NotNull
    default public String appendFile(@NotNull String path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Path resolvedPath = FileUtilsKt.resolveAndValidateFile(this.getRoot(), path);
        OpenOption[] openOptionArray = content;
        byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        Files.write(resolvedPath, byArray, openOptionArray);
        com.embabel.agent.tools.file.FileWriteTools$Companion.logger.info("Appended content to file at path: " + path);
        this.recordChange(new FileModification(path, FileModificationType.APPEND));
        return "content appended to file";
    }

    default public void appendToFile(@NotNull String path, @NotNull String content, boolean createIfNotExists) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (createIfNotExists) {
            try {
                this.createFile(path, content, false);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.appendFile(path, content);
    }

    @LlmTool(description="Delete a file at the given path")
    @NotNull
    default public String delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path resolvedPath = FileUtilsKt.resolveAndValidateFile(this.getRoot(), path);
        Files.delete(resolvedPath);
        com.embabel.agent.tools.file.FileWriteTools$Companion.logger.info("Deleted file at path: " + path);
        this.recordChange(new FileModification(path, FileModificationType.DELETE));
        return "file deleted";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/tools/file/FileWriteTools$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "createTempDir", "Ljava/io/File;", "seed", "", "extractZipFile", "zipFile", "tempDir", "delete", "", "embabel-agent-api"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final Logger logger;

        private Companion() {
        }

        @NotNull
        public final File createTempDir(@NotNull String seed) {
            Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
            File tempDir = Files.createTempDirectory(seed, new FileAttribute[0]).toFile();
            String tempDirPath = tempDir.getAbsolutePath();
            logger.info("Created temporary directory at {}", (Object)tempDirPath);
            Intrinsics.checkNotNull((Object)tempDir);
            return tempDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final File extractZipFile(@NotNull File zipFile, @NotNull File tempDir, boolean delete) {
            boolean deleted;
            Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            File projectDir = tempDir;
            Closeable closeable = new ZipInputStream(new FileInputStream(zipFile));
            Throwable throwable = null;
            try {
                ZipInputStream zipInputStream = (ZipInputStream)closeable;
                boolean bl = false;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    File newFile = new File(projectDir, zipEntry.getName());
                    String canonicalPath = newFile.getCanonicalPath();
                    String string = projectDir.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                    String string2 = File.separator;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
                    String prefix = StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) ? projectDir.getCanonicalPath() : projectDir.getCanonicalPath() + File.separator;
                    Intrinsics.checkNotNull((Object)canonicalPath);
                    Intrinsics.checkNotNull((Object)prefix);
                    if (!StringsKt.startsWith((String)canonicalPath, (String)prefix, (boolean)false)) {
                        throw new IOException("Invalid zip entry name: " + zipEntry.getName());
                    }
                    if (zipEntry.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        newFile.getParentFile().mkdirs();
                        Closeable closeable2 = new FileOutputStream(newFile);
                        Throwable throwable2 = null;
                        try {
                            FileOutputStream fileOutputStream = (FileOutputStream)closeable2;
                            boolean bl2 = false;
                            Long l = ByteStreamsKt.copyTo$default((InputStream)zipInputStream, (OutputStream)fileOutputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            logger.info("Extracted zip file project to {}", (Object)projectDir.getAbsolutePath());
            if (delete && !(deleted = zipFile.delete())) {
                logger.warn("Failed to delete zip file at {}", (Object)zipFile.getAbsolutePath());
            }
            return new File(projectDir, FilesKt.getNameWithoutExtension((File)zipFile));
        }

        static {
            $$INSTANCE = new Companion();
            logger = LoggerFactory.getLogger(FileTools.class);
        }
    }
}

