/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.spi.support.springai.MaybeReturn;
import com.embabel.common.util.DummyInstanceCreator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ai.converter.StructuredOutputConverter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/spi/support/springai/WithExampleConverter;", "T", "Lorg/springframework/ai/converter/StructuredOutputConverter;", "delegate", "outputClass", "Ljava/lang/Class;", "ifPossible", "", "generateExamples", "<init>", "(Lorg/springframework/ai/converter/StructuredOutputConverter;Ljava/lang/Class;ZZ)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "convert", "source", "", "(Ljava/lang/String;)Ljava/lang/Object;", "getFormat", "embabel-agent-api"})
public final class WithExampleConverter<T>
implements StructuredOutputConverter<T> {
    @NotNull
    private final StructuredOutputConverter<T> delegate;
    @NotNull
    private final Class<T> outputClass;
    private final boolean ifPossible;
    private final boolean generateExamples;
    private final ObjectMapper objectMapper;

    public WithExampleConverter(@NotNull StructuredOutputConverter<T> delegate, @NotNull Class<T> outputClass, boolean ifPossible, boolean generateExamples) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        this.delegate = delegate;
        this.outputClass = outputClass;
        this.ifPossible = ifPossible;
        this.generateExamples = generateExamples;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    @Nullable
    public T convert(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return (T)this.delegate.convert((Object)source);
    }

    @NotNull
    public String getFormat() {
        Object object;
        if (!this.generateExamples) {
            String string = this.delegate.getFormat();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormat(...)");
            return string;
        }
        if (this.outputClass.isInterface()) {
            object = this.outputClass.getAnnotation(JsonDeserialize.class);
            if (object == null || (object = object.as()) == null) {
                throw new IllegalStateException(("An interface used for prompt return needs deserialization information: " + this.outputClass).toString());
            }
        } else {
            object = this.outputClass;
        }
        JsonDeserialize outputClassToUse = object;
        Object example = DummyInstanceCreator.Companion.getLoremIpsum().createDummyInstance((Class)outputClassToUse);
        return this.ifPossible ? StringsKt.trimMargin$default((String)("|\n               |Examples:\n               |   success:\n               |   " + this.objectMapper.writeValueAsString(new MaybeReturn(example, null, 2, null)) + "\n               |\n               |   failure:\n               |   " + this.objectMapper.writeValueAsString(new MaybeReturn(null, "Insufficient context to create this structure", 1, null)) + "\n               |\n               |" + this.delegate.getFormat() + "\n               |"), null, (int)1, null) : StringsKt.trimMargin$default((String)("|\n               |Example:\n               |" + this.objectMapper.writeValueAsString(example) + "\n               |\n               |" + this.delegate.getFormat() + "\n               |"), null, (int)1, null);
    }
}

