/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.api.tool.Tool;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.DefaultToolDefinition;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.metadata.DefaultToolMetadata;
import org.springframework.ai.tool.metadata.ToolMetadata;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/spi/support/springai/SpringToolCallbackAdapter;", "Lorg/springframework/ai/tool/ToolCallback;", "tool", "Lcom/embabel/agent/api/tool/Tool;", "<init>", "(Lcom/embabel/agent/api/tool/Tool;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "getToolDefinition", "Lorg/springframework/ai/tool/definition/ToolDefinition;", "getToolMetadata", "Lorg/springframework/ai/tool/metadata/ToolMetadata;", "call", "", "toolInput", "embabel-agent-api"})
public final class SpringToolCallbackAdapter
implements ToolCallback {
    @NotNull
    private final Tool tool;
    private final Logger logger;

    public SpringToolCallbackAdapter(@NotNull Tool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        this.tool = tool;
        this.logger = LoggerFactory.getLogger(SpringToolCallbackAdapter.class);
    }

    @NotNull
    public ToolDefinition getToolDefinition() {
        ToolDefinition toolDefinition = DefaultToolDefinition.builder().name(this.tool.getDefinition().getName()).description(this.tool.getDefinition().getDescription()).inputSchema(this.tool.getDefinition().getInputSchema().toJsonSchema()).build();
        Intrinsics.checkNotNullExpressionValue((Object)toolDefinition, (String)"build(...)");
        return toolDefinition;
    }

    @NotNull
    public ToolMetadata getToolMetadata() {
        ToolMetadata toolMetadata = DefaultToolMetadata.builder().returnDirect(this.tool.getMetadata().getReturnDirect()).build();
        Intrinsics.checkNotNullExpressionValue((Object)toolMetadata, (String)"build(...)");
        return toolMetadata;
    }

    @NotNull
    public String call(@NotNull String toolInput) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        this.logger.debug("Executing tool '{}' with input: {}", (Object)this.tool.getDefinition().getName(), (Object)toolInput);
        try {
            Object object2;
            Tool.Result result = this.tool.call(toolInput);
            if (result instanceof Tool.Result.Text) {
                object2 = ((Tool.Result.Text)result).getContent();
            } else if (result instanceof Tool.Result.WithArtifact) {
                object2 = ((Tool.Result.WithArtifact)result).getContent();
            } else if (result instanceof Tool.Result.Error) {
                this.logger.warn("Tool '{}' returned error: {}", (Object)this.tool.getDefinition().getName(), (Object)((Tool.Result.Error)result).getMessage());
                object2 = "ERROR: " + ((Tool.Result.Error)result).getMessage();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = object2;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{this.tool.getDefinition().getName(), e.getMessage(), e};
            this.logger.error("Tool '{}' threw exception: {}", objectArray);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            object = "ERROR: " + string;
        }
        return object;
    }
}

