/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.logging;

import com.embabel.agent.api.common.InteractionId;
import com.embabel.agent.api.event.ActionExecutionResultEvent;
import com.embabel.agent.api.event.ActionExecutionStartEvent;
import com.embabel.agent.api.event.AgentDeploymentEvent;
import com.embabel.agent.api.event.AgentPlatformEvent;
import com.embabel.agent.api.event.AgentProcessCreationEvent;
import com.embabel.agent.api.event.AgentProcessEvent;
import com.embabel.agent.api.event.AgentProcessFinishedEvent;
import com.embabel.agent.api.event.AgentProcessPlanFormulatedEvent;
import com.embabel.agent.api.event.AgentProcessReadyToPlanEvent;
import com.embabel.agent.api.event.AgentProcessStuckEvent;
import com.embabel.agent.api.event.AgentProcessWaitingEvent;
import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.api.event.DynamicAgentCreationEvent;
import com.embabel.agent.api.event.GoalAchievedEvent;
import com.embabel.agent.api.event.LlmRequestEvent;
import com.embabel.agent.api.event.LlmResponseEvent;
import com.embabel.agent.api.event.ObjectAddedEvent;
import com.embabel.agent.api.event.ObjectBoundEvent;
import com.embabel.agent.api.event.ProcessKilledEvent;
import com.embabel.agent.api.event.ProgressUpdateEvent;
import com.embabel.agent.api.event.RankingChoiceCouldNotBeMadeEvent;
import com.embabel.agent.api.event.RankingChoiceMadeEvent;
import com.embabel.agent.api.event.RankingChoiceRequestEvent;
import com.embabel.agent.api.event.StateTransitionEvent;
import com.embabel.agent.api.event.ToolCallRequestEvent;
import com.embabel.agent.api.event.ToolCallResponseEvent;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcessStatusCode;
import com.embabel.agent.core.EarlyTermination;
import com.embabel.agent.spi.logging.ColorPalette;
import com.embabel.agent.spi.logging.DefaultColorPalette;
import com.embabel.agent.spi.logging.LoggingPersonality;
import com.embabel.agent.spi.support.springai.ChatModelCallEvent;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.AnsiBuilderKt;
import com.embabel.common.util.FormatUtilsKt;
import com.embabel.common.util.StringTrimmingUtilsKt;
import com.embabel.plan.WorldState;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.tool.ToolCallback;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0014J\u0014\u0010\u0019\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0014J\u0014\u0010\u001b\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u000200H\u0014J\u0018\u00101\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u0002022\u0006\u00103\u001a\u00020\u0004H\u0014J\u001a\u00104\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u0002022\b\u00105\u001a\u0004\u0018\u000106H\u0014J\u0010\u00107\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u000208H\u0014J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020;H\u0014J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020=H\u0014J\u0010\u0010>\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020?H\u0014J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020AH\u0014J\u0014\u0010B\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030CH\u0014J\u0014\u0010D\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030EH\u0014J\u0014\u0010F\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030GH\u0014J\u0010\u0010H\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020IH\u0014J\u0010\u0010J\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020KH\u0014J\u0010\u0010L\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020MH\u0014J\u0010\u0010N\u001a\u00020 2\u0006\u0010!\u001a\u00020OH\u0016J\n\u0010P\u001a\u00020\u0004*\u00020QR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006R"}, d2={"Lcom/embabel/agent/spi/logging/LoggingAgenticEventListener;", "Lcom/embabel/agent/api/event/AgenticEventListener;", "Lcom/embabel/agent/spi/logging/LoggingPersonality;", "url", "", "welcomeMessage", "logger", "Lorg/slf4j/Logger;", "colorPalette", "Lcom/embabel/agent/spi/logging/ColorPalette;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/slf4j/Logger;Lcom/embabel/agent/spi/logging/ColorPalette;)V", "getLogger", "()Lorg/slf4j/Logger;", "getColorPalette", "()Lcom/embabel/agent/spi/logging/ColorPalette;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getAgentDeploymentEventMessage", "e", "Lcom/embabel/agent/api/event/AgentDeploymentEvent;", "getRankingChoiceRequestEventMessage", "Lcom/embabel/agent/api/event/RankingChoiceRequestEvent;", "getRankingChoiceMadeEventMessage", "Lcom/embabel/agent/api/event/RankingChoiceMadeEvent;", "getRankingChoiceNotMadeEventMessage", "Lcom/embabel/agent/api/event/RankingChoiceCouldNotBeMadeEvent;", "getDynamicAgentCreationMessage", "Lcom/embabel/agent/api/event/DynamicAgentCreationEvent;", "onPlatformEvent", "", "event", "Lcom/embabel/agent/api/event/AgentPlatformEvent;", "getAgentProcessCreationEventMessage", "Lcom/embabel/agent/api/event/AgentProcessCreationEvent;", "getAgentProcessReadyToPlanEventMessage", "Lcom/embabel/agent/api/event/AgentProcessReadyToPlanEvent;", "getAgentProcessPlanFormulatedEventMessage", "Lcom/embabel/agent/api/event/AgentProcessPlanFormulatedEvent;", "getStateTransitionEventMessage", "Lcom/embabel/agent/api/event/StateTransitionEvent;", "getEarlyTerminationMessage", "Lcom/embabel/agent/core/EarlyTermination;", "getGoalAchievedEventMessage", "Lcom/embabel/agent/api/event/GoalAchievedEvent;", "getToolCallRequestEventMessage", "Lcom/embabel/agent/api/event/ToolCallRequestEvent;", "getToolCallSuccessResponseEventMessage", "Lcom/embabel/agent/api/event/ToolCallResponseEvent;", "resultToShow", "getToolCallFailureResponseEventMessage", "throwable", "", "getProcessCompletionMessage", "Lcom/embabel/agent/api/event/AgentProcessFinishedEvent;", "getProcessFailureMessage", "getAgentProcessWaitingEventMessage", "Lcom/embabel/agent/api/event/AgentProcessWaitingEvent;", "getAgentProcessStuckEventMessage", "Lcom/embabel/agent/api/event/AgentProcessStuckEvent;", "getObjectAddedEventMessage", "Lcom/embabel/agent/api/event/ObjectAddedEvent;", "getObjectBoundEventMessage", "Lcom/embabel/agent/api/event/ObjectBoundEvent;", "getLlmRequestEventMessage", "Lcom/embabel/agent/api/event/LlmRequestEvent;", "getChatModelCallEventMessage", "Lcom/embabel/agent/spi/support/springai/ChatModelCallEvent;", "getLlmResponseEventMessage", "Lcom/embabel/agent/api/event/LlmResponseEvent;", "getActionExecutionStartMessage", "Lcom/embabel/agent/api/event/ActionExecutionStartEvent;", "getActionExecutionResultMessage", "Lcom/embabel/agent/api/event/ActionExecutionResultEvent;", "getProgressUpdateEventMessage", "Lcom/embabel/agent/api/event/ProgressUpdateEvent;", "onProcessEvent", "Lcom/embabel/agent/api/event/AgentProcessEvent;", "toInfoString", "Lorg/springframework/ai/chat/prompt/Prompt;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nLoggingAgenticEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingAgenticEventListener.kt\ncom/embabel/agent/spi/logging/LoggingAgenticEventListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public class LoggingAgenticEventListener
implements AgenticEventListener,
LoggingPersonality {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ColorPalette colorPalette;
    private final ObjectMapper objectMapper;

    public LoggingAgenticEventListener(@Nullable String url, @Nullable String welcomeMessage, @NotNull Logger logger, @NotNull ColorPalette colorPalette) {
        String it;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        this.logger = logger;
        this.colorPalette = colorPalette;
        String string = welcomeMessage;
        if (string != null) {
            it = string;
            boolean bl = false;
            this.getLogger().info(it);
        }
        String string2 = url;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.getLogger().info(AnsiBuilderKt.color((String)url, (String)"34") + "\n");
        }
        this.objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    public /* synthetic */ LoggingAgenticEventListener(String string, String string2, Logger logger, ColorPalette colorPalette, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            logger = LoggerFactory.getLogger((String)"Embabel");
        }
        if ((n & 8) != 0) {
            colorPalette = new DefaultColorPalette(0, 0, 3, null);
        }
        this(string, string2, logger, colorPalette);
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    @NotNull
    protected String getAgentDeploymentEventMessage(@NotNull AgentDeploymentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "Deployed agent " + e.getAgent().getName() + "\n\tdescription: " + e.getAgent().getDescription();
    }

    @NotNull
    protected String getRankingChoiceRequestEventMessage(@NotNull RankingChoiceRequestEvent<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return "Choosing " + e.getType().getSimpleName() + " based on " + e.getBasis();
    }

    @NotNull
    protected String getRankingChoiceMadeEventMessage(@NotNull RankingChoiceMadeEvent<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|Chose " + e.getType().getSimpleName() + " '" + e.getChoice().getMatch().getName() + "' with confidence " + e.getChoice().getScore() + " based on " + e.getBasis() + ".\n           |Choices:\n           |" + HasInfoString.infoString$default((HasInfoString)e.getRankings(), null, (int)1, (int)1, null) + "\n           |"), null, (int)1, null), (int)1, (boolean)false, (boolean)true, null, (int)10, null);
    }

    @NotNull
    protected String getRankingChoiceNotMadeEventMessage(@NotNull RankingChoiceCouldNotBeMadeEvent<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|Failed to choose " + e.getType().getSimpleName() + " based on " + e.getBasis() + ".\n           |Choices:\n           |" + HasInfoString.infoString$default((HasInfoString)e.getRankings(), null, (int)0, (int)3, null) + ".\n           |Confidence cutoff: " + e.getConfidenceCutOff()), null, (int)1, null), (int)1, (boolean)false, (boolean)true, null, (int)10, null);
    }

    @NotNull
    protected String getDynamicAgentCreationMessage(@NotNull DynamicAgentCreationEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|Created agent:\n           |" + e.getAgent().infoString(true, 1) + "\n           |"), null, (int)1, null), (int)1, (boolean)false, (boolean)true, null, (int)10, null);
    }

    @Override
    public void onPlatformEvent(@NotNull AgentPlatformEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AgentPlatformEvent agentPlatformEvent = event;
        if (agentPlatformEvent instanceof AgentDeploymentEvent) {
            this.getLogger().info(this.getAgentDeploymentEventMessage((AgentDeploymentEvent)event));
        } else if (agentPlatformEvent instanceof RankingChoiceRequestEvent) {
            this.getLogger().info(this.getRankingChoiceRequestEventMessage((RankingChoiceRequestEvent)event));
        } else if (agentPlatformEvent instanceof RankingChoiceMadeEvent) {
            this.getLogger().info(this.getRankingChoiceMadeEventMessage((RankingChoiceMadeEvent)event));
        } else if (agentPlatformEvent instanceof RankingChoiceCouldNotBeMadeEvent) {
            this.getLogger().info(this.getRankingChoiceNotMadeEventMessage((RankingChoiceCouldNotBeMadeEvent)event));
        } else if (agentPlatformEvent instanceof DynamicAgentCreationEvent) {
            this.getLogger().info(this.getDynamicAgentCreationMessage((DynamicAgentCreationEvent)event));
        }
    }

    @NotNull
    protected String getAgentProcessCreationEventMessage(@NotNull AgentProcessCreationEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] created";
    }

    @NotNull
    protected String getAgentProcessReadyToPlanEventMessage(@NotNull AgentProcessReadyToPlanEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|[" + e.getProcessId() + "] ready to plan from:\n           |" + e.getWorldState().infoString(e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getShowLongPlans(), 1) + "\n           |"), null, (int)1, null), (int)1, (boolean)false, (boolean)true, null, (int)10, null);
    }

    @NotNull
    protected String getAgentProcessPlanFormulatedEventMessage(@NotNull AgentProcessPlanFormulatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|[" + e.getProcessId() + "] formulated plan:\n           |" + e.getPlan().infoString(e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getShowLongPlans(), 1) + "\n           |from:\n           |" + e.getWorldState().infoString(true, 1) + "\n           |"), null, (int)1, null), (int)1, (boolean)false, (boolean)true, null, (int)10, null);
    }

    @NotNull
    protected String getStateTransitionEventMessage(@NotNull StateTransitionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] transitioned to state: " + e.getNewState();
    }

    @NotNull
    protected String getEarlyTerminationMessage(@NotNull EarlyTermination e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] early termination by " + e.getPolicy() + " for " + e.getReason() + " - error=" + e.getError();
    }

    @NotNull
    protected String getGoalAchievedEventMessage(@NotNull GoalAchievedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] goal " + e.getGoal().getName() + " achieved in " + e.getAgentProcess().getRunningTime();
    }

    @NotNull
    protected String getToolCallRequestEventMessage(@NotNull ToolCallRequestEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Action action = e.getAction();
        return "[" + e.getProcessId() + "] (" + (action != null ? action.shortName() : null) + ") calling tool " + e.getTool() + "(" + e.getToolInput() + ")";
    }

    @NotNull
    protected String getToolCallSuccessResponseEventMessage(@NotNull ToolCallResponseEvent e, @NotNull String resultToShow) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)resultToShow, (String)"resultToShow");
        Action action = e.getRequest().getAction();
        return "[" + e.getProcessId() + "] (" + (action != null ? action.shortName() : null) + ") tool " + e.getRequest().getTool() + " returned " + resultToShow + " in " + e.getRunningTime().toMillis() + "ms with payload " + e.getRequest().getToolInput();
    }

    @NotNull
    protected String getToolCallFailureResponseEventMessage(@NotNull ToolCallResponseEvent e, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Action action = e.getRequest().getAction();
        return "[" + e.getProcessId() + "] (" + (action != null ? action.shortName() : null) + ") failed tool " + e.getRequest().getTool() + " -> " + throwable + " in " + e.getRunningTime().toMillis() + "ms with payload " + e.getRequest().getToolInput();
    }

    @NotNull
    protected String getProcessCompletionMessage(@NotNull AgentProcessFinishedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] completed in " + e.getAgentProcess().getRunningTime();
    }

    @NotNull
    protected String getProcessFailureMessage(@NotNull AgentProcessFinishedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] failed";
    }

    @NotNull
    protected String getAgentProcessWaitingEventMessage(@NotNull AgentProcessWaitingEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] waiting";
    }

    @NotNull
    protected String getAgentProcessStuckEventMessage(@NotNull AgentProcessStuckEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getAgentProcess().getProcessOptions().getPlannerType().getNeedsGoals()) {
            WorldState worldState = e.getAgentProcess().getLastWorldState();
            return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|[" + e.getProcessId() + "] stuck at:\n           |" + (worldState != null ? worldState.infoString(e.getAgentProcess().getProcessOptions().getVerbosity().getShowLongPlans(), 1) : null) + "\n           |"), null, (int)1, null), (int)1, (boolean)false, (boolean)true, null, (int)10, null);
        }
        return "[" + e.getProcessId() + "] has no available actions to progress: This is not an error";
    }

    @NotNull
    protected String getObjectAddedEventMessage(@NotNull ObjectAddedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] object added: " + (e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getDebug() ? e.getValue() : e.getValue().getClass().getSimpleName());
    }

    @NotNull
    protected String getObjectBoundEventMessage(@NotNull ObjectBoundEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] object bound " + e.getName() + ":" + (e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getDebug() ? e.getValue() : e.getValue().getClass().getSimpleName());
    }

    @NotNull
    protected String getLlmRequestEventMessage(@NotNull LlmRequestEvent<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return "[" + e.getProcessId() + "] (" + e.getInteraction().getId-Ti10f1E() + ") using LLM " + e.getLlm().getName() + ", creating " + e.getOutputClass().getSimpleName() + ": " + e.getInteraction().getLlm();
    }

    @NotNull
    protected String getChatModelCallEventMessage(@NotNull ChatModelCallEvent<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        String promptInfo = "using " + AnsiBuilderKt.color((String)e.getLlm().getName(), (int)this.getColorPalette().getHighlight()) + "\n" + AnsiBuilderKt.color((String)this.toInfoString(e.getSpringAiPrompt()), (String)"32") + "\nprompt id: '" + InteractionId.toString-impl(e.getInteraction().getId-Ti10f1E()) + "'\ntools: [\n" + AnsiBuilderKt.color((String)CollectionsKt.joinToString$default((Iterable)e.getInteraction().getToolCallbacks(), (CharSequence)"\n----\n", null, null, (int)0, null, LoggingAgenticEventListener::getChatModelCallEventMessage$lambda$2, (int)30, null), (int)this.getColorPalette().getHighlight()) + "]";
        return e.getProcessId() + " Spring AI ChatModel call:\n" + promptInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getLlmResponseEventMessage(@NotNull LlmResponseEvent<?> e) {
        Object object;
        String string;
        String string2;
        block5: {
            block4: {
                void it;
                Intrinsics.checkNotNullParameter(e, (String)"e");
                string2 = e.getProcessId();
                string = e.getRequest().getInteraction().getId-Ti10f1E();
                object = e.getResponse();
                if (object == null) break block4;
                Object obj = object;
                String string3 = string;
                String string4 = string2;
                boolean bl = false;
                String string5 = it.getClass().getSimpleName();
                string2 = string4;
                string = string3;
                String string6 = string5;
                object = string6;
                if (string6 != null) break block5;
            }
            object = "null";
        }
        String message = "[" + string2 + "] (" + string + ") received LLM response of type " + object + " from " + e.getRequest().getInteraction().getLlm().getCriteria() + " in " + e.getRunningTime().getSeconds() + " seconds";
        if (e.getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getShowLlmResponses()) {
            String string7 = InteractionId.toString-impl(e.getRequest().getInteraction().getId-Ti10f1E());
            String string8 = this.objectMapper.writeValueAsString(e.getResponse());
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"writeValueAsString(...)");
            message = message + "\nResponse from prompt " + string7 + ":\n" + AnsiBuilderKt.color((String)string8, (String)"33");
        }
        return message;
    }

    @NotNull
    protected String getActionExecutionStartMessage(@NotNull ActionExecutionStartEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] executing action " + e.getAction().getName();
    }

    @NotNull
    protected String getActionExecutionResultMessage(@NotNull ActionExecutionResultEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] executed action " + e.getAction().getName() + " in " + e.getActionStatus().getRunningTime();
    }

    @NotNull
    protected String getProgressUpdateEventMessage(@NotNull ProgressUpdateEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "[" + e.getProcessId() + "] progress: " + AnsiBuilderKt.color((String)e.createProgressBar(50), (int)12498816);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onProcessEvent(@NotNull AgentProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AgentProcessEvent agentProcessEvent = event;
        if (agentProcessEvent instanceof AgentProcessCreationEvent) {
            this.getLogger().info(this.getAgentProcessCreationEventMessage((AgentProcessCreationEvent)event));
            return;
        } else if (agentProcessEvent instanceof AgentProcessReadyToPlanEvent) {
            this.getLogger().info(this.getAgentProcessReadyToPlanEventMessage((AgentProcessReadyToPlanEvent)event));
            return;
        } else if (agentProcessEvent instanceof AgentProcessPlanFormulatedEvent) {
            this.getLogger().info(this.getAgentProcessPlanFormulatedEventMessage((AgentProcessPlanFormulatedEvent)event));
            return;
        } else if (agentProcessEvent instanceof StateTransitionEvent) {
            this.getLogger().info(this.getStateTransitionEventMessage((StateTransitionEvent)event));
            return;
        } else if (agentProcessEvent instanceof EarlyTermination) {
            this.getLogger().info(this.getEarlyTerminationMessage((EarlyTermination)event));
            return;
        } else if (agentProcessEvent instanceof GoalAchievedEvent) {
            this.getLogger().info(this.getGoalAchievedEventMessage((GoalAchievedEvent)event));
            return;
        } else if (agentProcessEvent instanceof ToolCallRequestEvent) {
            this.getLogger().info(this.getToolCallRequestEventMessage((ToolCallRequestEvent)event));
            return;
        } else if (agentProcessEvent instanceof ToolCallResponseEvent) {
            boolean bl = Result.isSuccess-impl((Object)((ToolCallResponseEvent)event).getResult-d1pmJ48());
            if (bl) {
                Object object = ((ToolCallResponseEvent)event).getResult-d1pmJ48();
                ResultKt.throwOnFailure((Object)object);
                String raw = (String)object;
                String resultToShow = ((ToolCallResponseEvent)event).getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getShowPrompts() ? raw : StringTrimmingUtilsKt.trim$default((String)raw, (int)80, (int)5, null, (int)8, null);
                Logger logger = this.getLogger();
                ToolCallResponseEvent toolCallResponseEvent = (ToolCallResponseEvent)event;
                String string = resultToShow;
                if (string == null) {
                    string = "null";
                }
                logger.info(this.getToolCallSuccessResponseEventMessage(toolCallResponseEvent, string));
                return;
            } else {
                if (bl) throw new NoWhenBranchMatchedException();
                Throwable throwable = Result.exceptionOrNull-impl((Object)((ToolCallResponseEvent)event).getResult-d1pmJ48());
                this.getLogger().info(this.getToolCallFailureResponseEventMessage((ToolCallResponseEvent)event, throwable));
                Throwable throwable2 = throwable;
                if (throwable2 == null) return;
                Throwable it = throwable2;
                boolean bl2 = false;
                this.getLogger().debug("Error in function call {}", (Object)((ToolCallResponseEvent)event).getProcessId(), (Object)it);
            }
            return;
        } else if (agentProcessEvent instanceof AgentProcessFinishedEvent) {
            switch (WhenMappings.$EnumSwitchMapping$0[((AgentProcessStatusCode)((AgentProcessFinishedEvent)event).getAgentProcess().getStatus()).ordinal()]) {
                case 1: {
                    this.getLogger().info(this.getProcessCompletionMessage((AgentProcessFinishedEvent)event));
                    return;
                }
                case 2: {
                    this.getLogger().info(this.getProcessFailureMessage((AgentProcessFinishedEvent)event));
                }
                default: {
                    return;
                }
            }
        } else if (agentProcessEvent instanceof AgentProcessWaitingEvent) {
            this.getLogger().info(this.getAgentProcessWaitingEventMessage((AgentProcessWaitingEvent)event));
            return;
        } else if (agentProcessEvent instanceof AgentProcessStuckEvent) {
            this.getLogger().info(this.getAgentProcessStuckEventMessage((AgentProcessStuckEvent)event));
            return;
        } else if (agentProcessEvent instanceof ObjectAddedEvent) {
            this.getLogger().info(this.getObjectAddedEventMessage((ObjectAddedEvent)event));
            return;
        } else if (agentProcessEvent instanceof ObjectBoundEvent) {
            this.getLogger().info(this.getObjectBoundEventMessage((ObjectBoundEvent)event));
            return;
        } else if (agentProcessEvent instanceof LlmRequestEvent) {
            this.getLogger().info(this.getLlmRequestEventMessage((LlmRequestEvent)event));
            return;
        } else if (agentProcessEvent instanceof ChatModelCallEvent) {
            if (!((ChatModelCallEvent)event).getAgentProcess().getProcessContext().getProcessOptions().getVerbosity().getShowPrompts()) return;
            this.getLogger().info(this.getChatModelCallEventMessage((ChatModelCallEvent)event));
            return;
        } else if (agentProcessEvent instanceof LlmResponseEvent) {
            this.getLogger().info(this.getLlmResponseEventMessage((LlmResponseEvent)event));
            return;
        } else if (agentProcessEvent instanceof ActionExecutionStartEvent) {
            this.getLogger().info(this.getActionExecutionStartMessage((ActionExecutionStartEvent)event));
            return;
        } else if (agentProcessEvent instanceof ActionExecutionResultEvent) {
            this.getLogger().info(this.getActionExecutionResultMessage((ActionExecutionResultEvent)event));
            return;
        } else if (agentProcessEvent instanceof ProgressUpdateEvent) {
            this.getLogger().info(this.getProgressUpdateEventMessage((ProgressUpdateEvent)event));
            return;
        } else {
            if (!(agentProcessEvent instanceof ProcessKilledEvent)) return;
            this.getLogger().info("[" + ((ProcessKilledEvent)event).getProcessId() + "] process killed");
        }
    }

    @NotNull
    public final String toInfoString(@NotNull Prompt $this$toInfoString) {
        Intrinsics.checkNotNullParameter((Object)$this$toInfoString, (String)"<this>");
        String bannerChar = ".";
        String string = LoggingPersonality.lineSeparator$default(this, "Messages ", bannerChar, null, 4, null);
        List list = $this$toInfoString.getInstructions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstructions(...)");
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|" + string + "\n                  |" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)("\n" + LoggingPersonality.lineSeparator$default(this, "", bannerChar, null, 4, null) + "\n"), null, null, (int)0, null, LoggingAgenticEventListener::toInfoString$lambda$5, (int)30, null) + "\n                  |" + LoggingPersonality.lineSeparator$default(this, "Options", bannerChar, null, 4, null) + "\n                  |" + $this$toInfoString.getOptions() + "\n                  |"), null, (int)1, null), (int)1, (boolean)false, (boolean)false, null, (int)14, null);
    }

    private static final CharSequence getChatModelCallEventMessage$lambda$2(ToolCallback it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getToolDefinition().name() + ": " + it.getToolDefinition().description();
    }

    private static final CharSequence toInfoString$lambda$5(Message it) {
        return it.getMessageType() + " <" + it.getText() + ">";
    }

    public LoggingAgenticEventListener() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AgentProcessStatusCode.values().length];
            try {
                nArray[AgentProcessStatusCode.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

