/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.config.spring.migration;

import com.embabel.agent.spi.config.spring.migration.DeprecatedPropertyWarningConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"embabel.agent.platform.migration.warnings.enabled"}, havingValue="true", matchIfMissing=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\f\b\u0017\u0018\u0000 -2\u00020\u0001:\u0004*+,-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0016J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"H\u0016J\b\u0010#\u001a\u00020\u0011H\u0016J*\u0010$\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\fH\u0012J\"\u0010&\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0012J \u0010'\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0012J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner;", "", "environment", "Lorg/springframework/core/env/Environment;", "warningConfig", "Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyWarningConfig;", "<init>", "(Lorg/springframework/core/env/Environment;Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyWarningConfig;)V", "enableIndividualLogging", "", "warnedProperties", "", "", "deprecationDetails", "", "Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationInfo;", "warnDeprecatedProperty", "", "deprecatedProperty", "recommendedProperty", "deprecationReason", "warnDeprecatedProfile", "deprecatedProfile", "warnDeprecatedConfigurationProperties", "className", "annotationDetails", "recommendedApproach", "warnDeprecatedConditional", "logAggregatedSummary", "getDeprecationCategories", "Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationCategories;", "getWarningCount", "", "getWarnedItems", "", "clearWarnings", "buildDeprecatedPropertyMessage", "propertyValue", "buildDeprecatedProfileMessage", "buildDeprecatedConditionalMessage", "buildAggregatedSummaryMessage", "categories", "DeprecationInfo", "DeprecationType", "DeprecationCategories", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nSimpleDeprecatedConfigWarner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleDeprecatedConfigWarner.kt\ncom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1485#2:335\n1510#2,3:336\n1513#2,3:346\n1863#2,2:350\n1863#2,2:352\n381#3,7:339\n1#4:349\n*S KotlinDebug\n*F\n+ 1 SimpleDeprecatedConfigWarner.kt\ncom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner\n*L\n205#1:335\n205#1:336,3\n205#1:346,3\n290#1:350,2\n297#1:352,2\n205#1:339,7\n*E\n"})
public class SimpleDeprecatedConfigWarner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Environment environment;
    @NotNull
    private final DeprecatedPropertyWarningConfig warningConfig;
    private final boolean enableIndividualLogging;
    @NotNull
    private final Set<String> warnedProperties;
    @NotNull
    private final Map<String, DeprecationInfo> deprecationDetails;
    private static final Logger logger = LoggerFactory.getLogger(SimpleDeprecatedConfigWarner.class);

    public SimpleDeprecatedConfigWarner(@NotNull Environment environment, @NotNull DeprecatedPropertyWarningConfig warningConfig) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)warningConfig, (String)"warningConfig");
        this.environment = environment;
        this.warningConfig = warningConfig;
        this.enableIndividualLogging = this.warningConfig.getIndividualLogging();
        this.warnedProperties = new LinkedHashSet();
        this.deprecationDetails = new LinkedHashMap();
    }

    public void warnDeprecatedProperty(@NotNull String deprecatedProperty, @NotNull String recommendedProperty, @Nullable String deprecationReason) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)deprecatedProperty, (String)"deprecatedProperty");
            Intrinsics.checkNotNullParameter((Object)recommendedProperty, (String)"recommendedProperty");
            if (this.warnedProperties.contains(deprecatedProperty)) {
                return;
            }
            String string = this.environment.getProperty(deprecatedProperty);
            if (string == null) break block2;
            String propertyValue = string;
            boolean bl = false;
            this.warnedProperties.add(deprecatedProperty);
            this.deprecationDetails.put(deprecatedProperty, new DeprecationInfo(DeprecationType.PROPERTY, deprecatedProperty, recommendedProperty, deprecationReason));
            String message = this.buildDeprecatedPropertyMessage(deprecatedProperty, recommendedProperty, deprecationReason, propertyValue);
            if (this.enableIndividualLogging) {
                logger.warn(message);
            }
        }
    }

    public static /* synthetic */ void warnDeprecatedProperty$default(SimpleDeprecatedConfigWarner simpleDeprecatedConfigWarner, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warnDeprecatedProperty");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        simpleDeprecatedConfigWarner.warnDeprecatedProperty(string, string2, string3);
    }

    public void warnDeprecatedProfile(@NotNull String deprecatedProfile, @NotNull String recommendedProperty, @Nullable String deprecationReason) {
        Intrinsics.checkNotNullParameter((Object)deprecatedProfile, (String)"deprecatedProfile");
        Intrinsics.checkNotNullParameter((Object)recommendedProperty, (String)"recommendedProperty");
        String warningKey = "PROFILE:" + deprecatedProfile;
        if (this.warnedProperties.contains(warningKey)) {
            return;
        }
        String[] stringArray = this.environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        if (ArraysKt.contains((Object[])stringArray, (Object)deprecatedProfile)) {
            this.warnedProperties.add(warningKey);
            this.deprecationDetails.put(warningKey, new DeprecationInfo(DeprecationType.PROFILE, deprecatedProfile, recommendedProperty + "=true", deprecationReason));
            String message = this.buildDeprecatedProfileMessage(deprecatedProfile, recommendedProperty, deprecationReason);
            if (this.enableIndividualLogging) {
                logger.warn(message);
            }
        }
    }

    public static /* synthetic */ void warnDeprecatedProfile$default(SimpleDeprecatedConfigWarner simpleDeprecatedConfigWarner, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warnDeprecatedProfile");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        simpleDeprecatedConfigWarner.warnDeprecatedProfile(string, string2, string3);
    }

    public void warnDeprecatedConfigurationProperties(@NotNull String className, @NotNull String annotationDetails, @NotNull String recommendedApproach) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)annotationDetails, (String)"annotationDetails");
        Intrinsics.checkNotNullParameter((Object)recommendedApproach, (String)"recommendedApproach");
        String warningKey = "CONFIG_PROPS:" + className;
        if (this.warnedProperties.contains(warningKey)) {
            return;
        }
        this.warnedProperties.add(warningKey);
        this.deprecationDetails.put(warningKey, new DeprecationInfo(DeprecationType.CONFIGURATION_PROPERTIES, className, recommendedApproach, "@ConfigurationProperties prefix migration"));
        if (this.enableIndividualLogging) {
            String message = StringsKt.trimMargin$default((String)("\n                |DEPRECATED @CONFIGURATIONPROPERTIES USAGE: Class '" + className + "' uses deprecated @ConfigurationProperties prefix: " + annotationDetails + ". Please migrate to: " + recommendedApproach + "\n                "), null, (int)1, null);
            logger.warn(message);
        }
    }

    public void warnDeprecatedConditional(@NotNull String className, @NotNull String annotationDetails, @NotNull String recommendedApproach) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)annotationDetails, (String)"annotationDetails");
        Intrinsics.checkNotNullParameter((Object)recommendedApproach, (String)"recommendedApproach");
        String warningKey = "CONDITIONAL:" + className;
        if (this.warnedProperties.contains(warningKey)) {
            return;
        }
        this.warnedProperties.add(warningKey);
        this.deprecationDetails.put(warningKey, new DeprecationInfo(DeprecationType.CONDITIONAL, className, recommendedApproach, "Conditional annotation migration"));
        String message = this.buildDeprecatedConditionalMessage(className, annotationDetails, recommendedApproach);
        if (this.enableIndividualLogging) {
            logger.warn(message);
        }
    }

    public void logAggregatedSummary() {
        if (this.deprecationDetails.isEmpty()) {
            return;
        }
        DeprecationCategories categories = this.getDeprecationCategories();
        String message = this.buildAggregatedSummaryMessage(categories);
        logger.warn(message);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DeprecationCategories getDeprecationCategories() {
        List list;
        List list2;
        List list3;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.deprecationDetails.values();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DeprecationInfo it = (DeprecationInfo)element$iv$iv;
            boolean bl = false;
            DeprecationType key$iv$iv = it.getType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map grouped = destination$iv$iv;
        List list4 = (List)grouped.get((Object)DeprecationType.PROPERTY);
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        if ((list3 = (List)grouped.get((Object)DeprecationType.PROFILE)) == null) {
            list3 = CollectionsKt.emptyList();
        }
        if ((list2 = (List)grouped.get((Object)DeprecationType.CONDITIONAL)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((list = (List)grouped.get((Object)DeprecationType.CONFIGURATION_PROPERTIES)) == null) {
            list = CollectionsKt.emptyList();
        }
        return new DeprecationCategories(list4, list3, list2, list);
    }

    public int getWarningCount() {
        return this.warnedProperties.size();
    }

    @NotNull
    public Set<String> getWarnedItems() {
        return CollectionsKt.toSet((Iterable)this.warnedProperties);
    }

    public void clearWarnings() {
        this.warnedProperties.clear();
        this.deprecationDetails.clear();
    }

    private String buildDeprecatedPropertyMessage(String deprecatedProperty, String recommendedProperty, String deprecationReason, String propertyValue) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildDeprecatedPropertyMessage_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildDeprecatedPropertyMessage_u24lambda_u243.append("DEPRECATED PROPERTY USAGE: Property '" + deprecatedProperty + "' is deprecated and will be removed in a future version.");
        $this$buildDeprecatedPropertyMessage_u24lambda_u243.append(" Please migrate to '" + recommendedProperty + "' instead.");
        String string = deprecationReason;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$buildDeprecatedPropertyMessage_u24lambda_u243.append(" Reason: " + it);
        }
        $this$buildDeprecatedPropertyMessage_u24lambda_u243.append(" Current value: '" + propertyValue + "'");
        return stringBuilder.toString();
    }

    private String buildDeprecatedProfileMessage(String deprecatedProfile, String recommendedProperty, String deprecationReason) {
        StringBuilder stringBuilder;
        block0: {
            StringBuilder $this$buildDeprecatedProfileMessage_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$buildDeprecatedProfileMessage_u24lambda_u245.append("DEPRECATED PROFILE USAGE: Profile '" + deprecatedProfile + "' is deprecated and will be removed in a future version.");
            $this$buildDeprecatedProfileMessage_u24lambda_u245.append(" Please migrate to property-based configuration using '" + recommendedProperty + "=true' instead.");
            String string = deprecationReason;
            if (string == null) break block0;
            String it = string;
            boolean bl2 = false;
            $this$buildDeprecatedProfileMessage_u24lambda_u245.append(" Reason: " + it);
        }
        return stringBuilder.toString();
    }

    private String buildDeprecatedConditionalMessage(String className, String annotationDetails, String recommendedApproach) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildDeprecatedConditionalMessage_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildDeprecatedConditionalMessage_u24lambda_u246.append("DEPRECATED CONDITIONAL USAGE: Class '" + className + "' uses deprecated conditional annotation: " + annotationDetails + ".");
        $this$buildDeprecatedConditionalMessage_u24lambda_u246.append(" Please migrate to: " + recommendedApproach);
        return stringBuilder.toString();
    }

    private String buildAggregatedSummaryMessage(DeprecationCategories categories) {
        DeprecationInfo it;
        Iterable $this$forEach$iv;
        List list;
        StringBuilder stringBuilder;
        StringBuilder $this$buildAggregatedSummaryMessage_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("DEPRECATED CONFIGURATION SUMMARY: Found ");
        List $this$buildAggregatedSummaryMessage_u24lambda_u2412_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        if (!((Collection)categories.getProperties()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412_u24lambda_u247.add(categories.getProperties().size() + " deprecated properties");
        }
        if (!((Collection)categories.getProfiles()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412_u24lambda_u247.add(categories.getProfiles().size() + " deprecated profiles");
        }
        if (!((Collection)categories.getConditionals()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412_u24lambda_u247.add(categories.getConditionals().size() + " deprecated conditionals");
        }
        if (!((Collection)categories.getConfigurationProperties()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412_u24lambda_u247.add(categories.getConfigurationProperties().size() + " deprecated @ConfigurationProperties");
        }
        List parts = CollectionsKt.build((List)list);
        $this$buildAggregatedSummaryMessage_u24lambda_u2412.append(CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        $this$buildAggregatedSummaryMessage_u24lambda_u2412.append(". See migration guide for details.");
        if (!((Collection)categories.getProperties()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("\n  Properties: ");
            $this$buildAggregatedSummaryMessage_u24lambda_u2412.append(CollectionsKt.joinToString$default((Iterable)categories.getProperties(), (CharSequence)", ", null, null, (int)0, null, SimpleDeprecatedConfigWarner::buildAggregatedSummaryMessage$lambda$12$lambda$8, (int)30, null));
        }
        if (!((Collection)categories.getProfiles()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("\n  Profiles: ");
            $this$buildAggregatedSummaryMessage_u24lambda_u2412.append(CollectionsKt.joinToString$default((Iterable)categories.getProfiles(), (CharSequence)", ", null, null, (int)0, null, SimpleDeprecatedConfigWarner::buildAggregatedSummaryMessage$lambda$12$lambda$9, (int)30, null));
        }
        if (!((Collection)categories.getConditionals()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("\n  Conditionals:");
            $this$forEach$iv = categories.getConditionals();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DeprecationInfo)element$iv;
                boolean bl3 = false;
                $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("\n    - " + it.getDeprecatedItem() + ": @ConditionalOnProperty migration needed");
            }
        }
        if (!((Collection)categories.getConfigurationProperties()).isEmpty()) {
            $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("\n  @ConfigurationProperties:");
            $this$forEach$iv = categories.getConfigurationProperties();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DeprecationInfo)element$iv;
                boolean bl4 = false;
                $this$buildAggregatedSummaryMessage_u24lambda_u2412.append("\n    - " + it.getDeprecatedItem() + ": @ConfigurationProperties prefix migration needed");
            }
        }
        return stringBuilder.toString();
    }

    private static final CharSequence buildAggregatedSummaryMessage$lambda$12$lambda$8(DeprecationInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDeprecatedItem() + " \u2192 " + it.getRecommendedReplacement();
    }

    private static final CharSequence buildAggregatedSummaryMessage$lambda$12$lambda$9(DeprecationInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDeprecatedItem() + " \u2192 " + it.getRecommendedReplacement();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003JI\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationCategories;", "", "properties", "", "Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationInfo;", "profiles", "conditionals", "configurationProperties", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getProperties", "()Ljava/util/List;", "getProfiles", "getConditionals", "getConfigurationProperties", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "embabel-agent-api"})
    public static final class DeprecationCategories {
        @NotNull
        private final List<DeprecationInfo> properties;
        @NotNull
        private final List<DeprecationInfo> profiles;
        @NotNull
        private final List<DeprecationInfo> conditionals;
        @NotNull
        private final List<DeprecationInfo> configurationProperties;

        public DeprecationCategories(@NotNull List<DeprecationInfo> properties, @NotNull List<DeprecationInfo> profiles, @NotNull List<DeprecationInfo> conditionals, @NotNull List<DeprecationInfo> configurationProperties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter(conditionals, (String)"conditionals");
            Intrinsics.checkNotNullParameter(configurationProperties, (String)"configurationProperties");
            this.properties = properties;
            this.profiles = profiles;
            this.conditionals = conditionals;
            this.configurationProperties = configurationProperties;
        }

        @NotNull
        public final List<DeprecationInfo> getProperties() {
            return this.properties;
        }

        @NotNull
        public final List<DeprecationInfo> getProfiles() {
            return this.profiles;
        }

        @NotNull
        public final List<DeprecationInfo> getConditionals() {
            return this.conditionals;
        }

        @NotNull
        public final List<DeprecationInfo> getConfigurationProperties() {
            return this.configurationProperties;
        }

        @NotNull
        public final List<DeprecationInfo> component1() {
            return this.properties;
        }

        @NotNull
        public final List<DeprecationInfo> component2() {
            return this.profiles;
        }

        @NotNull
        public final List<DeprecationInfo> component3() {
            return this.conditionals;
        }

        @NotNull
        public final List<DeprecationInfo> component4() {
            return this.configurationProperties;
        }

        @NotNull
        public final DeprecationCategories copy(@NotNull List<DeprecationInfo> properties, @NotNull List<DeprecationInfo> profiles, @NotNull List<DeprecationInfo> conditionals, @NotNull List<DeprecationInfo> configurationProperties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter(conditionals, (String)"conditionals");
            Intrinsics.checkNotNullParameter(configurationProperties, (String)"configurationProperties");
            return new DeprecationCategories(properties, profiles, conditionals, configurationProperties);
        }

        public static /* synthetic */ DeprecationCategories copy$default(DeprecationCategories deprecationCategories, List list, List list2, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                list = deprecationCategories.properties;
            }
            if ((n & 2) != 0) {
                list2 = deprecationCategories.profiles;
            }
            if ((n & 4) != 0) {
                list3 = deprecationCategories.conditionals;
            }
            if ((n & 8) != 0) {
                list4 = deprecationCategories.configurationProperties;
            }
            return deprecationCategories.copy(list, list2, list3, list4);
        }

        @NotNull
        public String toString() {
            return "DeprecationCategories(properties=" + this.properties + ", profiles=" + this.profiles + ", conditionals=" + this.conditionals + ", configurationProperties=" + this.configurationProperties + ")";
        }

        public int hashCode() {
            int result = ((Object)this.properties).hashCode();
            result = result * 31 + ((Object)this.profiles).hashCode();
            result = result * 31 + ((Object)this.conditionals).hashCode();
            result = result * 31 + ((Object)this.configurationProperties).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecationCategories)) {
                return false;
            }
            DeprecationCategories deprecationCategories = (DeprecationCategories)other;
            if (!Intrinsics.areEqual(this.properties, deprecationCategories.properties)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.profiles, deprecationCategories.profiles)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.conditionals, deprecationCategories.conditionals)) {
                return false;
            }
            return Intrinsics.areEqual(this.configurationProperties, deprecationCategories.configurationProperties);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationInfo;", "", "type", "Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationType;", "deprecatedItem", "", "recommendedReplacement", "reason", "<init>", "(Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getType", "()Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationType;", "getDeprecatedItem", "()Ljava/lang/String;", "getRecommendedReplacement", "getReason", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-api"})
    public static final class DeprecationInfo {
        @NotNull
        private final DeprecationType type;
        @NotNull
        private final String deprecatedItem;
        @NotNull
        private final String recommendedReplacement;
        @Nullable
        private final String reason;

        public DeprecationInfo(@NotNull DeprecationType type2, @NotNull String deprecatedItem, @NotNull String recommendedReplacement, @Nullable String reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)deprecatedItem, (String)"deprecatedItem");
            Intrinsics.checkNotNullParameter((Object)recommendedReplacement, (String)"recommendedReplacement");
            this.type = type2;
            this.deprecatedItem = deprecatedItem;
            this.recommendedReplacement = recommendedReplacement;
            this.reason = reason;
        }

        public /* synthetic */ DeprecationInfo(DeprecationType deprecationType, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(deprecationType, string, string2, string3);
        }

        @NotNull
        public final DeprecationType getType() {
            return this.type;
        }

        @NotNull
        public final String getDeprecatedItem() {
            return this.deprecatedItem;
        }

        @NotNull
        public final String getRecommendedReplacement() {
            return this.recommendedReplacement;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final DeprecationType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.deprecatedItem;
        }

        @NotNull
        public final String component3() {
            return this.recommendedReplacement;
        }

        @Nullable
        public final String component4() {
            return this.reason;
        }

        @NotNull
        public final DeprecationInfo copy(@NotNull DeprecationType type2, @NotNull String deprecatedItem, @NotNull String recommendedReplacement, @Nullable String reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)deprecatedItem, (String)"deprecatedItem");
            Intrinsics.checkNotNullParameter((Object)recommendedReplacement, (String)"recommendedReplacement");
            return new DeprecationInfo(type2, deprecatedItem, recommendedReplacement, reason);
        }

        public static /* synthetic */ DeprecationInfo copy$default(DeprecationInfo deprecationInfo, DeprecationType deprecationType, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                deprecationType = deprecationInfo.type;
            }
            if ((n & 2) != 0) {
                string = deprecationInfo.deprecatedItem;
            }
            if ((n & 4) != 0) {
                string2 = deprecationInfo.recommendedReplacement;
            }
            if ((n & 8) != 0) {
                string3 = deprecationInfo.reason;
            }
            return deprecationInfo.copy(deprecationType, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "DeprecationInfo(type=" + this.type + ", deprecatedItem=" + this.deprecatedItem + ", recommendedReplacement=" + this.recommendedReplacement + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.deprecatedItem.hashCode();
            result = result * 31 + this.recommendedReplacement.hashCode();
            result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecationInfo)) {
                return false;
            }
            DeprecationInfo deprecationInfo = (DeprecationInfo)other;
            if (this.type != deprecationInfo.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deprecatedItem, (Object)deprecationInfo.deprecatedItem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.recommendedReplacement, (Object)deprecationInfo.recommendedReplacement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)deprecationInfo.reason);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/SimpleDeprecatedConfigWarner$DeprecationType;", "", "<init>", "(Ljava/lang/String;I)V", "PROPERTY", "PROFILE", "CONDITIONAL", "CONFIGURATION_PROPERTIES", "embabel-agent-api"})
    public static final class DeprecationType
    extends Enum<DeprecationType> {
        public static final /* enum */ DeprecationType PROPERTY = new DeprecationType();
        public static final /* enum */ DeprecationType PROFILE = new DeprecationType();
        public static final /* enum */ DeprecationType CONDITIONAL = new DeprecationType();
        public static final /* enum */ DeprecationType CONFIGURATION_PROPERTIES = new DeprecationType();
        private static final /* synthetic */ DeprecationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DeprecationType[] values() {
            return (DeprecationType[])$VALUES.clone();
        }

        public static DeprecationType valueOf(String value) {
            return Enum.valueOf(DeprecationType.class, value);
        }

        @NotNull
        public static EnumEntries<DeprecationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = deprecationTypeArray = new DeprecationType[]{DeprecationType.PROPERTY, DeprecationType.PROFILE, DeprecationType.CONDITIONAL, DeprecationType.CONFIGURATION_PROPERTIES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

