/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.config.spring.migration;

import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="embabel.agent.platform.migration.scanning")
@ConditionalOnProperty(name={"embabel.agent.platform.migration.scanning.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010$\u001a\u00020%H\u0017J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0006H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u0018\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010#\u00a8\u0006+"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanningConfig;", "", "<init>", "()V", "includePackages", "", "", "getIncludePackages", "()Ljava/util/List;", "setIncludePackages", "(Ljava/util/List;)V", "excludePackages", "getExcludePackages", "setExcludePackages", "additionalExcludes", "getAdditionalExcludes", "setAdditionalExcludes", "autoExcludeJarPackages", "", "getAutoExcludeJarPackages", "()Z", "setAutoExcludeJarPackages", "(Z)V", "maxScanDepth", "", "getMaxScanDepth", "()I", "setMaxScanDepth", "(I)V", "enabled", "getEnabled", "setEnabled", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "init", "", "getAllExcludePackages", "shouldExcludePackage", "packageName", "shouldIncludePackage", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDeprecatedPropertyScanningConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedPropertyScanningConfig.kt\ncom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanningConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,307:1\n1755#2,3:308\n1755#2,3:311\n*S KotlinDebug\n*F\n+ 1 DeprecatedPropertyScanningConfig.kt\ncom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanningConfig\n*L\n289#1:308,3\n302#1:311,3\n*E\n"})
public class DeprecatedPropertyScanningConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> includePackages;
    @NotNull
    private List<String> excludePackages;
    @NotNull
    private List<String> additionalExcludes;
    private boolean autoExcludeJarPackages;
    private int maxScanDepth;
    private boolean enabled;
    private final Logger logger;

    public DeprecatedPropertyScanningConfig() {
        Object[] objectArray = new String[]{"com.embabel.agent", "com.embabel.agent.shell"};
        this.includePackages = CollectionsKt.listOf((Object[])objectArray);
        this.excludePackages = Companion.defaultExcludePackages();
        this.additionalExcludes = CollectionsKt.emptyList();
        this.maxScanDepth = 10;
        this.logger = LoggerFactory.getLogger(DeprecatedPropertyScanningConfig.class);
    }

    @NotNull
    public List<String> getIncludePackages() {
        return this.includePackages;
    }

    public void setIncludePackages(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.includePackages = list;
    }

    @NotNull
    public List<String> getExcludePackages() {
        return this.excludePackages;
    }

    public void setExcludePackages(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.excludePackages = list;
    }

    @NotNull
    public List<String> getAdditionalExcludes() {
        return this.additionalExcludes;
    }

    public void setAdditionalExcludes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.additionalExcludes = list;
    }

    public boolean getAutoExcludeJarPackages() {
        return this.autoExcludeJarPackages;
    }

    public void setAutoExcludeJarPackages(boolean bl) {
        this.autoExcludeJarPackages = bl;
    }

    public int getMaxScanDepth() {
        return this.maxScanDepth;
    }

    public void setMaxScanDepth(int n) {
        this.maxScanDepth = n;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @PostConstruct
    public void init() {
        this.logger.info("Deprecated property scanning config initialized: enabled=" + this.getEnabled());
    }

    @NotNull
    public List<String> getAllExcludePackages() {
        return CollectionsKt.plus((Collection)this.getExcludePackages(), (Iterable)this.getAdditionalExcludes());
    }

    public boolean shouldExcludePackage(@NotNull String packageName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Iterable $this$any$iv = this.getAllExcludePackages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String exclude = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)packageName, (String)exclude, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldIncludePackage(@NotNull String packageName) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            if (this.shouldExcludePackage(packageName)) {
                return false;
            }
            Iterable $this$any$iv = this.getIncludePackages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String include = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)packageName, (String)include, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/embabel/agent/spi/config/spring/migration/DeprecatedPropertyScanningConfig$Companion;", "", "<init>", "()V", "defaultExcludePackages", "", "", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> defaultExcludePackages() {
            Object[] objectArray = new String[]{"java.", "javax.", "jdk.", "sun.", "com.sun.", "kotlin.", "kotlinx.", "org.springframework.", "org.springframework.boot.", "org.springframework.security.", "org.springframework.data.", "org.springframework.cloud.", "org.springframework.integration.", "org.springframework.batch.", "org.springframework.test.", "org.apache.", "org.eclipse.", "org.junit.", "org.hamcrest.", "org.mockito.", "org.testng.", "org.assertj.", "com.fasterxml.jackson.", "com.google.gson.", "org.json.", "org.slf4j.", "ch.qos.logback.", "org.apache.logging.", "org.apache.log4j.", "io.micrometer.", "io.prometheus.", "com.codahale.metrics.", "org.influxdb.", "com.newrelic.", "com.datadog.", "org.hibernate.", "org.mybatis.", "com.zaxxer.hikari.", "org.h2.", "org.postgresql.", "com.mysql.", "oracle.jdbc.", "com.microsoft.sqlserver.", "redis.clients.", "org.mongodb.", "org.neo4j.", "org.apache.tomcat.", "org.apache.catalina.", "io.undertow.", "org.eclipse.jetty.", "io.netty.", "com.squareup.okhttp.", "org.apache.http.", "org.bouncycastle.", "org.jasypt.", "io.jsonwebtoken.", "org.gradle.", "org.apache.maven.", "com.github.", "org.jetbrains.", "com.amazonaws.", "com.azure.", "com.google.cloud.", "io.kubernetes.", "io.fabric8.", "io.reactivex.", "reactor.", "org.reactivestreams.", "javax.validation.", "jakarta.validation.", "org.apache.avro.", "com.thoughtworks.xstream.", "org.thymeleaf.", "org.apache.velocity.", "freemarker.", "com.typesafe.config.", "org.apache.commons.configuration.", "org.apache.commons.", "com.google.guava.", "org.apache.commons.lang.", "org.apache.commons.collections.", "org.apache.commons.io."};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

