/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.thinking.support;

import com.embabel.agent.api.common.thinking.ThinkingPromptRunnerOperations;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.experimental.primitive.Determination;
import com.embabel.agent.spi.LlmInteraction;
import com.embabel.agent.spi.support.springai.ChatClientLlmOperations;
import com.embabel.chat.AssistantMessage;
import com.embabel.chat.Message;
import com.embabel.chat.UserMessage;
import com.embabel.common.core.thinking.ThinkingBlock;
import com.embabel.common.core.thinking.ThinkingException;
import com.embabel.common.core.thinking.ThinkingResponse;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ2\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u0010\"\u0004\b\u0000\u0010\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/embabel/agent/api/common/thinking/support/ThinkingPromptRunnerOperationsImpl;", "Lcom/embabel/agent/api/common/thinking/ThinkingPromptRunnerOperations;", "chatClientOperations", "Lcom/embabel/agent/spi/support/springai/ChatClientLlmOperations;", "interaction", "Lcom/embabel/agent/spi/LlmInteraction;", "messages", "", "Lcom/embabel/chat/Message;", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "action", "Lcom/embabel/agent/core/Action;", "<init>", "(Lcom/embabel/agent/spi/support/springai/ChatClientLlmOperations;Lcom/embabel/agent/spi/LlmInteraction;Ljava/util/List;Lcom/embabel/agent/core/AgentProcess;Lcom/embabel/agent/core/Action;)V", "createObjectIfPossible", "Lcom/embabel/common/core/thinking/ThinkingResponse;", "T", "outputClass", "Ljava/lang/Class;", "createObject", "respond", "Lcom/embabel/chat/AssistantMessage;", "evaluateCondition", "", "condition", "", "context", "confidenceThreshold", "", "Lcom/embabel/common/core/types/ZeroToOne;", "embabel-agent-api"})
public final class ThinkingPromptRunnerOperationsImpl
implements ThinkingPromptRunnerOperations {
    @NotNull
    private final ChatClientLlmOperations chatClientOperations;
    @NotNull
    private final LlmInteraction interaction;
    @NotNull
    private final List<Message> messages;
    @NotNull
    private final AgentProcess agentProcess;
    @Nullable
    private final Action action;

    public ThinkingPromptRunnerOperationsImpl(@NotNull ChatClientLlmOperations chatClientOperations, @NotNull LlmInteraction interaction, @NotNull List<? extends Message> messages, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Intrinsics.checkNotNullParameter((Object)chatClientOperations, (String)"chatClientOperations");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        this.chatClientOperations = chatClientOperations;
        this.interaction = interaction;
        this.messages = messages;
        this.agentProcess = agentProcess;
        this.action = action;
    }

    @Override
    @NotNull
    public <T> ThinkingResponse<T> createObjectIfPossible(@NotNull List<? extends Message> messages, @NotNull Class<T> outputClass) {
        ThinkingResponse thinkingResponse;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        List combinedMessages = CollectionsKt.plus((Collection)this.messages, (Iterable)messages);
        Object result = this.chatClientOperations.doTransformWithThinkingIfPossible-BWLJW6A$embabel_agent_api(combinedMessages, this.interaction, outputClass, null);
        if (Result.isSuccess-impl((Object)result)) {
            Object object = result;
            ResultKt.throwOnFailure((Object)object);
            ThinkingResponse successResponse = (ThinkingResponse)object;
            thinkingResponse = new ThinkingResponse(successResponse.getResult(), successResponse.getThinkingBlocks());
        } else {
            Throwable exception = Result.exceptionOrNull-impl((Object)result);
            List<ThinkingBlock> thinkingBlocks = exception instanceof ThinkingException ? ((ThinkingException)exception).getThinkingBlocks() : CollectionsKt.emptyList();
            thinkingResponse = new ThinkingResponse<Object>(null, thinkingBlocks);
        }
        return thinkingResponse;
    }

    @Override
    @NotNull
    public <T> ThinkingResponse<T> createObject(@NotNull List<? extends Message> messages, @NotNull Class<T> outputClass) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        List combinedMessages = CollectionsKt.plus((Collection)this.messages, (Iterable)messages);
        return this.chatClientOperations.doTransformWithThinking$embabel_agent_api(combinedMessages, this.interaction, outputClass, null);
    }

    @Override
    @NotNull
    public ThinkingResponse<AssistantMessage> respond(@NotNull List<? extends Message> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return this.createObject(messages, AssistantMessage.class);
    }

    @Override
    @NotNull
    public ThinkingResponse<Boolean> evaluateCondition(@NotNull String condition2, @NotNull String context, double confidenceThreshold) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String prompt = StringsKt.trimIndent((String)("\n            Evaluate this condition given the context.\n            Return \"result\": whether you think it is true, your confidence level from 0-1,\n            and an explanation of what you base this on.\n\n            # Condition\n            " + condition2 + "\n\n            # Context\n            " + context + "\n            "));
        ThinkingResponse<Determination> response = this.createObject(CollectionsKt.listOf((Object)new UserMessage(prompt, null, null, 6, null)), Determination.class);
        Determination determination = response.getResult();
        if (determination != null) {
            Determination it = determination;
            boolean bl2 = false;
            bl = it.getResult() && it.getConfidence() >= confidenceThreshold;
        } else {
            bl = false;
        }
        boolean result = bl;
        return new ThinkingResponse<Boolean>(result, response.getThinkingBlocks());
    }
}

