/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.ActionStatus;
import com.embabel.agent.core.ActionStatusCode;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.IoBinding;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lcom/embabel/agent/api/annotation/support/CurriedActionTool;", "Lcom/embabel/agent/api/tool/Tool;", "action", "Lcom/embabel/agent/core/Action;", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/embabel/agent/core/Action;Lcom/embabel/agent/core/Blackboard;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "requiredInputs", "", "Lcom/embabel/agent/core/IoBinding;", "parameterNameToBinding", "", "", "getParameterNameToBinding", "()Ljava/util/Map;", "parameterNameToBinding$delegate", "Lkotlin/Lazy;", "computeRequiredInputs", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "buildDescription", "computeParameterNameMapping", "buildInputSchema", "Lcom/embabel/agent/api/tool/Tool$InputSchema;", "mapToToolParameterType", "Lcom/embabel/agent/api/tool/Tool$ParameterType;", "typeName", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "parseAndBindInputs", "", "toolInput", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "convertToType", "", "value", "targetType", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nCurriedActionTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurriedActionTool.kt\ncom/embabel/agent/api/annotation/support/CurriedActionTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,297:1\n774#2:298\n865#2:299\n1755#2,3:300\n866#2:303\n1#3:304\n126#4:305\n153#4,3:306\n37#5:309\n36#5,3:310\n*S KotlinDebug\n*F\n+ 1 CurriedActionTool.kt\ncom/embabel/agent/api/annotation/support/CurriedActionTool\n*L\n66#1:298\n66#1:299\n68#1:300,3\n66#1:303\n134#1:305\n134#1:306,3\n142#1:309\n142#1:310,3\n*E\n"})
public final class CurriedActionTool
implements Tool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Action action;
    @NotNull
    private final Blackboard blackboard;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;
    @NotNull
    private final Set<IoBinding> requiredInputs;
    @NotNull
    private final Lazy parameterNameToBinding$delegate;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public CurriedActionTool(@NotNull Action action, @NotNull Blackboard blackboard, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)blackboard, (String)"blackboard");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.action = action;
        this.blackboard = blackboard;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(CurriedActionTool.class);
        this.requiredInputs = this.computeRequiredInputs();
        this.parameterNameToBinding$delegate = LazyKt.lazy(() -> CurriedActionTool.parameterNameToBinding_delegate$lambda$0(this));
        this.definition = new Tool.Definition(this){
            private final String name;
            private final String description;
            private final Tool.InputSchema inputSchema;
            {
                this.name = CurriedActionTool.access$getAction$p($receiver).shortName();
                this.description = CurriedActionTool.access$buildDescription($receiver);
                this.inputSchema = CurriedActionTool.access$buildInputSchema($receiver);
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Tool.InputSchema getInputSchema() {
                return this.inputSchema;
            }
        };
        this.metadata = Tool.Metadata.DEFAULT;
    }

    private final Map<String, IoBinding> getParameterNameToBinding() {
        Lazy lazy = this.parameterNameToBinding$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IoBinding> computeRequiredInputs() {
        void $this$filterTo$iv$iv;
        List mapValues = CollectionsKt.filterNotNull((Iterable)this.blackboard.expressionEvaluationModel().values());
        List<Object> objectValues = this.blackboard.getObjects();
        List allValues = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)mapValues, (Iterable)objectValues));
        Iterable $this$filter$iv = this.action.getInputs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean existsOnBlackboard;
            String input;
            block5: {
                input = ((IoBinding)element$iv$iv).unbox-impl();
                boolean bl = false;
                Iterable $this$any$iv = allValues;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object value = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!Companion.isCompatibleType(value, IoBinding.getType-impl(input))) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = existsOnBlackboard = false;
                }
            }
            if (existsOnBlackboard) {
                Object[] objectArray = new Object[]{this.action.shortName(), IoBinding.getName-impl(input), IoBinding.getType-impl(input)};
                this.logger.debug("Action '{}' input '{}' of type '{}' already on blackboard - currying out", objectArray);
            }
            if (!(!existsOnBlackboard)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    private final String buildDescription() {
        Object object;
        Object object2;
        CharSequence charSequence = this.action.getDescription();
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl = false;
            object2 = "Execute action " + this.action.shortName();
        } else {
            object2 = charSequence;
        }
        String baseDescription = (String)object2;
        if (this.requiredInputs.isEmpty()) {
            object = baseDescription + " (all inputs available on blackboard)";
        } else if (this.requiredInputs.size() < this.action.getInputs().size()) {
            int curriedOut = this.action.getInputs().size() - this.requiredInputs.size();
            object = baseDescription + " (" + curriedOut + " inputs already on blackboard)";
        } else {
            object = baseDescription;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, IoBinding> computeParameterNameMapping() {
        Set usedNames = new LinkedHashSet();
        Map mapping = new LinkedHashMap();
        Iterator<IoBinding> iterator = this.requiredInputs.iterator();
        while (iterator.hasNext()) {
            String string;
            String input = iterator.next().unbox-impl();
            if (Intrinsics.areEqual((Object)IoBinding.getName-impl(input), (Object)"it")) {
                String string2 = StringsKt.substringAfterLast$default((String)IoBinding.getType-impl(input), (String)".", null, (int)2, null);
                if (((CharSequence)string2).length() > 0) {
                    void it22;
                    char c = string2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    String string3 = String.valueOf((char)it22);
                    Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                    String it22 = string2;
                    int n = 1;
                    String string5 = it22.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string = stringBuilder2.append(string5).toString();
                } else {
                    string = string2;
                }
            } else {
                string = IoBinding.getName-impl(input);
            }
            String baseName = string;
            Object uniqueName = baseName;
            int suffix = 2;
            while (usedNames.contains(uniqueName)) {
                uniqueName = baseName + suffix;
                ++suffix;
            }
            usedNames.add(uniqueName);
            IoBinding ioBinding = IoBinding.box-impl(input);
            mapping.put(uniqueName, ioBinding);
        }
        return mapping;
    }

    /*
     * WARNING - void declaration
     */
    private final Tool.InputSchema buildInputSchema() {
        void $this$mapTo$iv$iv;
        Map<String, IoBinding> $this$map$iv = this.getParameterNameToBinding();
        boolean $i$f$map = false;
        Map<String, IoBinding> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String paramName = (String)entry.getKey();
            String input = ((IoBinding)entry.getValue()).unbox-impl();
            collection.add(new Tool.Parameter(paramName, this.mapToToolParameterType(IoBinding.getType-impl(input)), "Input of type " + IoBinding.getType-impl(input), true, null, 16, null));
        }
        List parameters = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = parameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Tool.Parameter[] parameterArray = thisCollection$iv.toArray(new Tool.Parameter[0]);
        return Tool.InputSchema.Companion.of(Arrays.copyOf(parameterArray, parameterArray.length));
    }

    private final Tool.ParameterType mapToToolParameterType(String typeName) {
        int n = -1;
        switch (typeName.hashCode()) {
            case -527879800: {
                if (typeName.equals("java.lang.Float")) {
                    n = 1;
                }
                break;
            }
            case 761287205: {
                if (typeName.equals("java.lang.Double")) {
                    n = 1;
                }
                break;
            }
            case -1325958191: {
                if (typeName.equals("double")) {
                    n = 1;
                }
                break;
            }
            case -67829378: {
                if (typeName.equals("kotlin.Double")) {
                    n = 1;
                }
                break;
            }
            case -1385909489: {
                if (typeName.equals("kotlin.Float")) {
                    n = 1;
                }
                break;
            }
            case 97526364: {
                if (typeName.equals("float")) {
                    n = 1;
                }
                break;
            }
            case 366142910: {
                if (typeName.equals("kotlin.String")) {
                    n = 2;
                }
                break;
            }
            case -2056817302: {
                if (typeName.equals("java.lang.Integer")) {
                    n = 3;
                }
                break;
            }
            case 104431: {
                if (typeName.equals("int")) {
                    n = 3;
                }
                break;
            }
            case 3327612: {
                if (typeName.equals("long")) {
                    n = 4;
                }
                break;
            }
            case 64711720: {
                if (typeName.equals("boolean")) {
                    n = 5;
                }
                break;
            }
            case 398795216: {
                if (typeName.equals("java.lang.Long")) {
                    n = 4;
                }
                break;
            }
            case 411999259: {
                if (typeName.equals("kotlin.Boolean")) {
                    n = 5;
                }
                break;
            }
            case -1707093143: {
                if (typeName.equals("kotlin.Long")) {
                    n = 4;
                }
                break;
            }
            case 344809556: {
                if (typeName.equals("java.lang.Boolean")) {
                    n = 5;
                }
                break;
            }
            case -2133280414: {
                if (typeName.equals("kotlin.Int")) {
                    n = 3;
                }
                break;
            }
            case 1195259493: {
                if (typeName.equals("java.lang.String")) {
                    n = 2;
                }
                break;
            }
        }
        return switch (n) {
            case 3 -> Tool.ParameterType.INTEGER;
            case 4 -> Tool.ParameterType.INTEGER;
            case 1 -> Tool.ParameterType.NUMBER;
            case 5 -> Tool.ParameterType.BOOLEAN;
            case 2 -> Tool.ParameterType.STRING;
            default -> Tool.ParameterType.OBJECT;
        };
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.logger.info("CurriedActionTool called for action '{}' with input: {}", (Object)this.action.getName(), (Object)input);
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            return Tool.Result.Companion.error$default(Tool.Result.Companion, "No agent process context available", null, 2, null);
        }
        AgentProcess agentProcess2 = agentProcess;
        if (!((Collection)this.requiredInputs).isEmpty() && !StringsKt.isBlank((CharSequence)input)) {
            try {
                this.parseAndBindInputs(input, agentProcess2);
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse tool input: {}", (Object)e.getMessage());
                return Tool.Result.Companion.error$default(Tool.Result.Companion, "Failed to parse input: " + e.getMessage(), null, 2, null);
            }
        }
        ActionStatus result = this.action.execute(agentProcess2.getProcessContext());
        return switch (WhenMappings.$EnumSwitchMapping$0[result.getStatus().ordinal()]) {
            case 1 -> {
                Object lastResult = agentProcess2.lastResult();
                yield Tool.Result.Companion.text("Action '" + this.action.shortName() + "' succeeded. Result: " + lastResult);
            }
            case 2 -> Tool.Result.Companion.error$default(Tool.Result.Companion, "Action '" + this.action.shortName() + "' failed", null, 2, null);
            default -> Tool.Result.Companion.text("Action '" + this.action.shortName() + "' returned status: " + result.getStatus());
        };
    }

    private final void parseAndBindInputs(String toolInput, AgentProcess agentProcess) {
        Object object = this.objectMapper.readValue(toolInput, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map inputMap = (Map)object;
        for (Map.Entry<String, IoBinding> entry : this.getParameterNameToBinding().entrySet()) {
            String paramName = entry.getKey();
            String binding = entry.getValue().unbox-impl();
            Object value = inputMap.get(paramName);
            if (value == null) continue;
            Object convertedValue = this.convertToType(value, IoBinding.getType-impl(binding));
            agentProcess.set(IoBinding.getName-impl(binding), convertedValue);
            Object[] objectArray = new Object[]{IoBinding.getName-impl(binding), paramName, convertedValue, IoBinding.getType-impl(binding)};
            this.logger.debug("Bound input '{}' (param '{}') = {} (type: {})", objectArray);
        }
    }

    private final Object convertToType(Object value, String targetType) {
        Object object;
        if (Companion.isCompatibleType(value, targetType)) {
            return value;
        }
        try {
            Class<?> targetClass = Class.forName(targetType);
            object = this.objectMapper.convertValue(value, targetClass);
            Intrinsics.checkNotNull((Object)object);
        }
        catch (Exception e) {
            this.logger.warn("Could not convert {} to {}, using as-is", value, (Object)targetType);
            object = value;
        }
        return object;
    }

    private static final Map parameterNameToBinding_delegate$lambda$0(CurriedActionTool this$0) {
        return this$0.computeParameterNameMapping();
    }

    @JvmStatic
    @NotNull
    public static final List<Tool> createTools(@NotNull List<? extends Action> actions, @NotNull Blackboard blackboard, @NotNull ObjectMapper objectMapper) {
        return Companion.createTools(actions, blackboard, objectMapper);
    }

    @JvmStatic
    public static final boolean isReady(@NotNull Tool tool) {
        return Companion.isReady(tool);
    }

    @JvmStatic
    public static final boolean isCompatibleType(@NotNull Object value, @NotNull String expectedType) {
        return Companion.isCompatibleType(value, expectedType);
    }

    public static final /* synthetic */ Action access$getAction$p(CurriedActionTool $this) {
        return $this.action;
    }

    public static final /* synthetic */ String access$buildDescription(CurriedActionTool $this) {
        return $this.buildDescription();
    }

    public static final /* synthetic */ Tool.InputSchema access$buildInputSchema(CurriedActionTool $this) {
        return $this.buildInputSchema();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/api/annotation/support/CurriedActionTool$Companion;", "", "<init>", "()V", "createTools", "", "Lcom/embabel/agent/api/tool/Tool;", "actions", "Lcom/embabel/agent/core/Action;", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "isReady", "", "tool", "isCompatibleType", "value", "expectedType", "", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nCurriedActionTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurriedActionTool.kt\ncom/embabel/agent/api/annotation/support/CurriedActionTool$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1557#2:298\n1628#2,3:299\n1053#2:302\n*S KotlinDebug\n*F\n+ 1 CurriedActionTool.kt\ncom/embabel/agent/api/annotation/support/CurriedActionTool$Companion\n*L\n263#1:298\n263#1:299,3\n265#1:302\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Tool> createTools(@NotNull List<? extends Action> actions, @NotNull Blackboard blackboard, @NotNull ObjectMapper objectMapper) {
            void $this$sortedBy$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            Intrinsics.checkNotNullParameter((Object)blackboard, (String)"blackboard");
            Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
            Iterable $this$map$iv = actions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void action;
                Action action2 = (Action)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CurriedActionTool((Action)action, blackboard, objectMapper));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CurriedActionTool tool = (CurriedActionTool)a;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)tool, (String)"null cannot be cast to non-null type com.embabel.agent.api.annotation.support.CurriedActionTool");
                    Comparable comparable = Integer.valueOf(CurriedActionTool.access$getRequiredInputs$p(tool).size());
                    tool = (CurriedActionTool)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Intrinsics.checkNotNull((Object)tool, (String)"null cannot be cast to non-null type com.embabel.agent.api.annotation.support.CurriedActionTool");
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(CurriedActionTool.access$getRequiredInputs$p(tool).size()));
                }
            });
        }

        @JvmStatic
        public final boolean isReady(@NotNull Tool tool) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            return tool instanceof CurriedActionTool && ((CurriedActionTool)tool).requiredInputs.isEmpty();
        }

        @JvmStatic
        public final boolean isCompatibleType(@NotNull Object value, @NotNull String expectedType) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Class<?> valueClass = value.getClass();
            try {
                Class<?> expectedClass = Class.forName(expectedType);
                bl = expectedClass.isAssignableFrom(valueClass);
            }
            catch (ClassNotFoundException e) {
                bl = Intrinsics.areEqual((Object)valueClass.getName(), (Object)expectedType);
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionStatusCode.values().length];
            try {
                nArray[ActionStatusCode.SUCCEEDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionStatusCode.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

