/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai.streaming;

import com.embabel.agent.api.event.LlmRequestEvent;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.spi.LlmInteraction;
import com.embabel.agent.spi.streaming.StreamingLlmOperations;
import com.embabel.agent.spi.support.springai.ChatClientLlmOperations;
import com.embabel.agent.spi.support.springai.ConverterKt;
import com.embabel.chat.Message;
import com.embabel.common.ai.converters.streaming.StreamingJacksonOutputConverter;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.prompt.PromptContributor;
import com.embabel.common.core.streaming.StreamingEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016JJ\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0017\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016JP\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0!0\u0017\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016JP\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0#0\u0017\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J4\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010&H\u0016JH\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0017\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010&H\u0016JN\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0!0\u0017\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010&H\u0016JN\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0!0\u0017\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010&H\u0002J\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006,"}, d2={"Lcom/embabel/agent/spi/support/springai/streaming/StreamingChatClientOperations;", "Lcom/embabel/agent/spi/streaming/StreamingLlmOperations;", "chatClientLlmOperations", "Lcom/embabel/agent/spi/support/springai/ChatClientLlmOperations;", "<init>", "(Lcom/embabel/agent/spi/support/springai/ChatClientLlmOperations;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "buildPromptContributions", "", "interaction", "Lcom/embabel/agent/spi/LlmInteraction;", "llm", "Lcom/embabel/common/ai/model/Llm;", "buildSpringAiPrompt", "Lorg/springframework/ai/chat/prompt/Prompt;", "messages", "", "Lcom/embabel/chat/Message;", "promptContributions", "generateStream", "Lreactor/core/publisher/Flux;", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "action", "Lcom/embabel/agent/core/Action;", "createObjectStream", "O", "outputClass", "Ljava/lang/Class;", "createObjectStreamWithThinking", "Lcom/embabel/common/core/streaming/StreamingEvent;", "createObjectStreamIfPossible", "Lkotlin/Result;", "doTransformStream", "llmRequestEvent", "Lcom/embabel/agent/api/event/LlmRequestEvent;", "doTransformObjectStream", "doTransformObjectStreamWithThinking", "doTransformObjectStreamInternal", "rawChunksToLines", "raw", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nStreamingChatClientOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingChatClientOperations.kt\ncom/embabel/agent/spi/support/springai/streaming/StreamingChatClientOperations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,377:1\n1557#2:378\n1628#2,3:379\n*S KotlinDebug\n*F\n+ 1 StreamingChatClientOperations.kt\ncom/embabel/agent/spi/support/springai/streaming/StreamingChatClientOperations\n*L\n79#1:378\n79#1:379,3\n*E\n"})
public final class StreamingChatClientOperations
implements StreamingLlmOperations {
    @NotNull
    private final ChatClientLlmOperations chatClientLlmOperations;
    private final Logger logger;

    public StreamingChatClientOperations(@NotNull ChatClientLlmOperations chatClientLlmOperations) {
        Intrinsics.checkNotNullParameter((Object)chatClientLlmOperations, (String)"chatClientLlmOperations");
        this.chatClientLlmOperations = chatClientLlmOperations;
        this.logger = LoggerFactory.getLogger(StreamingChatClientOperations.class);
    }

    private final String buildPromptContributions(LlmInteraction interaction, Llm llm) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)interaction.getPromptContributors(), (Iterable)llm.getPromptContributors()), (CharSequence)"\n----\n", null, null, (int)0, null, StreamingChatClientOperations::buildPromptContributions$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Prompt buildSpringAiPrompt(List<? extends Message> messages, String promptContributions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        List $this$buildSpringAiPrompt_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (((CharSequence)promptContributions).length() > 0) {
            $this$buildSpringAiPrompt_u24lambda_u242.add(new SystemMessage(promptContributions));
        }
        Iterable iterable = messages;
        List list2 = $this$buildSpringAiPrompt_u24lambda_u242;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message message = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(ConverterKt.toSpringAiMessage((Message)it));
        }
        list2.addAll((List)destination$iv$iv);
        List list3 = CollectionsKt.build((List)list);
        return new Prompt(list3);
    }

    @Override
    @NotNull
    public Flux<String> generateStream(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        return this.doTransformStream(messages, interaction, null);
    }

    @Override
    @NotNull
    public <O> Flux<O> createObjectStream(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        return this.doTransformObjectStream(messages, interaction, outputClass, null);
    }

    @Override
    @NotNull
    public <O> Flux<StreamingEvent<O>> createObjectStreamWithThinking(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        return this.doTransformObjectStreamWithThinking(messages, interaction, outputClass, null);
    }

    @Override
    @NotNull
    public <O> Flux<Result<O>> createObjectStreamIfPossible(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        Flux flux = this.createObjectStream(messages, interaction, outputClass, agentProcess, action).map(arg_0 -> StreamingChatClientOperations.createObjectStreamIfPossible$lambda$4(StreamingChatClientOperations::createObjectStreamIfPossible$lambda$3, arg_0)).onErrorResume(arg_0 -> StreamingChatClientOperations.createObjectStreamIfPossible$lambda$6(StreamingChatClientOperations::createObjectStreamIfPossible$lambda$5, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"onErrorResume(...)");
        return flux;
    }

    @Override
    @NotNull
    public Flux<String> doTransformStream(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @Nullable LlmRequestEvent<String> llmRequestEvent) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Llm llm = this.chatClientLlmOperations.getLlm$embabel_agent_api(interaction);
        ChatClient chatClient = this.chatClientLlmOperations.createChatClient$embabel_agent_api(llm);
        String promptContributions = this.buildPromptContributions(interaction, llm);
        Prompt springAiPrompt = this.buildSpringAiPrompt(messages, promptContributions);
        ChatOptions chatOptions = llm.getOptionsConverter().convertOptions(interaction.getLlm());
        Flux flux = chatClient.prompt(springAiPrompt).toolCallbacks(interaction.getToolCallbacks()).options(chatOptions).stream().content();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"content(...)");
        return flux;
    }

    @Override
    @NotNull
    public <O> Flux<O> doTransformObjectStream(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @Nullable LlmRequestEvent<O> llmRequestEvent) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Flux flux = this.doTransformObjectStreamInternal(messages, interaction, outputClass, llmRequestEvent).filter(arg_0 -> StreamingChatClientOperations.doTransformObjectStream$lambda$8(StreamingChatClientOperations::doTransformObjectStream$lambda$7, arg_0)).map(arg_0 -> StreamingChatClientOperations.doTransformObjectStream$lambda$10(StreamingChatClientOperations::doTransformObjectStream$lambda$9, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @Override
    @NotNull
    public <O> Flux<StreamingEvent<O>> doTransformObjectStreamWithThinking(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @Nullable LlmRequestEvent<O> llmRequestEvent) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        return this.doTransformObjectStreamInternal(messages, interaction, outputClass, llmRequestEvent);
    }

    private final <O> Flux<StreamingEvent<O>> doTransformObjectStreamInternal(List<? extends Message> messages, LlmInteraction interaction, Class<O> outputClass, LlmRequestEvent<O> llmRequestEvent) {
        Llm llm = this.chatClientLlmOperations.getLlm$embabel_agent_api(interaction);
        ChatClient chatClient = this.chatClientLlmOperations.createChatClient$embabel_agent_api(llm);
        ChatOptions chatOptions = llm.getOptionsConverter().convertOptions(interaction.getLlm());
        StreamingJacksonOutputConverter streamingConverter = new StreamingJacksonOutputConverter(outputClass, this.chatClientLlmOperations.getObjectMapper$embabel_agent_api(), interaction.getPropertyFilter());
        String promptContributions = this.buildPromptContributions(interaction, llm);
        String streamingFormatInstructions = streamingConverter.getFormat();
        this.logger.debug("STREAMING FORMAT INSTRUCTIONS: " + streamingFormatInstructions);
        String fullPromptContributions = ((CharSequence)promptContributions).length() > 0 ? promptContributions + "\n----\n" + streamingFormatInstructions : streamingFormatInstructions;
        Prompt springAiPrompt = this.buildSpringAiPrompt(messages, fullPromptContributions);
        Flux flux = chatClient.prompt(springAiPrompt).toolCallbacks(interaction.getToolCallbacks()).options(chatOptions).stream().content().filter(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$12(StreamingChatClientOperations::doTransformObjectStreamInternal$lambda$11, arg_0)).doOnNext(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$14(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$13(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doOnNext(...)");
        Flux rawChunkFlux = flux;
        Flux flux2 = rawChunkFlux.transform(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$16(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$15(this, arg_0), arg_0)).doOnNext(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$18(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$17(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux2, (String)"doOnNext(...)");
        Flux lineFlux = flux2;
        Flux flux3 = lineFlux.concatMap(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$20(arg_0 -> StreamingChatClientOperations.doTransformObjectStreamInternal$lambda$19(streamingConverter, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux3, (String)"concatMap(...)");
        Flux event = flux3;
        return event;
    }

    @NotNull
    public final Flux<String> rawChunksToLines(@NotNull Flux<String> raw) {
        Intrinsics.checkNotNullParameter(raw, (String)"raw");
        StringBuilder buffer = new StringBuilder();
        Flux flux = raw.concatMap(arg_0 -> StreamingChatClientOperations.rawChunksToLines$lambda$22(arg_0 -> StreamingChatClientOperations.rawChunksToLines$lambda$21(buffer, arg_0), arg_0)).doOnComplete(() -> StreamingChatClientOperations.rawChunksToLines$lambda$23(buffer, this)).concatWith((Publisher)Mono.fromSupplier(() -> StreamingChatClientOperations.rawChunksToLines$lambda$24(buffer)).filter(arg_0 -> StreamingChatClientOperations.rawChunksToLines$lambda$26(StreamingChatClientOperations::rawChunksToLines$lambda$25, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"concatWith(...)");
        return flux;
    }

    private static final CharSequence buildPromptContributions$lambda$0(PromptContributor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.contribution();
    }

    private static final Result createObjectStreamIfPossible$lambda$3(Object it) {
        return Result.box-impl((Object)Result.constructor-impl((Object)it));
    }

    private static final Result createObjectStreamIfPossible$lambda$4(Function1 $tmp0, Object p0) {
        return (Result)$tmp0.invoke(p0);
    }

    private static final Publisher createObjectStreamIfPossible$lambda$5(Throwable throwable) {
        Intrinsics.checkNotNull((Object)throwable);
        return (Publisher)Flux.just((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable))));
    }

    private static final Publisher createObjectStreamIfPossible$lambda$6(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final boolean doTransformObjectStream$lambda$7(StreamingEvent it) {
        return it.isObject();
    }

    private static final boolean doTransformObjectStream$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object doTransformObjectStream$lambda$9(StreamingEvent it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.embabel.common.core.streaming.StreamingEvent.Object<O of com.embabel.agent.spi.support.springai.streaming.StreamingChatClientOperations.doTransformObjectStream>");
        return ((StreamingEvent.Object)it).getItem();
    }

    private static final Object doTransformObjectStream$lambda$10(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final boolean doTransformObjectStreamInternal$lambda$11(String it) {
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0;
    }

    private static final boolean doTransformObjectStreamInternal$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit doTransformObjectStreamInternal$lambda$13(StreamingChatClientOperations this$0, String chunk) {
        Logger logger = this$0.logger;
        Intrinsics.checkNotNull((Object)chunk);
        logger.trace("RAW CHUNK: '" + StringsKt.replace$default((String)chunk, (String)"\n", (String)"\\n", (boolean)false, (int)4, null) + "'");
        return Unit.INSTANCE;
    }

    private static final void doTransformObjectStreamInternal$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Publisher doTransformObjectStreamInternal$lambda$15(StreamingChatClientOperations this$0, Flux chunkFlux) {
        Intrinsics.checkNotNull((Object)chunkFlux);
        return (Publisher)this$0.rawChunksToLines((Flux<String>)chunkFlux);
    }

    private static final Publisher doTransformObjectStreamInternal$lambda$16(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Unit doTransformObjectStreamInternal$lambda$17(StreamingChatClientOperations this$0, String line) {
        this$0.logger.trace("COMPLETE LINE: '" + line + "'");
        return Unit.INSTANCE;
    }

    private static final void doTransformObjectStreamInternal$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Publisher doTransformObjectStreamInternal$lambda$19(StreamingJacksonOutputConverter $streamingConverter, String line) {
        Intrinsics.checkNotNull((Object)line);
        return (Publisher)$streamingConverter.convertStreamWithThinking(line);
    }

    private static final Publisher doTransformObjectStreamInternal$lambda$20(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher rawChunksToLines$lambda$21(StringBuilder $buffer, String chunk) {
        int idx;
        $buffer.append(chunk);
        List lines = new ArrayList();
        while ((idx = StringsKt.indexOf$default((CharSequence)$buffer, (char)'\n', (int)0, (boolean)false, (int)6, null)) >= 0) {
            String string = $buffer.substring(0, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String line = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)line).length() > 0) {
                lines.add(line);
            }
            $buffer.delete(0, idx + 1);
        }
        return (Publisher)Flux.fromIterable((Iterable)lines);
    }

    private static final Publisher rawChunksToLines$lambda$22(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void rawChunksToLines$lambda$23(StringBuilder $buffer, StreamingChatClientOperations this$0) {
        if (((CharSequence)$buffer).length() > 0) {
            String string = $buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String finalLine = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)finalLine).length() > 0) {
                this$0.logger.trace("FINAL LINE: '" + finalLine + "'");
            }
        }
    }

    private static final String rawChunksToLines$lambda$24(StringBuilder $buffer) {
        String string = $buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final boolean rawChunksToLines$lambda$25(String it) {
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0;
    }

    private static final boolean rawChunksToLines$lambda$26(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

