/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.spi.common.RetryTemplateProvider;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;

@ConfigurationProperties(prefix="embabel.agent.platform.llm-operations.data-binding")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/spi/support/LlmDataBindingProperties;", "Lcom/embabel/agent/spi/common/RetryTemplateProvider;", "maxAttempts", "", "fixedBackoffMillis", "", "sendValidationInfo", "", "<init>", "(IJZ)V", "getMaxAttempts", "()I", "getFixedBackoffMillis", "()J", "getSendValidationInfo", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "retryTemplate", "Lorg/springframework/retry/support/RetryTemplate;", "name", "", "Companion", "embabel-agent-api"})
public final class LlmDataBindingProperties
implements RetryTemplateProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxAttempts;
    private final long fixedBackoffMillis;
    private final boolean sendValidationInfo;
    private final Logger logger;
    @NotNull
    private static final List<String> RATE_LIMIT_PATTERNS;

    public LlmDataBindingProperties(int maxAttempts, long fixedBackoffMillis, boolean sendValidationInfo) {
        this.maxAttempts = maxAttempts;
        this.fixedBackoffMillis = fixedBackoffMillis;
        this.sendValidationInfo = sendValidationInfo;
        this.logger = LoggerFactory.getLogger(LlmDataBindingProperties.class);
    }

    public /* synthetic */ LlmDataBindingProperties(int n, long l, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            l = 30L;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(n, l, bl);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final long getFixedBackoffMillis() {
        return this.fixedBackoffMillis;
    }

    public final boolean getSendValidationInfo() {
        return this.sendValidationInfo;
    }

    @Override
    @NotNull
    public RetryTemplate retryTemplate(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RetryTemplate retryTemplate2 = RetryTemplate.builder().maxAttempts(this.getMaxAttempts()).fixedBackoff(Duration.ofMillis(this.fixedBackoffMillis)).withListener(new RetryListener(this, name){
            final /* synthetic */ LlmDataBindingProperties this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
            }

            public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                if (LlmDataBindingProperties.Companion.isRateLimitError(throwable)) {
                    Object[] objectArray = new Object[]{this.$name, context.getRetryCount(), this.this$0.getMaxAttempts()};
                    LlmDataBindingProperties.access$getLogger$p(this.this$0).info("\ud83d\udd12 LLM invocation {} RATE LIMITED: Retry attempt {} of {}", objectArray);
                } else {
                    Logger logger = LlmDataBindingProperties.access$getLogger$p(this.this$0);
                    Object[] objectArray = new Object[4];
                    objectArray[0] = this.$name;
                    objectArray[1] = context.getRetryCount();
                    objectArray[2] = this.this$0.getMaxAttempts();
                    String string = throwable.getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    objectArray[3] = string;
                    logger.warn("LLM invocation {}: Retry attempt {} of {} due to: {}", objectArray);
                }
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)retryTemplate2, (String)"build(...)");
        return retryTemplate2;
    }

    public LlmDataBindingProperties() {
        this(0, 0L, false, 7, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(LlmDataBindingProperties $this) {
        return $this.logger;
    }

    static {
        Object[] objectArray = new String[]{"rate limit", "too many requests", "quota exceeded", "rate-limited", "429"};
        RATE_LIMIT_PATTERNS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/embabel/agent/spi/support/LlmDataBindingProperties$Companion;", "", "<init>", "()V", "RATE_LIMIT_PATTERNS", "", "", "isRateLimitError", "", "t", "", "embabel-agent-api"})
    @SourceDebugExtension(value={"SMAP\nLlmDataBindingProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmDataBindingProperties.kt\ncom/embabel/agent/spi/support/LlmDataBindingProperties$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1755#2,3:93\n*S KotlinDebug\n*F\n+ 1 LlmDataBindingProperties.kt\ncom/embabel/agent/spi/support/LlmDataBindingProperties$Companion\n*L\n86#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRateLimitError(@NotNull Throwable t) {
            boolean bl;
            block7: {
                String string;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        string = t.getMessage();
                        if (string == null) break block8;
                        String string2 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        string = string2;
                        if (string2 != null) break block9;
                    }
                    return false;
                }
                String message = string;
                Iterable $this$any$iv = RATE_LIMIT_PATTERNS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String pattern = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)message, (CharSequence)pattern, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

