/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.support;

import com.embabel.agent.core.Blackboard;
import com.embabel.common.util.FormatUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\nJ\u0013\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0002J\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0011\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\nH\u0096\u0002J\u001d\u0010\u001f\u001a\u00020\u00112\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0!H\u0096\u0002J\u0019\u0010\"\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\nH\u0096\u0002J-\u0010#\u001a\u0002H$\"\b\b\u0000\u0010$*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&H\u0016\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\u0017\u0010)\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0014\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0-H\u0016J\u001f\u0010.\u001a\u00020\u00032\b\u0010/\u001a\u0004\u0018\u00010\u00152\u0006\u00100\u001a\u000201H\u0016\u00a2\u0006\u0002\u00102R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lcom/embabel/agent/core/support/InMemoryBlackboard;", "Lcom/embabel/agent/core/Blackboard;", "blackboardId", "", "<init>", "(Ljava/lang/String;)V", "getBlackboardId", "()Ljava/lang/String;", "_map", "", "", "_entries", "", "hiddens", "", "spawn", "clear", "", "hide", "what", "isHidden", "", "objects", "", "getObjects", "()Ljava/util/List;", "get", "name", "bind", "key", "value", "plusAssign", "pair", "Lkotlin/Pair;", "set", "getOrPut", "V", "creator", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setCondition", "getCondition", "(Ljava/lang/String;)Ljava/lang/Boolean;", "addObject", "expressionEvaluationModel", "", "infoString", "verbose", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nInMemoryBlackboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryBlackboard.kt\ncom/embabel/agent/core/support/InMemoryBlackboard\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n381#2,7:151\n1#3:158\n*S KotlinDebug\n*F\n+ 1 InMemoryBlackboard.kt\ncom/embabel/agent/core/support/InMemoryBlackboard\n*L\n101#1:151,7\n*E\n"})
public final class InMemoryBlackboard
implements Blackboard {
    @NotNull
    private final String blackboardId;
    @NotNull
    private final Map<String, Object> _map;
    @NotNull
    private final List<Object> _entries;
    @NotNull
    private final Set<Object> hiddens;

    public InMemoryBlackboard(@NotNull String blackboardId) {
        Intrinsics.checkNotNullParameter((Object)blackboardId, (String)"blackboardId");
        this.blackboardId = blackboardId;
        this._map = new ConcurrentHashMap();
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this._entries = list;
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.hiddens = set;
    }

    public /* synthetic */ InMemoryBlackboard(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = UUID.randomUUID().toString();
        }
        this(string);
    }

    @Override
    @NotNull
    public String getBlackboardId() {
        return this.blackboardId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Blackboard spawn() {
        InMemoryBlackboard inMemoryBlackboard;
        InMemoryBlackboard $this$spawn_u24lambda_u241 = inMemoryBlackboard = new InMemoryBlackboard(null, 1, null);
        boolean bl = false;
        $this$spawn_u24lambda_u241._map.putAll(this._map);
        List<Object> list = $this$spawn_u24lambda_u241._entries;
        synchronized (list) {
            boolean bl2 = false;
            $this$spawn_u24lambda_u241._entries.addAll((Collection<Object>)this._entries);
            Unit unit = Unit.INSTANCE;
        }
        return inMemoryBlackboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this._map.clear();
        List<Object> list = this._entries;
        synchronized (list) {
            boolean bl = false;
            this._entries.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.hiddens.clear();
    }

    @Override
    public void hide(@NotNull Object what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        ((Collection)this.hiddens).add(what);
    }

    public final boolean isHidden(@NotNull Object what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        return this.hiddens.contains(what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Object> getObjects() {
        List list;
        List<Object> list2 = this._entries;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)CollectionsKt.minus((Iterable)this._entries, (Iterable)this.hiddens));
        }
        return list;
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this._map.get(name);
        if (object == null) {
            return null;
        }
        Object f = object;
        if (this.isHidden(f)) {
            return null;
        }
        return f;
    }

    @Override
    @NotNull
    public Blackboard bind(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._map.put(key, value);
        this._entries.add(value);
        return this;
    }

    @Override
    public void plusAssign(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addObject(value);
    }

    @Override
    public void plusAssign(@NotNull Pair<String, ? extends Object> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        this.bind((String)pair.getFirst(), pair.getSecond());
    }

    @Override
    public void set(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bind(key, value);
    }

    @Override
    @NotNull
    public <V> V getOrPut(@NotNull String name, @NotNull Function0<? extends V> creator) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        Map<String, Object> $this$getOrPut$iv = this._map;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            Object answer$iv = creator.invoke();
            $this$getOrPut$iv.put(name, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object entry = object;
        Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type V of com.embabel.agent.core.support.InMemoryBlackboard.getOrPut");
        return (V)entry;
    }

    @Override
    @NotNull
    public Blackboard setCondition(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Boolean bl = value;
        this._map.put(key, bl);
        this._entries.add(value);
        return this;
    }

    @Override
    @Nullable
    public Boolean getCondition(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this._map.get(key);
        return object instanceof Boolean ? (Boolean)object : null;
    }

    @Override
    @NotNull
    public Blackboard addObject(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._entries.add(value);
        return this;
    }

    @Override
    @NotNull
    public Map<String, Object> expressionEvaluationModel() {
        return MapsKt.toMap(this._map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        List list;
        Map mapSnapshot = MapsKt.toMap(this._map);
        List<Object> list2 = this._entries;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this._entries);
        }
        List objectsSnapshot = list;
        return FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("\n            |" + this.getClass().getSimpleName() + ": id=" + this.getBlackboardId() + "\n            |map:\n            |" + FormatUtilsKt.indent$default((String)CollectionsKt.joinToString$default((Iterable)mapSnapshot.entrySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (int)1, null, (int)2, null) + "\n            |entries:\n            |" + FormatUtilsKt.indent$default((String)CollectionsKt.joinToString$default((Iterable)objectsSnapshot, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (int)1, null, (int)2, null) + "\n            |"), null, (int)1, null), (int)indent, (boolean)false, (boolean)false, null, (int)14, null);
    }

    public InMemoryBlackboard() {
        this(null, 1, null);
    }
}

