/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core;

import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.Timed;
import com.embabel.common.core.types.Timestamped;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0016H\u00d6\u0001J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/embabel/agent/core/ActionInvocation;", "Lcom/embabel/common/core/types/Timestamped;", "Lcom/embabel/common/core/types/Timed;", "Lcom/embabel/common/core/types/HasInfoString;", "actionName", "", "timestamp", "Ljava/time/Instant;", "runningTime", "Ljava/time/Duration;", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Duration;)V", "getActionName", "()Ljava/lang/String;", "getTimestamp", "()Ljava/time/Instant;", "getRunningTime", "()Ljava/time/Duration;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "embabel-agent-api"})
public final class ActionInvocation
implements Timestamped,
Timed,
HasInfoString {
    @NotNull
    private final String actionName;
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final Duration runningTime;

    public ActionInvocation(@NotNull String actionName, @NotNull Instant timestamp, @NotNull Duration runningTime) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)runningTime, (String)"runningTime");
        this.actionName = actionName;
        this.timestamp = timestamp;
        this.runningTime = runningTime;
    }

    public /* synthetic */ ActionInvocation(String string, Instant instant, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            instant = Instant.now();
        }
        this(string, instant, duration);
    }

    @NotNull
    public final String getActionName() {
        return this.actionName;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public Duration getRunningTime() {
        return this.runningTime;
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        String string = "%,d";
        Object[] objectArray = new Object[]{this.getRunningTime().toMillis()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return this.actionName + "(" + string2 + "ms)";
    }

    @NotNull
    public final String component1() {
        return this.actionName;
    }

    @NotNull
    public final Instant component2() {
        return this.timestamp;
    }

    @NotNull
    public final Duration component3() {
        return this.runningTime;
    }

    @NotNull
    public final ActionInvocation copy(@NotNull String actionName, @NotNull Instant timestamp, @NotNull Duration runningTime) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)runningTime, (String)"runningTime");
        return new ActionInvocation(actionName, timestamp, runningTime);
    }

    public static /* synthetic */ ActionInvocation copy$default(ActionInvocation actionInvocation, String string, Instant instant, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            string = actionInvocation.actionName;
        }
        if ((n & 2) != 0) {
            instant = actionInvocation.timestamp;
        }
        if ((n & 4) != 0) {
            duration = actionInvocation.runningTime;
        }
        return actionInvocation.copy(string, instant, duration);
    }

    @NotNull
    public String toString() {
        return "ActionInvocation(actionName=" + this.actionName + ", timestamp=" + this.timestamp + ", runningTime=" + this.runningTime + ")";
    }

    public int hashCode() {
        int result = this.actionName.hashCode();
        result = result * 31 + this.timestamp.hashCode();
        result = result * 31 + this.runningTime.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActionInvocation)) {
            return false;
        }
        ActionInvocation actionInvocation = (ActionInvocation)other;
        if (!Intrinsics.areEqual((Object)this.actionName, (Object)actionInvocation.actionName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timestamp, (Object)actionInvocation.timestamp)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runningTime, (Object)actionInvocation.runningTime);
    }
}

