/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool;

import com.embabel.agent.api.common.Ai;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.spi.config.spring.InfrastructureInjectionConfigurationKt;
import com.embabel.common.ai.model.LlmOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 ?2\u00020\u0001:\u0001?BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u0012\u0018\b\u0002\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0019\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\r\u0012\u0006\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0013J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rH\u0016J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u001f\u0010%\u001a\u00020\u00002\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010'\"\u00020\u0001\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\rJ\u001e\u0010+\u001a\u00020\u00002\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u001f\u00100\u001a\u00020\u00002\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0'\"\u00020/\u00a2\u0006\u0002\u00102J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u00c6\u0003J\u0019\u00107\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eH\u00c6\u0003JQ\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0018\b\u0002\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eH\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u0010<\u001a\u00020=H\u00d6\u0001J\t\u0010>\u001a\u00020\rH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006@"}, d2={"Lcom/embabel/agent/api/tool/AgenticTool;", "Lcom/embabel/agent/api/tool/Tool;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "llm", "Lcom/embabel/common/ai/model/LlmOptions;", "tools", "", "systemPromptCreator", "Lkotlin/Function1;", "Lcom/embabel/agent/core/AgentProcess;", "", "Lcom/embabel/agent/api/tool/SystemPromptCreator;", "<init>", "(Lcom/embabel/agent/api/tool/Tool$Definition;Lcom/embabel/agent/api/tool/Tool$Metadata;Lcom/embabel/common/ai/model/LlmOptions;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "name", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "getLlm", "()Lcom/embabel/common/ai/model/LlmOptions;", "getTools", "()Ljava/util/List;", "getSystemPromptCreator", "()Lkotlin/jvm/functions/Function1;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "withLlm", "withParameter", "parameter", "Lcom/embabel/agent/api/tool/Tool$Parameter;", "withTools", "additionalTools", "", "([Lcom/embabel/agent/api/tool/Tool;)Lcom/embabel/agent/api/tool/AgenticTool;", "withSystemPrompt", "prompt", "withSystemPromptCreator", "promptCreator", "withToolObject", "toolObject", "", "withToolObjects", "toolObjects", "([Ljava/lang/Object;)Lcom/embabel/agent/api/tool/AgenticTool;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAgenticTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgenticTool.kt\ncom/embabel/agent/api/tool/AgenticTool\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n27#2:162\n27#2:163\n27#2:164\n10065#3:165\n10487#3,5:166\n*S KotlinDebug\n*F\n+ 1 AgenticTool.kt\ncom/embabel/agent/api/tool/AgenticTool\n*L\n67#1:162\n75#1:163\n82#1:164\n144#1:165\n144#1:166,5\n*E\n"})
public final class AgenticTool
implements Tool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;
    @NotNull
    private final LlmOptions llm;
    @NotNull
    private final List<Tool> tools;
    @NotNull
    private final Function1<AgentProcess, String> systemPromptCreator;

    public AgenticTool(@NotNull Tool.Definition definition2, @NotNull Tool.Metadata metadata2, @NotNull LlmOptions llm, @NotNull List<? extends Tool> tools, @NotNull Function1<? super AgentProcess, String> systemPromptCreator) {
        Intrinsics.checkNotNullParameter((Object)definition2, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter(systemPromptCreator, (String)"systemPromptCreator");
        this.definition = definition2;
        this.metadata = metadata2;
        this.llm = llm;
        this.tools = tools;
        this.systemPromptCreator = systemPromptCreator;
    }

    public /* synthetic */ AgenticTool(Tool.Definition definition2, Tool.Metadata metadata2, LlmOptions llmOptions, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            metadata2 = Tool.Metadata.DEFAULT;
        }
        if ((n & 4) != 0) {
            llmOptions = new LlmOptions(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            function1 = arg_0 -> AgenticTool._init_$lambda$0(definition2, arg_0);
        }
        this(definition2, metadata2, llmOptions, list, (Function1<? super AgentProcess, String>)function1);
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final LlmOptions getLlm() {
        return this.llm;
    }

    @NotNull
    public final List<Tool> getTools() {
        return this.tools;
    }

    @NotNull
    public final Function1<AgentProcess, String> getSystemPromptCreator() {
        return this.systemPromptCreator;
    }

    public AgenticTool(@NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this(Tool.Definition.Companion.invoke(name, description, Tool.InputSchema.Companion.empty()), null, null, null, null, 30, null);
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.tools.isEmpty()) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(AgenticTool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("No tools available for Agentic tool '{}'", (Object)this.getDefinition().getName());
            return Tool.Result.Companion.error$default(Tool.Result.Companion, "No tools available for Agentic tool", null, 2, null);
        }
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            AgenticTool $this$call_u24lambda_u241 = this;
            boolean bl = false;
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(AgenticTool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.error("No AgentProcess context available for Agentic tool '{}'", (Object)$this$call_u24lambda_u241.getDefinition().getName());
            return Tool.Result.Companion.error$default(Tool.Result.Companion, "No AgentProcess context available for Agentic tool", null, 2, null);
        }
        AgentProcess agentProcess2 = agentProcess;
        String systemPrompt = (String)this.systemPromptCreator.invoke((Object)agentProcess2);
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(AgenticTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.info("Executing Agentic tool '{}' with system prompt: {}", (Object)this.getDefinition().getName(), (Object)systemPrompt);
        Ai ai = InfrastructureInjectionConfigurationKt.executingOperationContextFor(agentProcess2).ai();
        String output = ai.withLlm(this.llm).withTools(this.tools).withSystemPrompt(systemPrompt).generateText(input);
        return Tool.Result.Companion.text(output);
    }

    @NotNull
    public final AgenticTool withLlm(@NotNull LlmOptions llm) {
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        return AgenticTool.copy$default(this, null, null, llm, null, null, 27, null);
    }

    @NotNull
    public final AgenticTool withParameter(@NotNull Tool.Parameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return AgenticTool.copy$default(this, this.getDefinition().withParameter(parameter), null, null, null, null, 30, null);
    }

    @NotNull
    public final AgenticTool withTools(Tool ... additionalTools) {
        Intrinsics.checkNotNullParameter((Object)additionalTools, (String)"additionalTools");
        return AgenticTool.copy$default(this, null, null, null, CollectionsKt.plus((Collection)this.tools, (Object[])additionalTools), null, 23, null);
    }

    @NotNull
    public final AgenticTool withSystemPrompt(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return AgenticTool.copy$default(this, null, null, null, null, arg_0 -> AgenticTool.withSystemPrompt$lambda$2(prompt, arg_0), 15, null);
    }

    @NotNull
    public final AgenticTool withSystemPromptCreator(@NotNull Function1<? super AgentProcess, String> promptCreator) {
        Intrinsics.checkNotNullParameter(promptCreator, (String)"promptCreator");
        return AgenticTool.copy$default(this, null, null, null, null, promptCreator, 15, null);
    }

    @NotNull
    public final AgenticTool withToolObject(@NotNull Object toolObject) {
        Intrinsics.checkNotNullParameter((Object)toolObject, (String)"toolObject");
        List additionalTools = Tool.Companion.safelyFromInstance$default(Tool.Companion, toolObject, null, 2, null);
        return additionalTools.isEmpty() ? this : AgenticTool.copy$default(this, null, null, null, CollectionsKt.plus((Collection)this.tools, (Iterable)additionalTools), null, 23, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AgenticTool withToolObjects(Object ... toolObjects) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolObjects, (String)"toolObjects");
        Object[] $this$flatMap$iv = toolObjects;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = Tool.Companion.safelyFromInstance$default(Tool.Companion, it, null, 2, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List additionalTools = (List)destination$iv$iv;
        return additionalTools.isEmpty() ? this : AgenticTool.copy$default(this, null, null, null, CollectionsKt.plus((Collection)this.tools, (Iterable)additionalTools), null, 23, null);
    }

    @NotNull
    public final Tool.Definition component1() {
        return this.definition;
    }

    @NotNull
    public final Tool.Metadata component2() {
        return this.metadata;
    }

    @NotNull
    public final LlmOptions component3() {
        return this.llm;
    }

    @NotNull
    public final List<Tool> component4() {
        return this.tools;
    }

    @NotNull
    public final Function1<AgentProcess, String> component5() {
        return this.systemPromptCreator;
    }

    @NotNull
    public final AgenticTool copy(@NotNull Tool.Definition definition2, @NotNull Tool.Metadata metadata2, @NotNull LlmOptions llm, @NotNull List<? extends Tool> tools, @NotNull Function1<? super AgentProcess, String> systemPromptCreator) {
        Intrinsics.checkNotNullParameter((Object)definition2, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter(systemPromptCreator, (String)"systemPromptCreator");
        return new AgenticTool(definition2, metadata2, llm, tools, systemPromptCreator);
    }

    public static /* synthetic */ AgenticTool copy$default(AgenticTool agenticTool, Tool.Definition definition2, Tool.Metadata metadata2, LlmOptions llmOptions, List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            definition2 = agenticTool.definition;
        }
        if ((n & 2) != 0) {
            metadata2 = agenticTool.metadata;
        }
        if ((n & 4) != 0) {
            llmOptions = agenticTool.llm;
        }
        if ((n & 8) != 0) {
            list = agenticTool.tools;
        }
        if ((n & 0x10) != 0) {
            function1 = agenticTool.systemPromptCreator;
        }
        return agenticTool.copy(definition2, metadata2, llmOptions, list, function1);
    }

    @NotNull
    public String toString() {
        return "AgenticTool(definition=" + this.definition + ", metadata=" + this.metadata + ", llm=" + this.llm + ", tools=" + this.tools + ", systemPromptCreator=" + this.systemPromptCreator + ")";
    }

    public int hashCode() {
        int result = this.definition.hashCode();
        result = result * 31 + this.metadata.hashCode();
        result = result * 31 + this.llm.hashCode();
        result = result * 31 + ((Object)this.tools).hashCode();
        result = result * 31 + this.systemPromptCreator.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgenticTool)) {
            return false;
        }
        AgenticTool agenticTool = (AgenticTool)other;
        if (!Intrinsics.areEqual((Object)this.definition, (Object)agenticTool.definition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadata, (Object)agenticTool.metadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.llm, (Object)agenticTool.llm)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tools, agenticTool.tools)) {
            return false;
        }
        return Intrinsics.areEqual(this.systemPromptCreator, agenticTool.systemPromptCreator);
    }

    private static final String _init_$lambda$0(Tool.Definition $definition, AgentProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.defaultSystemPrompt($definition.getDescription());
    }

    private static final String withSystemPrompt$lambda$2(String $prompt, AgentProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $prompt;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lcom/embabel/agent/api/tool/AgenticTool$Companion;", "", "<init>", "()V", "defaultSystemPrompt", "", "description", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String defaultSystemPrompt(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return StringsKt.trimIndent((String)("\n            You are an intelligent agent that can use tools to help you complete tasks.\n            Use the provided tools to perform the following task:\n            " + description + "\n            "));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

