/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.core.ToolGroup;
import com.embabel.agent.core.ToolGroupMetadata;
import com.embabel.agent.core.ToolGroupRequirement;
import com.embabel.agent.core.ToolGroupResolution;
import com.embabel.agent.spi.ToolGroupResolver;
import com.embabel.common.core.types.HasInfoString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u001f\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/embabel/agent/spi/support/RegistryToolGroupResolver;", "Lcom/embabel/agent/spi/ToolGroupResolver;", "name", "", "toolGroups", "", "Lcom/embabel/agent/core/ToolGroup;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getToolGroups", "()Ljava/util/List;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "availableToolGroups", "Lcom/embabel/agent/core/ToolGroupMetadata;", "resolveToolGroup", "Lcom/embabel/agent/core/ToolGroupResolution;", "requirement", "Lcom/embabel/agent/core/ToolGroupRequirement;", "findToolGroupForTool", "toolName", "toString", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nRegistryToolGroupResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryToolGroupResolver.kt\ncom/embabel/agent/spi/support/RegistryToolGroupResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1557#2:93\n1628#2,3:94\n1557#2:98\n1628#2,3:99\n1053#2:102\n1#3:97\n*S KotlinDebug\n*F\n+ 1 RegistryToolGroupResolver.kt\ncom/embabel/agent/spi/support/RegistryToolGroupResolver\n*L\n43#1:93\n43#1:94,3\n60#1:98\n60#1:99,3\n85#1:102\n*E\n"})
public final class RegistryToolGroupResolver
implements ToolGroupResolver {
    @NotNull
    private final String name;
    @NotNull
    private final List<ToolGroup> toolGroups;
    private final Logger logger;

    public RegistryToolGroupResolver(@NotNull String name, @NotNull List<? extends ToolGroup> toolGroups) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(toolGroups, (String)"toolGroups");
        this.name = name;
        this.toolGroups = toolGroups;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.info(HasInfoString.infoString$default((HasInfoString)this, (Boolean)true, (int)0, (int)2, null));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final List<ToolGroup> getToolGroups() {
        return this.toolGroups;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ToolGroupMetadata> availableToolGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.toolGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolGroup toolGroup = (ToolGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMetadata());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ToolGroupResolution resolveToolGroup(@NotNull ToolGroupRequirement requirement) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            Iterable iterable = this.toolGroups;
            for (Object t : iterable) {
                ToolGroup it = (ToolGroup)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMetadata().getRole(), (Object)requirement.getRole())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        ToolGroup group = v0;
        return group == null ? new ToolGroupResolution(null, "No tool group matching role '" + requirement.getRole() + "'") : new ToolGroupResolution(group, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ToolGroupResolution findToolGroupForTool(@NotNull String toolName) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            Iterable iterable = this.toolGroups;
            for (Object t : iterable) {
                void $this$mapTo$iv$iv;
                ToolGroup it = (ToolGroup)t;
                boolean bl = false;
                Iterable $this$map$iv = it.getToolCallbacks();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    ToolCallback toolCallback = (ToolCallback)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it2.getToolDefinition().name());
                }
                if (!((List)destination$iv$iv).contains(toolName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ToolGroup group = v0;
        return group == null ? new ToolGroupResolution(null, "No tool group matching tool '" + toolName + "'") : new ToolGroupResolution(group, null, 2, null);
    }

    @NotNull
    public String toString() {
        return "RegistryToolGroupResolver(name='" + this.getName() + "', " + this.toolGroups.size() + " toolGroups: " + CollectionsKt.joinToString$default((Iterable)this.toolGroups, (CharSequence)", ", null, null, (int)0, null, RegistryToolGroupResolver::toString$lambda$4, (int)30, null) + ")";
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        if (Intrinsics.areEqual((Object)verbose, (Object)false)) {
            return "RegistryToolGroupResolver(name='" + this.getName() + "', " + this.toolGroups.size() + " tool groups)";
        }
        Iterable $this$sortedBy$iv = this.toolGroups;
        boolean $i$f$sortedBy = false;
        return "RegistryToolGroupResolver: name='" + this.getName() + "', " + this.toolGroups.size() + " available tool groups:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ToolGroup it = (ToolGroup)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMetadata().getRole());
                it = (ToolGroup)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMetadata().getRole())));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, RegistryToolGroupResolver::infoString$lambda$6, (int)30, null);
    }

    private static final CharSequence toString$lambda$4(ToolGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMetadata().getRole();
    }

    private static final CharSequence infoString$lambda$6(ToolGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.infoString(true, 1);
    }
}

