/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.file;

import com.embabel.agent.api.common.support.SelfToolCallbackPublisher;
import com.embabel.agent.tools.DirectoryBased;
import com.embabel.agent.tools.file.FileAccessLog;
import com.embabel.agent.tools.file.FileReadLog;
import com.embabel.agent.tools.file.FileToolsKt;
import com.embabel.common.util.StringTransformer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u0011\u001a\u00020\u000bH\u0017J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0017J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u0014\u001a\u00020\u000bH\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/tools/file/FileReadTools;", "Lcom/embabel/agent/tools/DirectoryBased;", "Lcom/embabel/agent/tools/file/FileReadLog;", "Lcom/embabel/agent/tools/file/FileAccessLog;", "Lcom/embabel/agent/api/common/support/SelfToolCallbackPublisher;", "fileContentTransformers", "", "Lcom/embabel/common/util/StringTransformer;", "getFileContentTransformers", "()Ljava/util/List;", "getPathsAccessed", "", "exists", "", "fileCount", "", "findFiles", "glob", "findHighest", "safeReadFile", "path", "readFile", "listFiles", "resolvePath", "Ljava/nio/file/Path;", "resolveAndValidateFile", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nFileTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTools.kt\ncom/embabel/agent/tools/file/FileReadTools\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,510:1\n27#2:511\n27#2:516\n27#2:517\n27#2:518\n1863#3,2:512\n1863#3,2:514\n*S KotlinDebug\n*F\n+ 1 FileTools.kt\ncom/embabel/agent/tools/file/FileReadTools\n*L\n138#1:511\n218#1:516\n232#1:517\n243#1:518\n196#1:512,2\n210#1:514,2\n*E\n"})
public interface FileReadTools
extends DirectoryBased,
FileReadLog,
FileAccessLog,
SelfToolCallbackPublisher {
    @NotNull
    public List<StringTransformer> getFileContentTransformers();

    @Override
    @NotNull
    default public List<String> getPathsAccessed() {
        return this.getPathsRead();
    }

    default public boolean exists() {
        return Files.exists(this.resolvePath(""), new LinkOption[0]);
    }

    @Tool(description="Count the number of files in the repository, excluding .git directory")
    default public int fileCount() {
        int n;
        try {
            Path rootPath = this.resolvePath("");
            AtomicInteger fileCount2 = new AtomicInteger(0);
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(fileCount2){
                final /* synthetic */ AtomicInteger $fileCount;
                {
                    this.$fileCount = $fileCount;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Path path = dir.getFileName();
                    String dirName = path != null ? ((Object)path).toString() : null;
                    return Intrinsics.areEqual((Object)dirName, (Object)".git") ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    if (attrs.isRegularFile()) {
                        this.$fileCount.incrementAndGet();
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                    boolean $i$f$loggerFor = false;
                    Logger logger = LoggerFactory.getLogger(FileReadTools.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    logger.warn("Warning: Could not access file: {} ({})", (Object)file, (Object)exc.getMessage());
                    return FileVisitResult.CONTINUE;
                }
            });
            n = fileCount2.get();
        }
        catch (Exception e) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(FileReadTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.error("Failed to count files", (Throwable)e);
            n = 0;
        }
        return n;
    }

    @Tool(description="Find files using glob patterns. Return absolute paths")
    @NotNull
    default public List<String> findFiles(@NotNull String glob) {
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        return this.findFiles(glob, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    default public List<String> findFiles(@NotNull String glob, boolean findHighest) {
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        Path basePath = Paths.get(this.getRoot(), new String[0]).toAbsolutePath().normalize();
        String syntaxAndPattern = StringsKt.startsWith$default((String)glob, (String)"glob:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)glob, (String)"regex:", (boolean)false, (int)2, null) ? glob : "glob:" + glob;
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
        List results = new ArrayList();
        if (!findHighest) {
            Object object;
            AutoCloseable autoCloseable = Files.walk(basePath, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Object paths = (Stream)autoCloseable;
                boolean bl = false;
                paths = paths.filter(arg_0 -> FileReadTools.findFiles$lambda$4$lambda$1(arg_0 -> FileReadTools.findFiles$lambda$4$lambda$0(matcher, basePath, arg_0), arg_0)).map(arg_0 -> FileReadTools.findFiles$lambda$4$lambda$3(FileReadTools::findFiles$lambda$4$lambda$2, arg_0)).toList();
                object = paths;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
            return object;
        }
        Set processedDirs = new LinkedHashSet();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.offer(basePath);
        while (!((Collection)queue).isEmpty()) {
            Path dir = (Path)queue.poll();
            String dirStr = ((Object)dir.toAbsolutePath()).toString();
            if (processedDirs.contains(dirStr)) continue;
            processedDirs.add(dirStr);
            if (Files.isRegularFile(dir, new LinkOption[0]) && matcher.matches(basePath.relativize(dir))) {
                results.add(dirStr);
                continue;
            }
            try {
                List matchesInDir = new ArrayList();
                List subdirs = new ArrayList();
                Closeable closeable = Files.newDirectoryStream(dir);
                Throwable throwable = null;
                try {
                    DirectoryStream stream = (DirectoryStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)stream);
                    Iterable $this$forEach$iv = stream;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path entry = (Path)element$iv;
                        boolean bl2 = false;
                        if (Files.isDirectory(entry, new LinkOption[0])) {
                            Intrinsics.checkNotNull((Object)entry);
                            subdirs.add(entry);
                            continue;
                        }
                        if (!matcher.matches(basePath.relativize(entry))) continue;
                        matchesInDir.add(((Object)entry.toAbsolutePath()).toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (!((Collection)matchesInDir).isEmpty()) {
                    results.addAll(matchesInDir);
                    Iterable $this$forEach$iv = subdirs;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path subdir = (Path)element$iv;
                        boolean bl = false;
                        processedDirs.add(((Object)subdir.toAbsolutePath()).toString());
                    }
                    continue;
                }
                queue.addAll(subdirs);
            }
            catch (IOException iOException) {
                boolean $i$f$loggerFor = false;
                Logger logger = LoggerFactory.getLogger(FileReadTools.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.warn("Failed to read directory at {}", (Object)dirStr);
            }
        }
        return results;
    }

    @Nullable
    default public String safeReadFile(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            string = this.readFile(path);
        }
        catch (Exception e) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(FileReadTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("Failed to read file at {}: {}", (Object)path, (Object)e.getMessage());
            string = null;
        }
        return string;
    }

    @Tool(description="Read a file at the relative path")
    @NotNull
    default public String readFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path resolvedPath = this.resolveAndValidateFile(path);
        String rawContent = Files.readString(resolvedPath);
        Intrinsics.checkNotNull((Object)rawContent);
        String transformedContent = StringTransformer.Companion.transform(rawContent, this.getFileContentTransformers());
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(FileReadTools.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Object[] objectArray = new Object[4];
        objectArray[0] = path;
        objectArray[1] = this.getFileContentTransformers().size();
        String string = "%,d";
        Object[] objectArray2 = new Object[]{rawContent.length()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        string = "%,d";
        objectArray2 = new Object[]{transformedContent.length()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        logger.debug("Transformed {} content with {} sanitizers: Length went from {} to {}", objectArray);
        this.recordRead(path);
        return transformedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Tool(description="List files and directories at a given path. Prefix is f: for file or d: for directory")
    @NotNull
    default public List<String> listFiles(@NotNull String path) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path resolvedPath = this.resolvePath(path);
        if (!Files.exists(resolvedPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Directory does not exist: " + path + ", root=" + this.getRoot());
        }
        if (!Files.isDirectory(resolvedPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Path is not a directory: " + path + ", root=" + this.getRoot());
        }
        AutoCloseable autoCloseable = Files.list(resolvedPath);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            List<String> list2 = stream.map(arg_0 -> FileReadTools.listFiles$lambda$10$lambda$9(FileReadTools::listFiles$lambda$10$lambda$8, arg_0)).sorted().toList();
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"use(...)");
        return list;
    }

    @NotNull
    default public Path resolvePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileToolsKt.access$resolvePath(this.getRoot(), path);
    }

    @NotNull
    default public Path resolveAndValidateFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileToolsKt.access$resolveAndValidateFile(this.getRoot(), path);
    }

    private static boolean findFiles$lambda$4$lambda$0(PathMatcher $matcher, Path $basePath, Path it) {
        return $matcher.matches($basePath.relativize(it));
    }

    private static boolean findFiles$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static String findFiles$lambda$4$lambda$2(Path it) {
        return ((Object)it.toAbsolutePath()).toString();
    }

    private static String findFiles$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static String listFiles$lambda$10$lambda$8(Path it) {
        String prefix = Files.isDirectory(it, new LinkOption[0]) ? "d:" : "f:";
        return prefix + it.getFileName();
    }

    private static String listFiles$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

