/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.agent;

import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.Verbosity;
import com.embabel.agent.tools.agent.TextCommunicator;
import com.embabel.agent.tools.agent.TypeWrappingToolDefinition;
import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BX\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u001a\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020(H\u0016J\t\u0010-\u001a\u00020\u0005H\u00c2\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\tH\u00c6\u0003J\t\u00100\u001a\u00020\u000bH\u00c6\u0003J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u00c6\u0003J$\u00102\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000fH\u00c6\u0003Jl\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2#\b\u0002\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000fH\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u00107\u001a\u000208H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR,\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$\u00a8\u00069"}, d2={"Lcom/embabel/agent/tools/agent/AgentToolCallback;", "I", "", "Lorg/springframework/ai/tool/ToolCallback;", "autonomy", "Lcom/embabel/agent/api/common/autonomy/Autonomy;", "agent", "Lcom/embabel/agent/core/Agent;", "textCommunicator", "Lcom/embabel/agent/tools/agent/TextCommunicator;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "inputType", "Ljava/lang/Class;", "processOptionsCreator", "Lkotlin/Function1;", "Lcom/embabel/agent/core/AgentProcess;", "Lkotlin/ParameterName;", "name", "parentAgentProcess", "Lcom/embabel/agent/core/ProcessOptions;", "<init>", "(Lcom/embabel/agent/api/common/autonomy/Autonomy;Lcom/embabel/agent/core/Agent;Lcom/embabel/agent/tools/agent/TextCommunicator;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "getAgent", "()Lcom/embabel/agent/core/Agent;", "getTextCommunicator", "()Lcom/embabel/agent/tools/agent/TextCommunicator;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getInputType", "()Ljava/lang/Class;", "getProcessOptionsCreator", "()Lkotlin/jvm/functions/Function1;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "getToolDefinition", "Lorg/springframework/ai/tool/definition/ToolDefinition;", "call", "", "toolInput", "toolContext", "Lorg/springframework/ai/chat/model/ToolContext;", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "embabel-agent-api"})
public final class AgentToolCallback<I>
implements ToolCallback {
    @NotNull
    private final Autonomy autonomy;
    @NotNull
    private final Agent agent;
    @NotNull
    private final TextCommunicator textCommunicator;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Class<I> inputType;
    @NotNull
    private final Function1<AgentProcess, ProcessOptions> processOptionsCreator;
    private final Logger logger;

    public AgentToolCallback(@NotNull Autonomy autonomy, @NotNull Agent agent, @NotNull TextCommunicator textCommunicator, @NotNull ObjectMapper objectMapper, @NotNull Class<I> inputType, @NotNull Function1<? super AgentProcess, ProcessOptions> processOptionsCreator) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)textCommunicator, (String)"textCommunicator");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(processOptionsCreator, (String)"processOptionsCreator");
        this.autonomy = autonomy;
        this.agent = agent;
        this.textCommunicator = textCommunicator;
        this.objectMapper = objectMapper;
        this.inputType = inputType;
        this.processOptionsCreator = processOptionsCreator;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final Agent getAgent() {
        return this.agent;
    }

    @NotNull
    public final TextCommunicator getTextCommunicator() {
        return this.textCommunicator;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public final Class<I> getInputType() {
        return this.inputType;
    }

    @NotNull
    public final Function1<AgentProcess, ProcessOptions> getProcessOptionsCreator() {
        return this.processOptionsCreator;
    }

    @NotNull
    public ToolDefinition getToolDefinition() {
        return new TypeWrappingToolDefinition(this.agent.getName(), this.agent.getDescription(), this.inputType);
    }

    @NotNull
    public String call(@NotNull String toolInput) {
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        return this.call(toolInput, null);
    }

    @NotNull
    public String call(@NotNull String toolInput, @Nullable ToolContext toolContext) {
        Object object;
        Object inputObject;
        block7: {
            Verbosity verbosity;
            block6: {
                Object o;
                Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
                AgentProcess parentAgentProcess = AgentProcess.Companion.get();
                this.logger.info("Calling tool {} with input {}", (Object)this.agent.getName(), (Object)toolInput);
                verbosity = new Verbosity(true, false, false, false, 14, null);
                try {
                    o = this.objectMapper.readValue(toolInput, this.inputType);
                    this.logger.info("Successfully parsed tool input to an instance of {}:\n{}", (Object)o.getClass().getName(), o);
                }
                catch (Exception e) {
                    String errorReturn = "BAD INPUT ERROR parsing tool input: " + e.getMessage() + ": Try again and see if you can get the format right";
                    this.logger.warn("Error " + errorReturn + " parsing tool input: " + toolInput, (Throwable)e);
                    return errorReturn;
                }
                inputObject = o;
                object = parentAgentProcess;
                if (object == null) break block6;
                AgentProcess it = object;
                boolean bl = false;
                this.logger.info("Found parent agent process: {} and creating ProcessOptions based on it", (Object)it);
                ProcessOptions processOptions = (ProcessOptions)this.processOptionsCreator.invoke((Object)parentAgentProcess);
                object = processOptions;
                if (processOptions != null) break block7;
            }
            AgentToolCallback $this$call_u24lambda_u241 = this;
            boolean bl = false;
            $this$call_u24lambda_u241.logger.warn("No parent agent process found in tool context, using default process options.");
            object = new ProcessOptions(null, null, null, verbosity, null, null, false, null, null, 503, null);
        }
        Object processOptions = object;
        try {
            Intrinsics.checkNotNull((Object)inputObject);
            AgentProcessExecution agentProcessExecution = this.autonomy.runAgent(inputObject, (ProcessOptions)processOptions, this.agent);
            this.logger.info("Agent response: {}", (Object)agentProcessExecution);
            return this.textCommunicator.communicateResult(agentProcessExecution);
        }
        catch (ProcessWaitingException pwe) {
            String response = this.textCommunicator.communicateAwaitable(this.agent, pwe);
            this.logger.info("Returning waiting response:\n" + response);
            return response;
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(agent=" + this.agent.getName() + ", description=" + this.agent.getDescription() + ")";
    }

    private final Autonomy component1() {
        return this.autonomy;
    }

    @NotNull
    public final Agent component2() {
        return this.agent;
    }

    @NotNull
    public final TextCommunicator component3() {
        return this.textCommunicator;
    }

    @NotNull
    public final ObjectMapper component4() {
        return this.objectMapper;
    }

    @NotNull
    public final Class<I> component5() {
        return this.inputType;
    }

    @NotNull
    public final Function1<AgentProcess, ProcessOptions> component6() {
        return this.processOptionsCreator;
    }

    @NotNull
    public final AgentToolCallback<I> copy(@NotNull Autonomy autonomy, @NotNull Agent agent, @NotNull TextCommunicator textCommunicator, @NotNull ObjectMapper objectMapper, @NotNull Class<I> inputType, @NotNull Function1<? super AgentProcess, ProcessOptions> processOptionsCreator) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)textCommunicator, (String)"textCommunicator");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(processOptionsCreator, (String)"processOptionsCreator");
        return new AgentToolCallback<I>(autonomy, agent, textCommunicator, objectMapper, inputType, processOptionsCreator);
    }

    public static /* synthetic */ AgentToolCallback copy$default(AgentToolCallback agentToolCallback, Autonomy autonomy, Agent agent, TextCommunicator textCommunicator, ObjectMapper objectMapper, Class clazz, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            autonomy = agentToolCallback.autonomy;
        }
        if ((n & 2) != 0) {
            agent = agentToolCallback.agent;
        }
        if ((n & 4) != 0) {
            textCommunicator = agentToolCallback.textCommunicator;
        }
        if ((n & 8) != 0) {
            objectMapper = agentToolCallback.objectMapper;
        }
        if ((n & 0x10) != 0) {
            clazz = agentToolCallback.inputType;
        }
        if ((n & 0x20) != 0) {
            function1 = agentToolCallback.processOptionsCreator;
        }
        return agentToolCallback.copy(autonomy, agent, textCommunicator, objectMapper, clazz, function1);
    }

    public int hashCode() {
        int result = this.autonomy.hashCode();
        result = result * 31 + this.agent.hashCode();
        result = result * 31 + this.textCommunicator.hashCode();
        result = result * 31 + this.objectMapper.hashCode();
        result = result * 31 + this.inputType.hashCode();
        result = result * 31 + this.processOptionsCreator.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgentToolCallback)) {
            return false;
        }
        AgentToolCallback agentToolCallback = (AgentToolCallback)other;
        if (!Intrinsics.areEqual((Object)this.autonomy, (Object)agentToolCallback.autonomy)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.agent, (Object)agentToolCallback.agent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textCommunicator, (Object)agentToolCallback.textCommunicator)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.objectMapper, (Object)agentToolCallback.objectMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputType, agentToolCallback.inputType)) {
            return false;
        }
        return Intrinsics.areEqual(this.processOptionsCreator, agentToolCallback.processOptionsCreator);
    }
}

