/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.support;

import com.embabel.agent.rag.QualityMetrics;
import com.embabel.agent.rag.RagRequest;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagResponseEnhancement;
import com.embabel.agent.rag.RagService;
import com.embabel.agent.rag.WritableStore;
import com.embabel.agent.rag.ingestion.MaterializedDocument;
import com.embabel.agent.rag.support.DocumentSimilarityResult;
import com.embabel.common.util.FormatUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001f\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006#"}, d2={"Lcom/embabel/agent/rag/support/SpringVectorStoreRagService;", "Lcom/embabel/agent/rag/WritableStore;", "Lcom/embabel/agent/rag/RagService;", "vectorStore", "Lorg/springframework/ai/vectorstore/VectorStore;", "description", "", "<init>", "(Lorg/springframework/ai/vectorstore/VectorStore;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "name", "getName", "search", "Lcom/embabel/agent/rag/RagResponse;", "ragRequest", "Lcom/embabel/agent/rag/RagRequest;", "accept", "", "documents", "", "Lorg/springframework/ai/document/Document;", "writeContent", "root", "Lcom/embabel/agent/rag/ingestion/MaterializedDocument;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-api"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nSpringVectorStoreRagService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringVectorStoreRagService.kt\ncom/embabel/agent/rag/support/SpringVectorStoreRagService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1557#2:101\n1628#2,3:102\n*S KotlinDebug\n*F\n+ 1 SpringVectorStoreRagService.kt\ncom/embabel/agent/rag/support/SpringVectorStoreRagService\n*L\n55#1:101\n55#1:102,3\n*E\n"})
public final class SpringVectorStoreRagService
implements WritableStore,
RagService {
    @NotNull
    private final VectorStore vectorStore;
    @NotNull
    private final String description;
    private final Logger logger;

    public SpringVectorStoreRagService(@NotNull VectorStore vectorStore, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)vectorStore, (String)"vectorStore");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.vectorStore = vectorStore;
        this.description = description;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.vectorStore.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RagResponse search(@NotNull RagRequest ragRequest) {
        Collection<DocumentSimilarityResult> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
        SearchRequest searchRequest = SearchRequest.builder().query(ragRequest.getQuery()).similarityThreshold(ragRequest.getSimilarityThreshold()).topK(ragRequest.getTopK()).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"build(...)");
        SearchRequest searchRequest2 = searchRequest;
        List list = this.vectorStore.similaritySearch(searchRequest2);
        Intrinsics.checkNotNull((Object)list);
        List results = list;
        Iterable iterable = results;
        String string = this.getName();
        RagRequest ragRequest2 = ragRequest;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getScore();
            Intrinsics.checkNotNull((Object)d);
            collection.add(new DocumentSimilarityResult((Document)it, d));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Instant instant = null;
        QualityMetrics qualityMetrics = null;
        RagResponseEnhancement ragResponseEnhancement = null;
        List list2 = collection;
        String string2 = string;
        RagRequest ragRequest3 = ragRequest2;
        return new RagResponse(ragRequest3, string2, list2, ragResponseEnhancement, qualityMetrics, instant, n, defaultConstructorMarker);
    }

    public void accept(@NotNull List<? extends Document> documents) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.logger.info("Writing " + documents.size() + " documents into Spring vector store");
        this.vectorStore.accept(documents);
    }

    @Override
    @NotNull
    public List<String> writeContent(@NotNull MaterializedDocument root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return FormatUtilsKt.indent$default((String)(this.vectorStore.getName() + ": " + this.vectorStore.getClass().getName()), (int)indent, null, (int)2, null);
    }
}

