/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.CrudRepository;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B7\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u0002H\u000e\"\b\b\u0001\u0010\u000e*\u00028\u00002\u0006\u0010\u000f\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012\"\b\b\u0001\u0010\u000e*\u00028\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016J\u0016\u0010#\u001a\u00020\u001f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\b\u0010#\u001a\u00020\u001fH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/embabel/agent/domain/InMemoryCrudRepository;", "T", "", "Lorg/springframework/data/repository/CrudRepository;", "", "idGetter", "Lkotlin/Function1;", "idSetter", "Lkotlin/Function2;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "save", "S", "entity", "(Ljava/lang/Object;)Ljava/lang/Object;", "saveAll", "", "entities", "findById", "Ljava/util/Optional;", "id", "existsById", "", "findAll", "findAllById", "ids", "count", "", "deleteById", "", "delete", "(Ljava/lang/Object;)V", "deleteAllById", "deleteAll", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nInMemoryCrudRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryCrudRepository.kt\ncom/embabel/agent/domain/InMemoryCrudRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1557#2:94\n1628#2,3:95\n1611#2,9:98\n1863#2:107\n1864#2:109\n1620#2:110\n1863#2,2:111\n1863#2,2:113\n1#3:108\n*S KotlinDebug\n*F\n+ 1 InMemoryCrudRepository.kt\ncom/embabel/agent/domain/InMemoryCrudRepository\n*L\n46#1:94\n46#1:95,3\n62#1:98,9\n62#1:107\n62#1:109\n62#1:110\n81#1:111,2\n85#1:113,2\n62#1:108\n*E\n"})
public class InMemoryCrudRepository<T>
implements CrudRepository<T, String> {
    @NotNull
    private final Function1<T, String> idGetter;
    @NotNull
    private final Function2<T, String, T> idSetter;
    @NotNull
    private final ConcurrentHashMap<String, T> storage;

    public InMemoryCrudRepository(@NotNull Function1<? super T, String> idGetter, @NotNull Function2<? super T, ? super String, ? extends T> idSetter) {
        Intrinsics.checkNotNullParameter(idGetter, (String)"idGetter");
        Intrinsics.checkNotNullParameter(idSetter, (String)"idSetter");
        this.idGetter = idGetter;
        this.idSetter = idSetter;
        this.storage = new ConcurrentHashMap();
    }

    @NotNull
    public <S extends T> S save(@NotNull S entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        S savedEntity = entity;
        String existingId = (String)this.idGetter.invoke(entity);
        String string = existingId;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String id = string;
        Object object = existingId == null ? this.idSetter.invoke(savedEntity, (Object)id) : entity;
        Intrinsics.checkNotNull(object, (String)"null cannot be cast to non-null type S of com.embabel.agent.domain.InMemoryCrudRepository.save");
        savedEntity = object;
        ((Map)this.storage).put(id, savedEntity);
        return savedEntity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <S extends T> Iterable<S> saveAll(@NotNull Iterable<? extends S> entities) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Iterable<? extends S> $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable<? extends S> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.save(it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Optional<T> findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Optional<T> optional = Optional.ofNullable(this.storage.get(id));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public boolean existsById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.storage.containsKey(id);
    }

    @NotNull
    public Iterable<T> findAll() {
        return new ArrayList<T>(this.storage.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<T> findAllById(@NotNull Iterable<String> ids) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable<String> $this$mapNotNull$iv = ids;
        boolean $i$f$mapNotNull = false;
        Iterable<String> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            T it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.storage.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public long count() {
        return this.storage.size();
    }

    public void deleteById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.storage.remove(id);
    }

    public void delete(@NotNull T entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        String id = (String)this.idGetter.invoke(entity);
        if (id != null) {
            this.deleteById(id);
        }
    }

    public void deleteAllById(@NotNull Iterable<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable<String> $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.deleteById(it);
        }
    }

    public void deleteAll(@NotNull Iterable<? extends T> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Iterable<T> $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        Iterator<T> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            T element$iv;
            T it = element$iv = iterator.next();
            boolean bl = false;
            this.delete(it);
        }
    }

    public void deleteAll() {
        this.storage.clear();
    }
}

