/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core;

import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.core.Condition;
import com.embabel.plan.goap.ConditionDetermination;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/core/OrCondition;", "Lcom/embabel/agent/core/Condition;", "a", "b", "<init>", "(Lcom/embabel/agent/core/Condition;Lcom/embabel/agent/core/Condition;)V", "name", "", "getName", "()Ljava/lang/String;", "cost", "", "getCost", "()D", "evaluate", "Lcom/embabel/plan/goap/ConditionDetermination;", "context", "Lcom/embabel/agent/api/common/OperationContext;", "embabel-agent-api"})
final class OrCondition
implements Condition {
    @NotNull
    private final Condition a;
    @NotNull
    private final Condition b;
    @NotNull
    private final String name;
    private final double cost;

    public OrCondition(@NotNull Condition a, @NotNull Condition b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.a = a;
        this.b = b;
        this.name = "(" + this.a.getName() + " OR " + this.b.getName() + ")";
        this.cost = Math.min(this.a.getCost(), this.b.getCost());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    @NotNull
    public ConditionDetermination evaluate(@NotNull OperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConditionDetermination aResult = this.a.evaluate(context);
        if (aResult == ConditionDetermination.TRUE) {
            return ConditionDetermination.TRUE;
        }
        ConditionDetermination bResult = this.b.evaluate(context);
        if (bResult == ConditionDetermination.TRUE) {
            return ConditionDetermination.TRUE;
        }
        if (aResult == ConditionDetermination.UNKNOWN || bResult == ConditionDetermination.UNKNOWN) {
            return ConditionDetermination.UNKNOWN;
        }
        return ConditionDetermination.FALSE;
    }
}

