/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.models;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B:\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/api/models/FallbackChatModel;", "Lorg/springframework/ai/chat/model/ChatModel;", "model", "fallback", "whenError", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "t", "", "<init>", "(Lorg/springframework/ai/chat/model/ChatModel;Lorg/springframework/ai/chat/model/ChatModel;Lkotlin/jvm/functions/Function1;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "call", "Lorg/springframework/ai/chat/model/ChatResponse;", "prompt", "Lorg/springframework/ai/chat/prompt/Prompt;", "embabel-agent-api"})
public final class FallbackChatModel
implements ChatModel {
    @NotNull
    private final ChatModel model;
    @NotNull
    private final ChatModel fallback;
    @NotNull
    private final Function1<Throwable, Boolean> whenError;
    private final Logger logger;

    public FallbackChatModel(@NotNull ChatModel model, @NotNull ChatModel fallback, @NotNull Function1<? super Throwable, Boolean> whenError) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        Intrinsics.checkNotNullParameter(whenError, (String)"whenError");
        this.model = model;
        this.fallback = fallback;
        this.whenError = whenError;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public ChatResponse call(@NotNull Prompt prompt) {
        ChatResponse chatResponse;
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        try {
            chatResponse = this.model.call(prompt);
            Intrinsics.checkNotNull((Object)chatResponse);
        }
        catch (Throwable t) {
            if (!((Boolean)this.whenError.invoke((Object)t)).booleanValue()) {
                throw t;
            }
            this.logger.info("Flipping to fallback model. Error: {}; options: {}", (Object)t.getMessage(), (Object)prompt.getOptions());
            ChatResponse chatResponse2 = this.fallback.call(prompt);
            Intrinsics.checkNotNull((Object)chatResponse2);
            chatResponse = chatResponse2;
        }
        return chatResponse;
    }
}

