/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.a2a.server.support;

import com.embabel.agent.a2a.server.A2ARequestEvent;
import com.embabel.agent.a2a.server.A2ARequestHandler;
import com.embabel.agent.a2a.server.A2AResponseEvent;
import com.embabel.agent.a2a.server.support.A2AStreamingHandler;
import com.embabel.agent.a2a.server.support.AutonomyA2ARequestHandlerKt;
import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.event.AgentPlatformEvent;
import com.embabel.agent.event.AgenticEventListener;
import io.a2a.spec.Artifact;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.CancelTaskResponse;
import io.a2a.spec.DataPart;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.GetTaskResponse;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCErrorResponse;
import io.a2a.spec.JSONRPCRequest;
import io.a2a.spec.JSONRPCResponse;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendMessageResponse;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.StreamingJSONRPCRequest;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
@Profile(value={"a2a"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u001c\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u001eH\u0012J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0012J\u001c\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010&\u001a\u00060'j\u0002`(H\u0012J\u001a\u0010)\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010*\u001a\u00020+H\u0012J\u001a\u0010,\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010*\u001a\u00020+H\u0012J\u0012\u0010-\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010+H\u0012J\u0012\u0010/\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u00010+H\u0012J\"\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0010\b\u0002\u00105\u001a\n\u0012\u0004\u0012\u00020+\u0018\u000106H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u00067"}, d2={"Lcom/embabel/agent/a2a/server/support/AutonomyA2ARequestHandler;", "Lcom/embabel/agent/a2a/server/A2ARequestHandler;", "autonomy", "Lcom/embabel/agent/api/common/autonomy/Autonomy;", "agenticEventListener", "Lcom/embabel/agent/event/AgenticEventListener;", "streamingHandler", "Lcom/embabel/agent/a2a/server/support/A2AStreamingHandler;", "<init>", "(Lcom/embabel/agent/api/common/autonomy/Autonomy;Lcom/embabel/agent/event/AgenticEventListener;Lcom/embabel/agent/a2a/server/support/A2AStreamingHandler;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "handleJsonRpcStream", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "request", "Lio/a2a/spec/StreamingJSONRPCRequest;", "handleJsonRpc", "Lio/a2a/spec/JSONRPCResponse;", "Lio/a2a/spec/NonStreamingJSONRPCRequest;", "handleMessageSend", "Lio/a2a/spec/SendMessageRequest;", "params", "Lio/a2a/spec/MessageSendParams;", "handleMessageStream", "Lio/a2a/spec/SendStreamingMessageRequest;", "handleTasksGet", "Lio/a2a/spec/GetTaskResponse;", "Lio/a2a/spec/GetTaskRequest;", "Lio/a2a/spec/TaskQueryParams;", "handleCancelTask", "Lio/a2a/spec/CancelTaskResponse;", "Lio/a2a/spec/CancelTaskRequest;", "tip", "Lio/a2a/spec/TaskIdParams;", "createFailedTaskStatus", "Lio/a2a/spec/TaskStatus;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createCompletedTaskStatus", "textPart", "", "createWorkingTaskStatus", "ensureContextId", "providedContextId", "ensureTaskId", "providedTaskId", "createResultArtifact", "Lio/a2a/spec/Artifact;", "result", "Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "acceptedOutputModes", "", "embabel-agent-a2a"})
@SourceDebugExtension(value={"SMAP\nAutonomyA2ARequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutonomyA2ARequestHandler.kt\ncom/embabel/agent/a2a/server/support/AutonomyA2ARequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n808#2,11:322\n808#2,11:333\n*S KotlinDebug\n*F\n+ 1 AutonomyA2ARequestHandler.kt\ncom/embabel/agent/a2a/server/support/AutonomyA2ARequestHandler\n*L\n123#1:322,11\n181#1:333,11\n*E\n"})
public class AutonomyA2ARequestHandler
implements A2ARequestHandler {
    @NotNull
    private final Autonomy autonomy;
    @NotNull
    private final AgenticEventListener agenticEventListener;
    @NotNull
    private final A2AStreamingHandler streamingHandler;
    private final Logger logger;

    public AutonomyA2ARequestHandler(@NotNull Autonomy autonomy, @NotNull AgenticEventListener agenticEventListener, @NotNull A2AStreamingHandler streamingHandler) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)agenticEventListener, (String)"agenticEventListener");
        Intrinsics.checkNotNullParameter((Object)streamingHandler, (String)"streamingHandler");
        this.autonomy = autonomy;
        this.agenticEventListener = agenticEventListener;
        this.streamingHandler = streamingHandler;
        this.logger = LoggerFactory.getLogger(A2ARequestHandler.class);
    }

    @Override
    @NotNull
    public SseEmitter handleJsonRpcStream(@NotNull StreamingJSONRPCRequest<?> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (!(request instanceof SendStreamingMessageRequest)) {
            throw new UnsupportedOperationException("Method " + request.getMethod() + " is not supported for streaming");
        }
        return this.handleMessageStream((SendStreamingMessageRequest)request);
    }

    @Override
    @NotNull
    public JSONRPCResponse<?> handleJsonRpc(@NotNull NonStreamingJSONRPCRequest<?> request) {
        JSONRPCResponse jSONRPCResponse;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        this.logger.info("Received JSONRPC message {}: {}", (Object)request.getMethod(), (Object)request.getClass().getName());
        this.agenticEventListener.onPlatformEvent((AgentPlatformEvent)new A2ARequestEvent(this.autonomy.getAgentPlatform(), (JSONRPCRequest)request));
        NonStreamingJSONRPCRequest<?> nonStreamingJSONRPCRequest = request;
        if (nonStreamingJSONRPCRequest instanceof SendMessageRequest) {
            MessageSendParams messageSendParams = (MessageSendParams)((SendMessageRequest)request).getParams();
            SendMessageRequest sendMessageRequest = (SendMessageRequest)request;
            Intrinsics.checkNotNull((Object)messageSendParams);
            jSONRPCResponse = this.handleMessageSend(sendMessageRequest, messageSendParams);
        } else if (nonStreamingJSONRPCRequest instanceof GetTaskRequest) {
            TaskQueryParams tqp = (TaskQueryParams)((GetTaskRequest)request).getParams();
            GetTaskRequest getTaskRequest = (GetTaskRequest)request;
            Intrinsics.checkNotNull((Object)tqp);
            jSONRPCResponse = (JSONRPCResponse)this.handleTasksGet(getTaskRequest, tqp);
        } else if (nonStreamingJSONRPCRequest instanceof CancelTaskRequest) {
            TaskIdParams tip = (TaskIdParams)((CancelTaskRequest)request).getParams();
            CancelTaskRequest cancelTaskRequest = (CancelTaskRequest)request;
            Intrinsics.checkNotNull((Object)tip);
            jSONRPCResponse = (JSONRPCResponse)this.handleCancelTask(cancelTaskRequest, tip);
        } else {
            this.logger.warn("Unsupported method: {}", (Object)request.getMethod());
            throw new UnsupportedOperationException("Method " + request.getMethod() + " is not supported");
        }
        JSONRPCResponse result = jSONRPCResponse;
        this.agenticEventListener.onPlatformEvent((AgentPlatformEvent)new A2AResponseEvent(this.autonomy.getAgentPlatform(), result));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private JSONRPCResponse<?> handleMessageSend(SendMessageRequest request, MessageSendParams params) {
        void $this$filterIsInstanceTo$iv$iv;
        List list = params.message().getParts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParts(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextPart)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String intent = ((TextPart)CollectionsKt.single((List)((List)destination$iv$iv))).getText();
        this.logger.info("Handling message send request with intent: '{}'", (Object)intent);
        try {
            Intrinsics.checkNotNull((Object)intent);
            AgentProcessExecution result = this.autonomy.chooseAndRunAgent(intent, new ProcessOptions(null, null, null, null, null, null, false, null, null, 511, null));
            MessageSendConfiguration messageSendConfiguration = params.configuration();
            Task task = new Task.Builder().id(this.ensureTaskId(params.message().getTaskId())).contextId(this.ensureContextId(params.message().getContextId())).status(new TaskStatus(TaskState.COMPLETED)).history(CollectionsKt.listOfNotNull((Object)params.message())).artifacts(CollectionsKt.listOf((Object)this.createResultArtifact(result, messageSendConfiguration != null ? messageSendConfiguration.acceptedOutputModes() : null))).build();
            Intrinsics.checkNotNull((Object)task);
            SendMessageResponse jSONRPCResponse = AutonomyA2ARequestHandlerKt.successResponseWith(request, (EventKind)task);
            this.logger.info("Handled message send request, response={}", (Object)jSONRPCResponse);
            return (JSONRPCResponse)jSONRPCResponse;
        }
        catch (Exception e) {
            this.logger.error("Error handling message send request", (Throwable)e);
            return (JSONRPCResponse)new JSONRPCErrorResponse((Object)this.ensureTaskId(params.message().getTaskId()), (JSONRPCError)new TaskNotFoundError(null, "Internal error: " + e.getMessage(), (Object)ExceptionsKt.stackTraceToString((Throwable)e)));
        }
    }

    @NotNull
    public SseEmitter handleMessageStream(@NotNull SendStreamingMessageRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        MessageSendParams params = (MessageSendParams)request.getParams();
        Object object = request.getId();
        if (object == null || (object = object.toString()) == null) {
            String string = UUID.randomUUID().toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        }
        Object streamId = object;
        SseEmitter emitter = this.streamingHandler.createStream((String)streamId);
        Thread.startVirtualThread(() -> AutonomyA2ARequestHandler.handleMessageStream$lambda$1(this, (String)streamId, params));
        return emitter;
    }

    private GetTaskResponse handleTasksGet(GetTaskRequest request, TaskQueryParams params) {
        throw new NotImplementedError(null, 1, null);
    }

    private CancelTaskResponse handleCancelTask(CancelTaskRequest request, TaskIdParams tip) {
        throw new NotImplementedError(null, 1, null);
    }

    private TaskStatus createFailedTaskStatus(MessageSendParams params, Exception e) {
        return new TaskStatus(TaskState.FAILED, new Message.Builder().messageId(UUID.randomUUID().toString()).role(Message.Role.AGENT).parts(CollectionsKt.listOf((Object)new TextPart("Error: " + e.getMessage()))).contextId(params.message().getContextId()).taskId(params.message().getTaskId()).build(), LocalDateTime.now());
    }

    private TaskStatus createCompletedTaskStatus(MessageSendParams params, String textPart) {
        return new TaskStatus(TaskState.COMPLETED, new Message.Builder().messageId(UUID.randomUUID().toString()).role(Message.Role.AGENT).parts(CollectionsKt.listOf((Object)new TextPart(textPart))).contextId(params.message().getContextId()).taskId(params.message().getTaskId()).build(), LocalDateTime.now());
    }

    static /* synthetic */ TaskStatus createCompletedTaskStatus$default(AutonomyA2ARequestHandler autonomyA2ARequestHandler, MessageSendParams messageSendParams, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createCompletedTaskStatus");
        }
        if ((n & 2) != 0) {
            string = "Task completed successfully";
        }
        return autonomyA2ARequestHandler.createCompletedTaskStatus(messageSendParams, string);
    }

    private TaskStatus createWorkingTaskStatus(MessageSendParams params, String textPart) {
        return new TaskStatus(TaskState.WORKING, new Message.Builder().messageId(UUID.randomUUID().toString()).role(Message.Role.AGENT).parts(CollectionsKt.listOf((Object)new TextPart(textPart))).contextId(params.message().getContextId()).taskId(params.message().getTaskId()).build(), LocalDateTime.now());
    }

    static /* synthetic */ TaskStatus createWorkingTaskStatus$default(AutonomyA2ARequestHandler autonomyA2ARequestHandler, MessageSendParams messageSendParams, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createWorkingTaskStatus");
        }
        if ((n & 2) != 0) {
            string = "Working...";
        }
        return autonomyA2ARequestHandler.createWorkingTaskStatus(messageSendParams, string);
    }

    private String ensureContextId(String providedContextId) {
        Object object = providedContextId;
        if (object == null) {
            object = "ctx_" + UUID.randomUUID();
        }
        return object;
    }

    private String ensureTaskId(String providedTaskId) {
        String string = providedTaskId;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    private Artifact createResultArtifact(AgentProcessExecution result, List<String> acceptedOutputModes) {
        Artifact artifact = new Artifact.Builder().artifactId(UUID.randomUUID().toString()).parts(CollectionsKt.listOf((Object)new DataPart(MapsKt.mapOf((Pair)TuplesKt.to((Object)"output", (Object)result.getOutput()))))).build();
        Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"build(...)");
        return artifact;
    }

    static /* synthetic */ Artifact createResultArtifact$default(AutonomyA2ARequestHandler autonomyA2ARequestHandler, AgentProcessExecution agentProcessExecution, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createResultArtifact");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return autonomyA2ARequestHandler.createResultArtifact(agentProcessExecution, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void handleMessageStream$lambda$1(AutonomyA2ARequestHandler this$0, String $streamId, MessageSendParams $params) {
        try {
            Object object;
            Message userMsg;
            block14: {
                block13: {
                    void $this$filterIsInstanceTo$iv$iv;
                    A2AStreamingHandler a2AStreamingHandler = this$0.streamingHandler;
                    TaskStatusUpdateEvent.Builder builder = new TaskStatusUpdateEvent.Builder().taskId($params.message().getTaskId()).contextId($params.message().getContextId());
                    Intrinsics.checkNotNull((Object)$params);
                    TaskStatusUpdateEvent taskStatusUpdateEvent = builder.status(this$0.createWorkingTaskStatus($params, "Task started...")).build();
                    Intrinsics.checkNotNullExpressionValue((Object)taskStatusUpdateEvent, (String)"build(...)");
                    a2AStreamingHandler.sendStreamEvent($streamId, (StreamingEventKind)taskStatusUpdateEvent);
                    Message message = $params.message();
                    if (message != null) {
                        userMsg = message;
                        boolean bl = false;
                        this$0.streamingHandler.sendStreamEvent($streamId, (StreamingEventKind)userMsg);
                    }
                    if ((object = $params.message()) == null || (object = object.getParts()) == null) break block13;
                    Iterable $this$filterIsInstance$iv = (Iterable)object;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof TextPart)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = (TextPart)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    if (object != null && (object = object.getText()) != null) break block14;
                }
                object = "Task " + $params.message().getTaskId();
            }
            Object intent = object;
            AgentProcessExecution result = this$0.autonomy.chooseAndRunAgent((String)intent, new ProcessOptions(null, null, null, null, null, null, false, null, null, 511, null));
            this$0.logger.debug("Task execution result: {}", (Object)result);
            A2AStreamingHandler a2AStreamingHandler = this$0.streamingHandler;
            userMsg = new TaskStatusUpdateEvent.Builder().taskId($params.message().getTaskId()).contextId(this$0.ensureContextId($params.message().getContextId())).status(this$0.createWorkingTaskStatus($params, "Processing task...")).build();
            Intrinsics.checkNotNullExpressionValue((Object)userMsg, (String)"build(...)");
            a2AStreamingHandler.sendStreamEvent($streamId, (StreamingEventKind)userMsg);
            MessageSendConfiguration messageSendConfiguration = $params.configuration();
            Task taskResult = new Task.Builder().id($params.message().getTaskId()).contextId("ctx_" + UUID.randomUUID()).status(AutonomyA2ARequestHandler.createCompletedTaskStatus$default(this$0, $params, null, 2, null)).history(CollectionsKt.listOfNotNull((Object)$params.message())).artifacts(CollectionsKt.listOf((Object)this$0.createResultArtifact(result, messageSendConfiguration != null ? messageSendConfiguration.acceptedOutputModes() : null))).metadata(null).build();
            A2AStreamingHandler a2AStreamingHandler2 = this$0.streamingHandler;
            Intrinsics.checkNotNull((Object)taskResult);
            a2AStreamingHandler2.sendStreamEvent($streamId, (StreamingEventKind)taskResult);
        }
        catch (Exception e) {
            this$0.logger.error("Streaming error", (Throwable)e);
            try {
                A2AStreamingHandler a2AStreamingHandler = this$0.streamingHandler;
                TaskStatusUpdateEvent.Builder builder = new TaskStatusUpdateEvent.Builder().taskId($params.message().getTaskId()).contextId(this$0.ensureContextId($params.message().getContextId()));
                Intrinsics.checkNotNull((Object)$params);
                TaskStatusUpdateEvent result = builder.status(this$0.createFailedTaskStatus($params, e)).build();
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"build(...)");
                a2AStreamingHandler.sendStreamEvent($streamId, (StreamingEventKind)result);
            }
            catch (Exception sendError) {
                this$0.logger.error("Error sending error event", (Throwable)sendError);
            }
        }
        finally {
            this$0.streamingHandler.closeStream($streamId);
        }
    }
}

