/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper.example;

import com.emailage.javawrapper.EmailageClient;
import com.emailage.javawrapper.model.ConfigurationParameters;
import com.emailage.javawrapper.model.Enums;
import com.emailage.javawrapper.model.ExtraInputParameter;
import com.emailage.javawrapper.model.response.EmailageResponse;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;

public class TestClient {
    public static void main(String[] args) {
        String result;
        EmailageResponse validResult;
        Enums.Format resultFormat = Enums.Format.Json;
        Enums.SignatureMethod signatureMethod = Enums.SignatureMethod.HMAC_SHA256;
        Enums.AuthenticationType authType = Enums.AuthenticationType.OAUTH1;
        String user_email = null;
        Enums.Environment environment = Enums.Environment.Production;
        String accountSid = "replace-me";
        String authToken = "replace-me";
        ConfigurationParameters parameters = new ConfigurationParameters();
        parameters.setUserEmail(user_email);
        parameters.setAcccountToken(authToken);
        parameters.setAccountSecret(accountSid);
        parameters.setEnvironment(environment);
        parameters.setHashAlgorithm(signatureMethod);
        parameters.setResultFormat(resultFormat);
        parameters.setAuthenticationType(authType);
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new BlackbirdModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        try {
            System.out.println("Querying Email");
            validResult = EmailageClient.QueryEmail("test@test.com", parameters);
            result = mapper.writeValueAsString((Object)validResult);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Querying Email + IP");
            validResult = EmailageClient.QueryEmailAndIP("test@test.com", "147.12.12.13", parameters);
            result = mapper.writeValueAsString((Object)validResult);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Querying Email + IP + Extra Arguments");
            ExtraInputParameter extraArgs = new ExtraInputParameter();
            extraArgs.setBillAddress("123 Any St.");
            extraArgs.setBillPostal("85225");
            extraArgs.setBillCity("Chandler");
            extraArgs.setBillRegion("AZ");
            extraArgs.setBillCountry("us");
            extraArgs.setPhone("4805551212");
            extraArgs.setTransAmount(1234.56);
            extraArgs.setTransCurrency("USD");
            extraArgs.setExistingCustomer(false);
            extraArgs.setFirstName("Bob");
            extraArgs.setLastName("Smith");
            extraArgs.setPhoneCountryCode("US");
            extraArgs.setCcBinNumber(123456);
            EmailageResponse validResult2 = EmailageClient.QueryEmailAndIPPlusExtraArgs("test@test.com", "147.12.12.13", extraArgs, parameters);
            String result2 = mapper.writeValueAsString((Object)validResult2);
            System.out.println(result2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Marking an Email as Fraud");
            validResult = EmailageClient.MarkEmailAsFraud("test@test.com", Enums.FraudType.Fraud, Enums.FraudCode.CARD_NOT_PRESENT, parameters);
            result = mapper.writeValueAsString((Object)validResult);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

