/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper.model;

public class Enums {

    public static enum FraudCode {
        CARD_NOT_PRESENT("Card Not Present", 1),
        CUSTOMER_DISPUTE("Customer Dispute (Chargeback)", 2),
        FIRST_PARTY_FRAUD("First Party Fraud", 3),
        FIRST_PAYMENT_DEFAULT("First Payment Default", 4),
        IDENTITY_THEFT_APPLICATION("Identity Theft (Fraud Application)", 5),
        IDENTITY_THEFT_ACCOUNT_TAKE_OVER("Identity Theft (Account Take Over)", 6),
        SUSPECTED_FRAUD("Suspected Fraud (Not Confirmed)", 7),
        SYNTHETIC_ID("Synthetic ID", 8),
        OTHER("Other", 9);

        private final String name;
        private final int value;

        private FraudCode(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }

        public int toInt() {
            return this.value;
        }
    }

    public static enum SignatureMethod {
        HMAC_SHA1,
        HMAC_SHA256,
        HMAC_SHA384,
        HMAC_SHA512;


        public String toString() {
            if (HMAC_SHA1 == this) {
                return "HMAC-SHA1";
            }
            if (HMAC_SHA256 == this) {
                return "HMAC-SHA256";
            }
            if (HMAC_SHA384 == this) {
                return "HMAC-SHA384";
            }
            return "HMAC-SHA512";
        }
    }

    public static enum FraudType {
        Good,
        Fraud,
        Neutral;


        public String toString() {
            if (this == Good) {
                return "good";
            }
            if (this == Fraud) {
                return "fraud";
            }
            return "neutral";
        }
    }

    public static enum Format {
        Json,
        Xml;


        public String toString() {
            if (this == Json) {
                return "json";
            }
            return "xml";
        }
    }

    public static enum Environment {
        Sandbox,
        Production;

    }
}

