/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie;

import gigahorse.shaded.apache.org.apache.hc.client5.http.cookie.Cookie;
import gigahorse.shaded.apache.org.apache.hc.client5.http.cookie.CookieOrigin;
import gigahorse.shaded.apache.org.apache.hc.client5.http.cookie.CookieSpec;
import gigahorse.shaded.apache.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import gigahorse.shaded.apache.org.apache.hc.client5.http.cookie.MalformedCookieException;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.BasicDomainHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.BasicExpiresHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.BasicHttpOnlyHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.BasicMaxAgeHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.BasicPathHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.BasicSecureHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.LaxExpiresHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.LaxMaxAgeHandler;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.PublicSuffixDomainFilter;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.RFC6265LaxSpec;
import gigahorse.shaded.apache.org.apache.hc.client5.http.impl.cookie.RFC6265StrictSpec;
import gigahorse.shaded.apache.org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import gigahorse.shaded.apache.org.apache.hc.client5.http.utils.DateUtils;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.http.protocol.HttpContext;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE)
public class RFC6265CookieSpecFactory
implements CookieSpecFactory {
    private final ReentrantLock lock;
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecFactory(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
        this.lock = new ReentrantLock();
    }

    public RFC6265CookieSpecFactory(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecFactory() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec != null) return this.cookieSpec;
        this.lock.lock();
        try {
            if (this.cookieSpec != null) return this.cookieSpec;
            switch (this.compatibilityLevel) {
                case STRICT: {
                    this.cookieSpec = new RFC6265StrictSpec(BasicPathHandler.INSTANCE, PublicSuffixDomainFilter.decorate(BasicDomainHandler.INSTANCE, this.publicSuffixMatcher), BasicMaxAgeHandler.INSTANCE, BasicSecureHandler.INSTANCE, BasicHttpOnlyHandler.INSTANCE, new BasicExpiresHandler(DateUtils.STANDARD_PATTERNS));
                    return this.cookieSpec;
                }
                case IE_MEDIUM_SECURITY: {
                    this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                        @Override
                        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                        }
                    }, PublicSuffixDomainFilter.decorate(BasicDomainHandler.INSTANCE, this.publicSuffixMatcher), BasicMaxAgeHandler.INSTANCE, BasicSecureHandler.INSTANCE, BasicHttpOnlyHandler.INSTANCE, new BasicExpiresHandler(DateUtils.STANDARD_PATTERNS));
                    return this.cookieSpec;
                }
                default: {
                    this.cookieSpec = new RFC6265LaxSpec(BasicPathHandler.INSTANCE, PublicSuffixDomainFilter.decorate(BasicDomainHandler.INSTANCE, this.publicSuffixMatcher), LaxMaxAgeHandler.INSTANCE, BasicSecureHandler.INSTANCE, LaxExpiresHandler.INSTANCE);
                    return this.cookieSpec;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

