/*
 * Decompiled with CFR 0.152.
 */
package com.edmodo.cropper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.edmodo.cropper.R;
import com.edmodo.cropper.cropwindow.CropOverlayView;
import com.edmodo.cropper.cropwindow.edge.Edge;
import com.edmodo.cropper.util.ImageViewUtil;

public class CropImageView
extends FrameLayout {
    private static final Rect EMPTY_RECT = new Rect();
    public static final int DEFAULT_GUIDELINES = 1;
    public static final boolean DEFAULT_FIXED_ASPECT_RATIO = false;
    public static final int DEFAULT_ASPECT_RATIO_X = 1;
    public static final int DEFAULT_ASPECT_RATIO_Y = 1;
    private static final int DEFAULT_IMAGE_RESOURCE = 0;
    private static final String DEGREES_ROTATED = "DEGREES_ROTATED";
    private ImageView mImageView;
    private CropOverlayView mCropOverlayView;
    private Bitmap mBitmap;
    private int mDegreesRotated = 0;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mGuidelines = 1;
    private boolean mFixAspectRatio = false;
    private int mAspectRatioX = 1;
    private int mAspectRatioY = 1;
    private int mImageResource = 0;

    public CropImageView(Context context) {
        super(context);
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
        try {
            this.mGuidelines = ta.getInteger(0, 1);
            this.mFixAspectRatio = ta.getBoolean(1, false);
            this.mAspectRatioX = ta.getInteger(2, 1);
            this.mAspectRatioY = ta.getInteger(3, 1);
            this.mImageResource = ta.getResourceId(4, 0);
        }
        finally {
            ta.recycle();
        }
        this.init(context);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt(DEGREES_ROTATED, this.mDegreesRotated);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            if (this.mBitmap != null) {
                int tempDegrees = this.mDegreesRotated = bundle.getInt(DEGREES_ROTATED);
                this.rotateImage(this.mDegreesRotated);
                this.mDegreesRotated = tempDegrees;
            }
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mBitmap != null) {
            Rect bitmapRect = ImageViewUtil.getBitmapRectCenterInside(this.mBitmap, (View)this);
            this.mCropOverlayView.setBitmapRect(bitmapRect);
        } else {
            this.mCropOverlayView.setBitmapRect(EMPTY_RECT);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBitmap != null) {
            int desiredHeight;
            int desiredWidth;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (heightSize == 0) {
                heightSize = this.mBitmap.getHeight();
            }
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < this.mBitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)this.mBitmap.getWidth();
            }
            if (heightSize < this.mBitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)this.mBitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)this.mBitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)this.mBitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = this.mBitmap.getWidth();
                desiredHeight = this.mBitmap.getHeight();
            }
            int width = CropImageView.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            Rect bitmapRect = ImageViewUtil.getBitmapRectCenterInside(this.mBitmap.getWidth(), this.mBitmap.getHeight(), this.mLayoutWidth, this.mLayoutHeight);
            this.mCropOverlayView.setBitmapRect(bitmapRect);
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.mCropOverlayView.setBitmapRect(EMPTY_RECT);
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origparams = this.getLayoutParams();
            origparams.width = this.mLayoutWidth;
            origparams.height = this.mLayoutHeight;
            this.setLayoutParams(origparams);
        }
    }

    public int getImageResource() {
        return this.mImageResource;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mImageView.setImageBitmap(this.mBitmap);
        if (this.mCropOverlayView != null) {
            this.mCropOverlayView.resetCropOverlayView();
        }
    }

    public void setImageBitmap(Bitmap bitmap, ExifInterface exif) {
        if (bitmap == null) {
            return;
        }
        if (exif == null) {
            this.setImageBitmap(bitmap);
            return;
        }
        Matrix matrix = new Matrix();
        int orientation = exif.getAttributeInt("Orientation", 1);
        int rotate = -1;
        switch (orientation) {
            case 8: {
                rotate = 270;
                break;
            }
            case 3: {
                rotate = 180;
                break;
            }
            case 6: {
                rotate = 90;
            }
        }
        if (rotate == -1) {
            this.setImageBitmap(bitmap);
        } else {
            matrix.postRotate((float)rotate);
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            this.setImageBitmap(rotatedBitmap);
            bitmap.recycle();
        }
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setImageBitmap(bitmap);
        }
    }

    public Bitmap getCroppedImage() {
        Rect displayedImageRect = ImageViewUtil.getBitmapRectCenterInside(this.mBitmap, (View)this.mImageView);
        float actualImageWidth = this.mBitmap.getWidth();
        float displayedImageWidth = displayedImageRect.width();
        float scaleFactorWidth = actualImageWidth / displayedImageWidth;
        float actualImageHeight = this.mBitmap.getHeight();
        float displayedImageHeight = displayedImageRect.height();
        float scaleFactorHeight = actualImageHeight / displayedImageHeight;
        float cropWindowX = Edge.LEFT.getCoordinate() - (float)displayedImageRect.left;
        float cropWindowY = Edge.TOP.getCoordinate() - (float)displayedImageRect.top;
        float cropWindowWidth = Edge.getWidth();
        float cropWindowHeight = Edge.getHeight();
        float actualCropX = cropWindowX * scaleFactorWidth;
        float actualCropY = cropWindowY * scaleFactorHeight;
        float actualCropWidth = cropWindowWidth * scaleFactorWidth;
        float actualCropHeight = cropWindowHeight * scaleFactorHeight;
        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)((int)actualCropX), (int)((int)actualCropY), (int)((int)actualCropWidth), (int)((int)actualCropHeight));
        return croppedBitmap;
    }

    public RectF getActualCropRect() {
        Rect displayedImageRect = ImageViewUtil.getBitmapRectCenterInside(this.mBitmap, (View)this.mImageView);
        float actualImageWidth = this.mBitmap.getWidth();
        float displayedImageWidth = displayedImageRect.width();
        float scaleFactorWidth = actualImageWidth / displayedImageWidth;
        float actualImageHeight = this.mBitmap.getHeight();
        float displayedImageHeight = displayedImageRect.height();
        float scaleFactorHeight = actualImageHeight / displayedImageHeight;
        float displayedCropLeft = Edge.LEFT.getCoordinate() - (float)displayedImageRect.left;
        float displayedCropTop = Edge.TOP.getCoordinate() - (float)displayedImageRect.top;
        float displayedCropWidth = Edge.getWidth();
        float displayedCropHeight = Edge.getHeight();
        float actualCropLeft = displayedCropLeft * scaleFactorWidth;
        float actualCropTop = displayedCropTop * scaleFactorHeight;
        float actualCropRight = actualCropLeft + displayedCropWidth * scaleFactorWidth;
        float actualCropBottom = actualCropTop + displayedCropHeight * scaleFactorHeight;
        actualCropLeft = Math.max(0.0f, actualCropLeft);
        actualCropTop = Math.max(0.0f, actualCropTop);
        actualCropRight = Math.min((float)this.mBitmap.getWidth(), actualCropRight);
        actualCropBottom = Math.min((float)this.mBitmap.getHeight(), actualCropBottom);
        RectF actualCropRect = new RectF(actualCropLeft, actualCropTop, actualCropRight, actualCropBottom);
        return actualCropRect;
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mCropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public void setGuidelines(int guidelines) {
        this.mCropOverlayView.setGuidelines(guidelines);
    }

    public void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mAspectRatioX = aspectRatioX;
        this.mCropOverlayView.setAspectRatioX(this.mAspectRatioX);
        this.mAspectRatioY = aspectRatioY;
        this.mCropOverlayView.setAspectRatioY(this.mAspectRatioY);
    }

    public void rotateImage(int degrees) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degrees);
        this.mBitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        this.setImageBitmap(this.mBitmap);
        this.mDegreesRotated += degrees;
        this.mDegreesRotated %= 360;
    }

    private void init(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        this.mImageView = (ImageView)v.findViewById(R.id.ImageView_image);
        this.setImageResource(this.mImageResource);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setInitialAttributeValues(this.mGuidelines, this.mFixAspectRatio, this.mAspectRatioX, this.mAspectRatioY);
    }

    private static int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
        int spec = measureSpecMode == 0x40000000 ? measureSpecSize : (measureSpecMode == Integer.MIN_VALUE ? Math.min(desiredSize, measureSpecSize) : desiredSize);
        return spec;
    }
}

