/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.transport;

import com.ecwid.consul.transport.HttpTransport;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.transport.TransportException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class AbstractHttpTransport
implements HttpTransport {
    protected final HttpClient httpClient;

    public AbstractHttpTransport() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(1000);
        connectionManager.setDefaultMaxPerRoute(500);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
    }

    public AbstractHttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public RawResponse makeGetRequest(String url) {
        HttpGet httpGet = new HttpGet(url);
        return this.executeRequest((HttpUriRequest)httpGet);
    }

    @Override
    public RawResponse makePutRequest(String url, String content) {
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity((HttpEntity)new StringEntity(content, Charset.forName("UTF-8")));
        return this.executeRequest((HttpUriRequest)httpPut);
    }

    @Override
    public RawResponse makePutRequest(String url, byte[] content) {
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity((HttpEntity)new ByteArrayEntity(content));
        return this.executeRequest((HttpUriRequest)httpPut);
    }

    @Override
    public RawResponse makeDeleteRequest(String url) {
        HttpDelete httpDelete = new HttpDelete(url);
        return this.executeRequest((HttpUriRequest)httpDelete);
    }

    private RawResponse executeRequest(HttpUriRequest httpRequest) {
        try {
            return (RawResponse)this.httpClient.execute(httpRequest, (ResponseHandler)new ResponseHandler<RawResponse>(){

                public RawResponse handleResponse(HttpResponse response) throws IOException {
                    int statusCode = response.getStatusLine().getStatusCode();
                    String statusMessage = response.getStatusLine().getReasonPhrase();
                    String content = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                    Long consulIndex = AbstractHttpTransport.this.parseLong(response.getFirstHeader("X-Consul-Index"));
                    Boolean consulKnownLeader = AbstractHttpTransport.this.parseBoolean(response.getFirstHeader("X-Consul-Knownleader"));
                    Long consulLastContact = AbstractHttpTransport.this.parseLong(response.getFirstHeader("X-Consul-Lastcontact"));
                    return new RawResponse(statusCode, statusMessage, content, consulIndex, consulKnownLeader, consulLastContact);
                }
            });
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private Long parseLong(Header header) {
        try {
            return Long.parseLong(header.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    private Boolean parseBoolean(Header header) {
        if (header == null) {
            return null;
        }
        if ("true".equals(header.getValue())) {
            return true;
        }
        if ("false".equals(header.getValue())) {
            return false;
        }
        return null;
    }
}

