/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1;

import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.Utils;
import com.ecwid.consul.transport.DefaultHttpTransport;
import com.ecwid.consul.transport.HttpTransport;
import com.ecwid.consul.transport.RawResponse;
import org.apache.http.client.HttpClient;

public class ConsulRawClient {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8500;
    private static final HttpTransport DEFAULT_HTTP_TRANSPORT = new DefaultHttpTransport();
    private final HttpTransport httpTransport;
    private final String agentAddress;

    public ConsulRawClient() {
        this(DEFAULT_HOST);
    }

    public ConsulRawClient(String agentHost) {
        this(agentHost, 8500);
    }

    public ConsulRawClient(String agentHost, int agentPort) {
        this(DEFAULT_HTTP_TRANSPORT, agentHost, agentPort);
    }

    public ConsulRawClient(HttpClient httpClient) {
        this(DEFAULT_HOST, httpClient);
    }

    public ConsulRawClient(String agentHost, HttpClient httpClient) {
        this(new DefaultHttpTransport(httpClient), agentHost, 8500);
    }

    public ConsulRawClient(String agentHost, int agentPort, HttpClient httpClient) {
        this(new DefaultHttpTransport(httpClient), agentHost, agentPort);
    }

    ConsulRawClient(HttpTransport httpTransport, String agentHost, int agentPort) {
        this.httpTransport = httpTransport;
        String agentHostLowercase = agentHost.toLowerCase();
        if (!agentHostLowercase.startsWith("https://") && !agentHostLowercase.startsWith("http://")) {
            agentHost = "http://" + agentHost;
        }
        this.agentAddress = agentHost + ":" + agentPort;
    }

    public RawResponse makeGetRequest(String endpoint, UrlParameters ... urlParams) {
        String url = this.agentAddress + endpoint;
        url = Utils.generateUrl(url, urlParams);
        return this.httpTransport.makeGetRequest(url);
    }

    public RawResponse makePutRequest(String endpoint, String content, UrlParameters ... urlParams) {
        String url = this.agentAddress + endpoint;
        url = Utils.generateUrl(url, urlParams);
        return this.httpTransport.makePutRequest(url, content);
    }

    public RawResponse makePutRequest(String endpoint, byte[] content, UrlParameters ... urlParams) {
        String url = this.agentAddress + endpoint;
        url = Utils.generateUrl(url, urlParams);
        return this.httpTransport.makePutRequest(url, content);
    }

    public RawResponse makeDeleteRequest(String endpoint, UrlParameters ... urlParams) {
        String url = this.agentAddress + endpoint;
        url = Utils.generateUrl(url, urlParams);
        return this.httpTransport.makeDeleteRequest(url);
    }
}

