/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import com.eatthepath.pushy.apns.server.ServerChannelClassUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseHttp2Server {
    private final SslContext sslContext;
    private final AtomicBoolean hasReleasedSslContext = new AtomicBoolean(false);
    private final ServerBootstrap bootstrap;
    private final boolean shouldShutDownEventLoopGroup;
    private final ChannelGroup allChannels;
    private static final Logger log = LoggerFactory.getLogger(BaseHttp2Server.class);

    BaseHttp2Server(final SslContext sslContext, EventLoopGroup eventLoopGroup) {
        this.sslContext = sslContext;
        if (this.sslContext instanceof ReferenceCounted) {
            ((ReferenceCounted)this.sslContext).retain();
        }
        this.bootstrap = new ServerBootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.allChannels = new DefaultChannelGroup((EventExecutor)this.bootstrap.config().group().next());
        this.bootstrap.channel(ServerChannelClassUtil.getServerSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                SslHandler sslHandler = sslContext.newHandler(channel.alloc());
                channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                channel.pipeline().addLast(new ChannelHandler[]{ConnectionNegotiationErrorHandler.INSTANCE});
                sslHandler.handshakeFuture().addListener(handshakeFuture -> {
                    if (handshakeFuture.isSuccess()) {
                        BaseHttp2Server.this.addHandlersToPipeline(sslHandler.engine().getSession(), channel.pipeline());
                        channel.pipeline().remove((ChannelHandler)ConnectionNegotiationErrorHandler.INSTANCE);
                        BaseHttp2Server.this.allChannels.add((Object)channel);
                    } else {
                        log.debug("TLS handshake failed.", handshakeFuture.cause());
                    }
                });
            }
        });
    }

    protected abstract void addHandlersToPipeline(SSLSession var1, ChannelPipeline var2) throws Exception;

    public CompletableFuture<Integer> start(int port) {
        ChannelFuture channelFuture = this.bootstrap.bind(port);
        this.allChannels.add((Object)channelFuture.channel());
        CompletableFuture<Integer> startFuture = new CompletableFuture<Integer>();
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                startFuture.complete(((InetSocketAddress)channelFuture.channel().localAddress()).getPort());
            } else {
                startFuture.completeExceptionally(future.cause());
            }
        });
        return startFuture;
    }

    public CompletableFuture<Void> shutdown() {
        CompletableFuture shutdownFuture = new CompletableFuture();
        ChannelGroupFuture channelCloseFuture = this.allChannels.close();
        if (this.shouldShutDownEventLoopGroup) {
            channelCloseFuture.addListener(future -> this.bootstrap.config().group().shutdownGracefully());
            this.bootstrap.config().group().terminationFuture().addListener(future -> {
                if (future.isSuccess()) {
                    shutdownFuture.complete(null);
                } else {
                    shutdownFuture.completeExceptionally(future.cause());
                }
            });
        } else {
            channelCloseFuture.addListener(future -> {
                if (future.isSuccess()) {
                    shutdownFuture.complete(null);
                } else {
                    shutdownFuture.completeExceptionally(future.cause());
                }
            });
        }
        return shutdownFuture.thenRun(() -> {
            if (this.sslContext instanceof ReferenceCounted && this.hasReleasedSslContext.compareAndSet(false, true)) {
                ((ReferenceCounted)this.sslContext).release();
            }
        });
    }

    @ChannelHandler.Sharable
    private static class ConnectionNegotiationErrorHandler
    extends ChannelInboundHandlerAdapter {
        static final ConnectionNegotiationErrorHandler INSTANCE = new ConnectionNegotiationErrorHandler();

        private ConnectionNegotiationErrorHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            log.debug("Server caught an exception before establishing an HTTP/2 connection.", cause);
        }
    }
}

