/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.auth;

import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.auth.AuthenticationToken;
import java.io.Closeable;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationTokenProvider
implements Closeable {
    private final ApnsSigningKey signingKey;
    private final Clock clock;
    private final AtomicReference<AuthenticationToken> token;
    private final ScheduledFuture<?> refreshTokenFuture;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationTokenProvider.class);

    public AuthenticationTokenProvider(ApnsSigningKey signingKey, Duration maxTokenAge, ScheduledExecutorService scheduledExecutorService) {
        this(signingKey, maxTokenAge, scheduledExecutorService, Clock.systemUTC());
    }

    AuthenticationTokenProvider(ApnsSigningKey signingKey, Duration maxTokenAge, ScheduledExecutorService scheduledExecutorService, Clock clock) {
        this.signingKey = signingKey;
        this.clock = clock;
        this.token = new AtomicReference<AuthenticationToken>(new AuthenticationToken(signingKey, clock.instant()));
        this.refreshTokenFuture = scheduledExecutorService.scheduleAtFixedRate(this::refreshToken, maxTokenAge.toMillis(), maxTokenAge.toMillis(), TimeUnit.MILLISECONDS);
    }

    void refreshToken() {
        log.debug("Refreshed authentication token");
        this.token.set(new AuthenticationToken(this.signingKey, this.clock.instant()));
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.token.get();
    }

    public void expireAuthenticationToken(AuthenticationToken expiredToken) {
        this.token.compareAndSet(expiredToken, new AuthenticationToken(this.signingKey, this.clock.instant()));
    }

    @Override
    public void close() {
        this.refreshTokenFuture.cancel(false);
    }
}

