/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsClientHandler;
import com.eatthepath.pushy.apns.AugmentingReflectiveChannelFactory;
import com.eatthepath.pushy.apns.ClientChannelClassUtil;
import com.eatthepath.pushy.apns.PooledObjectFactory;
import com.eatthepath.pushy.apns.TokenAuthenticationApnsClientHandler;
import com.eatthepath.pushy.apns.auth.AuthenticationTokenProvider;
import com.eatthepath.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

class ApnsChannelFactory
implements PooledObjectFactory<Channel>,
Closeable {
    private final SslContext sslContext;
    private final AtomicBoolean hasReleasedSslContext = new AtomicBoolean(false);
    private final AddressResolverGroup<? extends SocketAddress> addressResolverGroup;
    private final Bootstrap bootstrapTemplate;
    private final AtomicLong currentDelaySeconds = new AtomicLong(0L);
    private static final long MIN_CONNECT_DELAY_SECONDS = 1L;
    private static final long MAX_CONNECT_DELAY_SECONDS = 60L;
    static final AttributeKey<Promise<Channel>> CHANNEL_READY_PROMISE_ATTRIBUTE_KEY = AttributeKey.valueOf(ApnsChannelFactory.class, (String)"channelReadyPromise");

    ApnsChannelFactory(final SslContext sslContext, final boolean hostnameVerificationEnabled, final AuthenticationTokenProvider authenticationTokenProvider, final ProxyHandlerFactory proxyHandlerFactory, Duration connectTimeout, final Duration idlePingInterval, final Duration gracefulShutdownTimeout, final Http2FrameLogger frameLogger, final InetSocketAddress apnsServerAddress, EventLoopGroup eventLoopGroup) {
        this.sslContext = sslContext;
        if (this.sslContext instanceof ReferenceCounted) {
            ((ReferenceCounted)this.sslContext).retain();
        }
        this.addressResolverGroup = proxyHandlerFactory == null ? new RoundRobinDnsAddressResolverGroup(ClientChannelClassUtil.getDatagramChannelClass(eventLoopGroup), (DnsServerAddressStreamProvider)DefaultDnsServerAddressStreamProvider.INSTANCE) : NoopAddressResolverGroup.INSTANCE;
        this.bootstrapTemplate = new Bootstrap();
        this.bootstrapTemplate.group(eventLoopGroup);
        this.bootstrapTemplate.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrapTemplate.remoteAddress((SocketAddress)apnsServerAddress);
        this.bootstrapTemplate.resolver(this.addressResolverGroup);
        if (connectTimeout != null) {
            this.bootstrapTemplate.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeout.toMillis()));
        }
        this.bootstrapTemplate.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                String authority = apnsServerAddress.getHostName();
                SslHandler sslHandler = sslContext.newHandler(channel.alloc(), authority, apnsServerAddress.getPort());
                if (hostnameVerificationEnabled) {
                    SSLEngine sslEngine = sslHandler.engine();
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                    sslEngine.setSSLParameters(sslParameters);
                }
                ApnsClientHandler.ApnsClientHandlerBuilder clientHandlerBuilder = authenticationTokenProvider != null ? new TokenAuthenticationApnsClientHandler.TokenAuthenticationApnsClientHandlerBuilder().authenticationTokenProvider(authenticationTokenProvider).authority(authority).idlePingInterval(idlePingInterval) : new ApnsClientHandler.ApnsClientHandlerBuilder().authority(authority).idlePingInterval(idlePingInterval);
                if (frameLogger != null) {
                    clientHandlerBuilder.frameLogger(frameLogger);
                }
                ApnsClientHandler apnsClientHandler = clientHandlerBuilder.build();
                if (gracefulShutdownTimeout != null) {
                    apnsClientHandler.gracefulShutdownTimeoutMillis(gracefulShutdownTimeout.toMillis());
                }
                ChannelPipeline pipeline = channel.pipeline();
                if (proxyHandlerFactory != null) {
                    pipeline.addFirst(new ChannelHandler[]{proxyHandlerFactory.createProxyHandler()});
                }
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true)});
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(idlePingInterval.toMillis(), 0L, 0L, TimeUnit.MILLISECONDS)});
                pipeline.addLast(new ChannelHandler[]{apnsClientHandler});
            }
        });
    }

    @Override
    public Future<Channel> create(Promise<Channel> channelReadyPromise) {
        long delay = this.currentDelaySeconds.get();
        channelReadyPromise.addListener(future -> {
            long updatedDelay = future.isSuccess() ? 0L : Math.max(Math.min(delay * 2L, 60L), 1L);
            this.currentDelaySeconds.compareAndSet(delay, updatedDelay);
        });
        this.bootstrapTemplate.config().group().schedule(() -> {
            Bootstrap bootstrap = (Bootstrap)this.bootstrapTemplate.clone().channelFactory(new AugmentingReflectiveChannelFactory<SocketChannel, Promise>(ClientChannelClassUtil.getSocketChannelClass(this.bootstrapTemplate.config().group()), CHANNEL_READY_PROMISE_ATTRIBUTE_KEY, channelReadyPromise));
            ChannelFuture connectFuture = bootstrap.connect();
            connectFuture.addListener(future -> {
                if (!future.isSuccess()) {
                    channelReadyPromise.tryFailure(future.cause());
                }
            });
        }, delay, TimeUnit.SECONDS);
        return channelReadyPromise;
    }

    @Override
    public Future<Void> destroy(Channel channel, Promise<Void> promise) {
        channel.close().addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{promise}));
        return promise;
    }

    @Override
    public void close() {
        try {
            this.addressResolverGroup.close();
        }
        finally {
            if (this.sslContext instanceof ReferenceCounted && this.hasReleasedSslContext.compareAndSet(false, true)) {
                ((ReferenceCounted)this.sslContext).release();
            }
        }
    }
}

