/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.auth;

import com.eatthepath.json.JsonParser;
import com.eatthepath.json.JsonSerializer;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.auth.ApnsVerificationKey;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.text.ParseException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AuthenticationToken {
    private final AuthenticationTokenHeader header;
    private final AuthenticationTokenClaims claims;
    private final byte[] signatureBytes;
    private final transient String base64EncodedToken;
    private final transient AsciiString authorizationHeader;

    public AuthenticationToken(ApnsSigningKey signingKey, Instant issuedAt) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.header = new AuthenticationTokenHeader(signingKey.getKeyId());
        this.claims = new AuthenticationTokenClaims(signingKey.getTeamId(), issuedAt);
        String headerJson = JsonSerializer.writeJsonTextAsString(this.header.toMap());
        String claimsJson = JsonSerializer.writeJsonTextAsString(this.claims.toMap());
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append(AuthenticationToken.encodeUnpaddedBase64UrlString(headerJson.getBytes(StandardCharsets.US_ASCII)));
        payloadBuilder.append('.');
        payloadBuilder.append(AuthenticationToken.encodeUnpaddedBase64UrlString(claimsJson.getBytes(StandardCharsets.US_ASCII)));
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(signingKey);
        signature.update(payloadBuilder.toString().getBytes(StandardCharsets.US_ASCII));
        this.signatureBytes = signature.sign();
        payloadBuilder.append('.');
        payloadBuilder.append(AuthenticationToken.encodeUnpaddedBase64UrlString(this.signatureBytes));
        this.base64EncodedToken = payloadBuilder.toString();
        this.authorizationHeader = new AsciiString((CharSequence)("bearer " + payloadBuilder.toString()));
    }

    public AuthenticationToken(String base64EncodedToken) {
        Objects.requireNonNull(base64EncodedToken, "Encoded token must not be null.");
        this.base64EncodedToken = base64EncodedToken;
        this.authorizationHeader = new AsciiString((CharSequence)("bearer " + base64EncodedToken));
        String[] jwtSegments = base64EncodedToken.split("\\.");
        if (jwtSegments.length != 3) {
            throw new IllegalArgumentException();
        }
        JsonParser jsonParser = new JsonParser();
        try {
            this.header = AuthenticationTokenHeader.fromMap(jsonParser.parseJsonObject(new String(AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[0]), StandardCharsets.US_ASCII)));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse header as a JSON object: " + new String(AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[0]), StandardCharsets.US_ASCII));
        }
        try {
            this.claims = AuthenticationTokenClaims.fromMap(jsonParser.parseJsonObject(new String(AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[1]), StandardCharsets.US_ASCII)));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse claims as a JSON object: " + new String(AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[1]), StandardCharsets.US_ASCII));
        }
        this.signatureBytes = AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[2]);
    }

    public Instant getIssuedAt() {
        return this.claims.getIssuedAt();
    }

    public String getKeyId() {
        return this.header.getKeyId();
    }

    public String getTeamId() {
        return this.claims.getIssuer();
    }

    public boolean verifySignature(ApnsVerificationKey verificationKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.header.getKeyId().equals(verificationKey.getKeyId())) {
            return false;
        }
        if (!this.claims.getIssuer().equals(verificationKey.getTeamId())) {
            return false;
        }
        String headerJson = JsonSerializer.writeJsonTextAsString(this.header.toMap());
        String claimsJson = JsonSerializer.writeJsonTextAsString(this.claims.toMap());
        String encodedHeaderAndClaims = AuthenticationToken.encodeUnpaddedBase64UrlString(headerJson.getBytes(StandardCharsets.US_ASCII)) + '.' + AuthenticationToken.encodeUnpaddedBase64UrlString(claimsJson.getBytes(StandardCharsets.US_ASCII));
        byte[] headerAndClaimsBytes = encodedHeaderAndClaims.getBytes(StandardCharsets.US_ASCII);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initVerify(verificationKey);
        signature.update(headerAndClaimsBytes);
        return signature.verify(this.signatureBytes);
    }

    public AsciiString getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public String toString() {
        return this.base64EncodedToken;
    }

    public int hashCode() {
        return this.base64EncodedToken.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationToken)) {
            return false;
        }
        AuthenticationToken other = (AuthenticationToken)obj;
        if (this.base64EncodedToken == null) {
            return other.base64EncodedToken == null;
        }
        return this.base64EncodedToken.equals(other.base64EncodedToken);
    }

    static String encodeUnpaddedBase64UrlString(byte[] data) {
        ByteBuf wrappedString = Unpooled.wrappedBuffer((byte[])data);
        ByteBuf encodedString = Base64.encode((ByteBuf)wrappedString, (Base64Dialect)Base64Dialect.URL_SAFE);
        String encodedUnpaddedString = encodedString.toString(StandardCharsets.US_ASCII).replace("=", "");
        wrappedString.release();
        encodedString.release();
        return encodedUnpaddedString;
    }

    static byte[] decodeBase64UrlEncodedString(String base64UrlEncodedString) {
        String paddedBase64UrlEncodedString;
        switch (base64UrlEncodedString.length() % 4) {
            case 2: {
                paddedBase64UrlEncodedString = base64UrlEncodedString + "==";
                break;
            }
            case 3: {
                paddedBase64UrlEncodedString = base64UrlEncodedString + "=";
                break;
            }
            default: {
                paddedBase64UrlEncodedString = base64UrlEncodedString;
            }
        }
        ByteBuf base64EncodedByteBuf = Unpooled.wrappedBuffer((byte[])paddedBase64UrlEncodedString.getBytes(StandardCharsets.US_ASCII));
        ByteBuf decodedByteBuf = Base64.decode((ByteBuf)base64EncodedByteBuf, (Base64Dialect)Base64Dialect.URL_SAFE);
        byte[] decodedBytes = new byte[decodedByteBuf.readableBytes()];
        decodedByteBuf.readBytes(decodedBytes);
        base64EncodedByteBuf.release();
        decodedByteBuf.release();
        return decodedBytes;
    }

    static class AuthenticationTokenHeader {
        private final String keyId;

        AuthenticationTokenHeader(String keyId) {
            this.keyId = keyId;
        }

        static AuthenticationTokenHeader fromMap(Map<String, Object> headerMap) {
            if (!headerMap.containsKey("kid") || !(headerMap.get("kid") instanceof String)) {
                throw new IllegalArgumentException("Header map must map a string value to the \"kid\" key.");
            }
            return new AuthenticationTokenHeader((String)headerMap.get("kid"));
        }

        String getKeyId() {
            return this.keyId;
        }

        Map<String, Object> toMap() {
            HashMap<String, Object> headerMap = new HashMap<String, Object>(3, 1.0f);
            headerMap.put("alg", "ES256");
            headerMap.put("typ", "JWT");
            headerMap.put("kid", this.keyId);
            return headerMap;
        }
    }

    static class AuthenticationTokenClaims {
        private final String issuer;
        private final Instant issuedAt;

        AuthenticationTokenClaims(String teamId, Instant issuedAt) {
            this.issuer = teamId;
            this.issuedAt = issuedAt;
        }

        static AuthenticationTokenClaims fromMap(Map<String, Object> claimsMap) {
            if (!claimsMap.containsKey("iss") || !(claimsMap.get("iss") instanceof String)) {
                throw new IllegalArgumentException("Claims map must map a string value to the \"iss\" key.");
            }
            if (!claimsMap.containsKey("iat") || !(claimsMap.get("iat") instanceof Long)) {
                throw new IllegalArgumentException("Claims map must map a long value to the \"iat\" key.");
            }
            String teamId = (String)claimsMap.get("iss");
            Instant issuedAt = Instant.ofEpochSecond((Long)claimsMap.get("iat"));
            return new AuthenticationTokenClaims(teamId, issuedAt);
        }

        String getIssuer() {
            return this.issuer;
        }

        Instant getIssuedAt() {
            return this.issuedAt;
        }

        Map<String, Object> toMap() {
            HashMap<String, Object> headerMap = new HashMap<String, Object>(2, 1.0f);
            headerMap.put("iss", this.issuer);
            headerMap.put("iat", this.issuedAt.getEpochSecond());
            return headerMap;
        }
    }
}

