/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.uuid.FastUUID;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;

class SimplePushNotificationResponse<T extends ApnsPushNotification>
implements PushNotificationResponse<T> {
    private final T pushNotification;
    private final boolean success;
    private final UUID apnsId;
    private final String rejectionReason;
    private final Instant tokenExpirationTimestamp;

    SimplePushNotificationResponse(T pushNotification, boolean success, UUID apnsId, String rejectionReason, Instant tokenExpirationTimestamp) {
        this.pushNotification = pushNotification;
        this.success = success;
        this.apnsId = apnsId;
        this.rejectionReason = rejectionReason;
        this.tokenExpirationTimestamp = tokenExpirationTimestamp;
    }

    @Override
    public T getPushNotification() {
        return this.pushNotification;
    }

    @Override
    public boolean isAccepted() {
        return this.success;
    }

    @Override
    public UUID getApnsId() {
        return this.apnsId;
    }

    @Override
    public String getRejectionReason() {
        return this.rejectionReason;
    }

    @Override
    public Optional<Instant> getTokenInvalidationTimestamp() {
        return Optional.ofNullable(this.tokenExpirationTimestamp);
    }

    public String toString() {
        return "SimplePushNotificationResponse{pushNotification=" + this.pushNotification + ", success=" + this.success + ", apnsId=" + (this.apnsId != null ? FastUUID.toString((UUID)this.apnsId) : null) + ", rejectionReason='" + this.rejectionReason + '\'' + ", tokenExpirationTimestamp=" + this.tokenExpirationTimestamp + '}';
    }
}

