/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsClientHandler;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.ErrorResponse;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.auth.AuthenticationToken;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.ScheduledFuture;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthenticationApnsClientHandler
extends ApnsClientHandler {
    private final ApnsSigningKey signingKey;
    private AuthenticationToken authenticationToken;
    private int mostRecentStreamWithNewToken = 0;
    private final Duration tokenExpiration;
    private ScheduledFuture<?> expireTokenFuture;
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final String EXPIRED_AUTH_TOKEN_REASON = "ExpiredProviderToken";
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationApnsClientHandler.class);

    protected TokenAuthenticationApnsClientHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String authority, Duration idlePingInterval, ApnsSigningKey signingKey, Duration tokenExpiration) {
        super(decoder, encoder, initialSettings, authority, idlePingInterval);
        Objects.requireNonNull(signingKey, "Signing key must not be null for token-based client handlers.");
        this.signingKey = signingKey;
        this.tokenExpiration = tokenExpiration;
    }

    @Override
    protected Http2Headers getHeadersForPushNotification(ApnsPushNotification pushNotification, ChannelHandlerContext context, int streamId) {
        Http2Headers headers = super.getHeadersForPushNotification(pushNotification, context, streamId);
        if (this.authenticationToken == null) {
            try {
                log.debug("Generating new token for stream {}.", (Object)streamId);
                this.authenticationToken = new AuthenticationToken(this.signingKey, Instant.now());
                this.mostRecentStreamWithNewToken = streamId;
                this.expireTokenFuture = context.executor().schedule(() -> {
                    log.debug("Proactively expiring authentication token.");
                    this.authenticationToken = null;
                }, this.tokenExpiration.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                log.error("Failed to generate authentication token.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        headers.add((Object)APNS_AUTHORIZATION_HEADER, (Object)this.authenticationToken.getAuthorizationHeader());
        return headers;
    }

    @Override
    protected void handleErrorResponse(ChannelHandlerContext context, int streamId, Http2Headers headers, ApnsPushNotification pushNotification, ErrorResponse errorResponse) {
        if (EXPIRED_AUTH_TOKEN_REASON.equals(errorResponse.getReason())) {
            log.warn("APNs server reports token has expired.");
            if (streamId >= this.mostRecentStreamWithNewToken) {
                this.authenticationToken = null;
            }
            this.retryPushNotificationFromStream(context, streamId);
        } else {
            super.handleErrorResponse(context, streamId, headers, pushNotification, errorResponse);
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext context) throws Exception {
        super.handlerRemoved0(context);
        if (this.expireTokenFuture != null) {
            this.expireTokenFuture.cancel(false);
        }
    }

    public static class TokenAuthenticationApnsClientHandlerBuilder
    extends ApnsClientHandler.ApnsClientHandlerBuilder {
        private ApnsSigningKey signingKey;
        private Duration tokenExpiration;

        public TokenAuthenticationApnsClientHandlerBuilder signingKey(ApnsSigningKey signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        public ApnsSigningKey signingKey() {
            return this.signingKey;
        }

        public TokenAuthenticationApnsClientHandlerBuilder tokenExpiration(Duration tokenExpiration) {
            this.tokenExpiration = tokenExpiration;
            return this;
        }

        public Duration tokenExpiration() {
            return this.tokenExpiration;
        }

        @Override
        public ApnsClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            Objects.requireNonNull(this.authority(), "Authority must be set before building a TokenAuthenticationApnsClientHandler.");
            Objects.requireNonNull(this.signingKey(), "Signing key must be set before building a TokenAuthenticationApnsClientHandler.");
            Objects.requireNonNull(this.tokenExpiration(), "Token expiration duration must be set before building a TokenAuthenticationApnsClientHandler.");
            TokenAuthenticationApnsClientHandler handler = new TokenAuthenticationApnsClientHandler(decoder, encoder, initialSettings, this.authority(), this.idlePingInterval(), this.signingKey(), this.tokenExpiration());
            this.frameListener(handler);
            return handler;
        }
    }
}

