/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import com.eatthepath.pushy.apns.DeliveryPriority;
import com.eatthepath.pushy.apns.PushType;
import com.eatthepath.pushy.apns.server.PushNotificationHandler;
import com.eatthepath.pushy.apns.server.RejectedNotificationException;
import com.eatthepath.pushy.apns.server.RejectionReason;
import com.eatthepath.pushy.apns.server.UnregisteredDeviceTokenException;
import com.eatthepath.uuid.FastUUID;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class ValidatingPushNotificationHandler
implements PushNotificationHandler {
    private final Map<String, Set<String>> deviceTokensByTopic;
    private final Map<String, Date> expirationTimestampsByDeviceToken;
    private static final String APNS_PATH_PREFIX = "/3/device/";
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_ID_HEADER = new AsciiString((CharSequence)"apns-id");
    private static final AsciiString APNS_COLLAPSE_ID_HEADER = new AsciiString((CharSequence)"apns-collapse-id");
    private static final AsciiString APNS_PUSH_TYPE_HEADER = new AsciiString((CharSequence)"apns-push-type");
    private static final Pattern DEVICE_TOKEN_PATTERN = Pattern.compile("[0-9a-fA-F]{64}");
    private static final int MAX_PAYLOAD_SIZE = 4096;
    private static final int MAX_COLLAPSE_ID_SIZE = 64;

    ValidatingPushNotificationHandler(Map<String, Set<String>> deviceTokensByTopic, Map<String, Date> expirationTimestampsByDeviceToken) {
        this.deviceTokensByTopic = deviceTokensByTopic;
        this.expirationTimestampsByDeviceToken = expirationTimestampsByDeviceToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handlePushNotification(Http2Headers headers, ByteBuf payload) throws RejectedNotificationException {
        CharSequence pathSequence;
        CharSequence pushTypeSequence;
        try {
            CharSequence apnsIdSequence = (CharSequence)headers.get((Object)APNS_ID_HEADER);
            if (apnsIdSequence != null) {
                FastUUID.parseUUID((CharSequence)apnsIdSequence);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RejectedNotificationException(RejectionReason.BAD_MESSAGE_ID);
        }
        if (!HttpMethod.POST.asciiName().contentEquals((CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.METHOD.value()))) {
            throw new RejectedNotificationException(RejectionReason.METHOD_NOT_ALLOWED);
        }
        CharSequence topicSequence = (CharSequence)headers.get((Object)APNS_TOPIC_HEADER);
        if (topicSequence == null) {
            throw new RejectedNotificationException(RejectionReason.MISSING_TOPIC);
        }
        String topic = topicSequence.toString();
        CharSequence collapseIdSequence = (CharSequence)headers.get((Object)APNS_COLLAPSE_ID_HEADER);
        if (collapseIdSequence != null && collapseIdSequence.toString().getBytes(StandardCharsets.UTF_8).length > 64) {
            throw new RejectedNotificationException(RejectionReason.BAD_COLLAPSE_ID);
        }
        Integer priorityCode = headers.getInt((Object)APNS_PRIORITY_HEADER);
        if (priorityCode != null) {
            try {
                DeliveryPriority.getFromCode(priorityCode);
            }
            catch (IllegalArgumentException e) {
                throw new RejectedNotificationException(RejectionReason.BAD_PRIORITY);
            }
        }
        if ((pushTypeSequence = (CharSequence)headers.get((Object)APNS_PUSH_TYPE_HEADER)) != null) {
            try {
                PushType.getFromHeaderValue(pushTypeSequence);
            }
            catch (IllegalArgumentException e) {
                throw new RejectedNotificationException(RejectionReason.INVALID_PUSH_TYPE);
            }
        }
        if ((pathSequence = (CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PATH.value())) == null) throw new RejectedNotificationException(RejectionReason.BAD_PATH);
        String pathString = pathSequence.toString();
        if (pathSequence.toString().equals(APNS_PATH_PREFIX)) {
            throw new RejectedNotificationException(RejectionReason.MISSING_DEVICE_TOKEN);
        }
        if (!pathString.startsWith(APNS_PATH_PREFIX)) throw new RejectedNotificationException(RejectionReason.BAD_PATH);
        String deviceToken = pathString.substring(APNS_PATH_PREFIX.length());
        Matcher tokenMatcher = DEVICE_TOKEN_PATTERN.matcher(deviceToken);
        if (!tokenMatcher.matches()) {
            throw new RejectedNotificationException(RejectionReason.BAD_DEVICE_TOKEN);
        }
        Date expirationTimestamp = this.expirationTimestampsByDeviceToken.get(deviceToken);
        if (expirationTimestamp != null) {
            throw new UnregisteredDeviceTokenException(expirationTimestamp);
        }
        Set<String> allowedDeviceTokensForTopic = this.deviceTokensByTopic.get(topic);
        if (allowedDeviceTokensForTopic == null || !allowedDeviceTokensForTopic.contains(deviceToken)) {
            throw new RejectedNotificationException(RejectionReason.DEVICE_TOKEN_NOT_FOR_TOPIC);
        }
        this.verifyAuthentication(headers);
        if (payload == null || payload.readableBytes() == 0) {
            throw new RejectedNotificationException(RejectionReason.PAYLOAD_EMPTY);
        }
        if (payload.readableBytes() <= 4096) return;
        throw new RejectedNotificationException(RejectionReason.PAYLOAD_TOO_LARGE);
    }

    protected abstract void verifyAuthentication(Http2Headers var1) throws RejectedNotificationException;
}

