/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import com.eatthepath.pushy.apns.auth.ApnsVerificationKey;
import com.eatthepath.pushy.apns.server.PushNotificationHandler;
import com.eatthepath.pushy.apns.server.PushNotificationHandlerFactory;
import com.eatthepath.pushy.apns.server.TlsAuthenticationValidatingPushNotificationHandler;
import com.eatthepath.pushy.apns.server.TokenAuthenticationValidatingPushNotificationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ValidatingPushNotificationHandlerFactory
implements PushNotificationHandlerFactory {
    private final Map<String, Set<String>> deviceTokensByTopic;
    private final Map<String, Date> expirationTimestampsByDeviceToken;
    private final Map<String, ApnsVerificationKey> verificationKeysByKeyId;
    private final Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey;

    public ValidatingPushNotificationHandlerFactory(Map<String, Set<String>> deviceTokensByTopic, Map<String, Date> expirationTimestampsByDeviceToken, Map<String, ApnsVerificationKey> verificationKeysByKeyId, Map<ApnsVerificationKey, Set<String>> topicsByVerificationKey) {
        this.deviceTokensByTopic = deviceTokensByTopic != null ? deviceTokensByTopic : Collections.emptyMap();
        this.expirationTimestampsByDeviceToken = expirationTimestampsByDeviceToken != null ? expirationTimestampsByDeviceToken : Collections.emptyMap();
        this.verificationKeysByKeyId = verificationKeysByKeyId != null ? verificationKeysByKeyId : Collections.emptyMap();
        this.topicsByVerificationKey = topicsByVerificationKey != null ? topicsByVerificationKey : Collections.emptyMap();
    }

    @Override
    public PushNotificationHandler buildHandler(SSLSession sslSession) {
        try {
            String principalName = sslSession.getPeerPrincipal().getName();
            Pattern pattern = Pattern.compile(".*UID=([^,]+).*");
            Matcher matcher = pattern.matcher(principalName);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Client certificate does not specify a base topic.");
            }
            String baseTopic = matcher.group(1);
            return new TlsAuthenticationValidatingPushNotificationHandler(this.deviceTokensByTopic, this.expirationTimestampsByDeviceToken, baseTopic);
        }
        catch (SSLPeerUnverifiedException e) {
            return new TokenAuthenticationValidatingPushNotificationHandler(this.deviceTokensByTopic, this.expirationTimestampsByDeviceToken, this.verificationKeysByKeyId, this.topicsByVerificationKey);
        }
    }
}

