/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.auth;

import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.auth.ApnsVerificationKey;
import com.eatthepath.pushy.apns.util.DateAsTimeSinceEpochTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class AuthenticationToken {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.SECONDS)).create();
    private final AuthenticationTokenHeader header;
    private final AuthenticationTokenClaims claims;
    private final byte[] signatureBytes;
    private final transient String base64EncodedToken;
    private final transient AsciiString authorizationHeader;

    public AuthenticationToken(ApnsSigningKey signingKey, Date issuedAt) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.header = new AuthenticationTokenHeader(signingKey.getKeyId());
        this.claims = new AuthenticationTokenClaims(signingKey.getTeamId(), issuedAt);
        String headerJson = GSON.toJson((Object)this.header);
        String claimsJson = GSON.toJson((Object)this.claims);
        StringBuilder payloadBuilder = new StringBuilder();
        payloadBuilder.append(AuthenticationToken.encodeUnpaddedBase64UrlString(headerJson.getBytes(StandardCharsets.US_ASCII)));
        payloadBuilder.append('.');
        payloadBuilder.append(AuthenticationToken.encodeUnpaddedBase64UrlString(claimsJson.getBytes(StandardCharsets.US_ASCII)));
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(signingKey);
        signature.update(payloadBuilder.toString().getBytes(StandardCharsets.US_ASCII));
        this.signatureBytes = signature.sign();
        payloadBuilder.append('.');
        payloadBuilder.append(AuthenticationToken.encodeUnpaddedBase64UrlString(this.signatureBytes));
        this.base64EncodedToken = payloadBuilder.toString();
        this.authorizationHeader = new AsciiString((CharSequence)("bearer " + payloadBuilder.toString()));
    }

    public AuthenticationToken(String base64EncodedToken) {
        Objects.requireNonNull(base64EncodedToken, "Encoded token must not be null.");
        this.base64EncodedToken = base64EncodedToken;
        this.authorizationHeader = new AsciiString((CharSequence)("bearer " + base64EncodedToken));
        String[] jwtSegments = base64EncodedToken.split("\\.");
        if (jwtSegments.length != 3) {
            throw new IllegalArgumentException();
        }
        this.header = (AuthenticationTokenHeader)GSON.fromJson(new String(AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[0]), StandardCharsets.US_ASCII), AuthenticationTokenHeader.class);
        this.claims = (AuthenticationTokenClaims)GSON.fromJson(new String(AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[1]), StandardCharsets.US_ASCII), AuthenticationTokenClaims.class);
        this.signatureBytes = AuthenticationToken.decodeBase64UrlEncodedString(jwtSegments[2]);
    }

    public Date getIssuedAt() {
        return this.claims.getIssuedAt();
    }

    public String getKeyId() {
        return this.header.getKeyId();
    }

    public String getTeamId() {
        return this.claims.getIssuer();
    }

    public boolean verifySignature(ApnsVerificationKey verificationKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.header.getKeyId().equals(verificationKey.getKeyId())) {
            return false;
        }
        if (!this.claims.getIssuer().equals(verificationKey.getTeamId())) {
            return false;
        }
        String headerJson = GSON.toJson((Object)this.header);
        String claimsJson = GSON.toJson((Object)this.claims);
        String encodedHeaderAndClaims = AuthenticationToken.encodeUnpaddedBase64UrlString(headerJson.getBytes(StandardCharsets.US_ASCII)) + '.' + AuthenticationToken.encodeUnpaddedBase64UrlString(claimsJson.getBytes(StandardCharsets.US_ASCII));
        byte[] headerAndClaimsBytes = encodedHeaderAndClaims.getBytes(StandardCharsets.US_ASCII);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initVerify(verificationKey);
        signature.update(headerAndClaimsBytes);
        return signature.verify(this.signatureBytes);
    }

    public AsciiString getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public String toString() {
        return this.base64EncodedToken;
    }

    public int hashCode() {
        return this.base64EncodedToken.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationToken)) {
            return false;
        }
        AuthenticationToken other = (AuthenticationToken)obj;
        if (this.base64EncodedToken == null) {
            return other.base64EncodedToken == null;
        }
        return this.base64EncodedToken.equals(other.base64EncodedToken);
    }

    static String encodeUnpaddedBase64UrlString(byte[] data) {
        ByteBuf wrappedString = Unpooled.wrappedBuffer((byte[])data);
        ByteBuf encodedString = Base64.encode((ByteBuf)wrappedString, (Base64Dialect)Base64Dialect.URL_SAFE);
        String encodedUnpaddedString = encodedString.toString(StandardCharsets.US_ASCII).replace("=", "");
        wrappedString.release();
        encodedString.release();
        return encodedUnpaddedString;
    }

    static byte[] decodeBase64UrlEncodedString(String base64UrlEncodedString) {
        String paddedBase64UrlEncodedString;
        switch (base64UrlEncodedString.length() % 4) {
            case 2: {
                paddedBase64UrlEncodedString = base64UrlEncodedString + "==";
                break;
            }
            case 3: {
                paddedBase64UrlEncodedString = base64UrlEncodedString + "=";
                break;
            }
            default: {
                paddedBase64UrlEncodedString = base64UrlEncodedString;
            }
        }
        ByteBuf base64EncodedByteBuf = Unpooled.wrappedBuffer((byte[])paddedBase64UrlEncodedString.getBytes(StandardCharsets.US_ASCII));
        ByteBuf decodedByteBuf = Base64.decode((ByteBuf)base64EncodedByteBuf, (Base64Dialect)Base64Dialect.URL_SAFE);
        byte[] decodedBytes = new byte[decodedByteBuf.readableBytes()];
        decodedByteBuf.readBytes(decodedBytes);
        base64EncodedByteBuf.release();
        decodedByteBuf.release();
        return decodedBytes;
    }

    private static class AuthenticationTokenClaims {
        @SerializedName(value="iss")
        private final String issuer;
        @SerializedName(value="iat")
        private final Date issuedAt;

        AuthenticationTokenClaims(String teamId, Date issuedAt) {
            this.issuer = teamId;
            this.issuedAt = issuedAt;
        }

        String getIssuer() {
            return this.issuer;
        }

        Date getIssuedAt() {
            return this.issuedAt;
        }
    }

    private static class AuthenticationTokenHeader {
        @SerializedName(value="alg")
        private final String algorithm = "ES256";
        @SerializedName(value="typ")
        private final String tokenType = "JWT";
        @SerializedName(value="kid")
        private final String keyId;

        AuthenticationTokenHeader(String keyId) {
            this.keyId = keyId;
        }

        String getKeyId() {
            return this.keyId;
        }
    }
}

