/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.jvptree.util;

import com.eatthepath.jvptree.DistanceFunction;
import com.eatthepath.jvptree.ThresholdSelectionStrategy;
import com.eatthepath.jvptree.util.MedianDistanceThresholdSelectionStrategy;
import java.util.ArrayList;
import java.util.List;

public class SamplingMedianDistanceThresholdSelectionStrategy<P, E extends P>
extends MedianDistanceThresholdSelectionStrategy<P, E>
implements ThresholdSelectionStrategy<P, E> {
    private final int numberOfSamples;
    public static final int DEFAULT_NUMBER_OF_SAMPLES = 32;

    public SamplingMedianDistanceThresholdSelectionStrategy(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    @Override
    public double selectThreshold(List<E> points, P origin, DistanceFunction<P> distanceFunction) {
        return super.selectThreshold(this.getSampledPoints(points), origin, distanceFunction);
    }

    private List<E> getSampledPoints(List<E> points) {
        List<E> sampledPoints;
        int numberOfPoints = points.size();
        if (numberOfPoints > this.numberOfSamples) {
            sampledPoints = new ArrayList(this.numberOfSamples);
            for (int i = 0; i < this.numberOfSamples; ++i) {
                sampledPoints.add(points.get(i * numberOfPoints / this.numberOfSamples));
            }
        } else {
            sampledPoints = points;
        }
        return sampledPoints;
    }
}

