/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.jvptree.util;

import com.eatthepath.jvptree.DistanceFunction;
import com.eatthepath.jvptree.ThresholdSelectionStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class MedianDistanceThresholdSelectionStrategy<P, E extends P>
implements ThresholdSelectionStrategy<P, E> {
    @Override
    public double selectThreshold(List<E> points, P origin, DistanceFunction<P> distanceFunction) {
        if (points.isEmpty()) {
            throw new IllegalArgumentException("Point list must not be empty.");
        }
        int left = 0;
        int right = points.size() - 1;
        int medianIndex = points.size() / 2;
        Random random = new Random();
        while (left != right) {
            int pivotIndex = left + (right - left == 0 ? 0 : random.nextInt(right - left));
            double pivotDistance = distanceFunction.getDistance(origin, points.get(pivotIndex));
            Collections.swap(points, pivotIndex, right);
            int storeIndex = left;
            for (int i = left; i < right; ++i) {
                if (!(distanceFunction.getDistance(origin, points.get(i)) < pivotDistance)) continue;
                Collections.swap(points, storeIndex++, i);
            }
            Collections.swap(points, right, storeIndex);
            if (storeIndex == medianIndex) break;
            if (storeIndex < medianIndex) {
                left = storeIndex + 1;
                continue;
            }
            right = storeIndex - 1;
        }
        return distanceFunction.getDistance(origin, points.get(medianIndex));
    }
}

