/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.jvptree;

import com.eatthepath.jvptree.DistanceFunction;
import com.eatthepath.jvptree.NearestNeighborCollector;
import com.eatthepath.jvptree.PartitionException;
import com.eatthepath.jvptree.ThresholdSelectionStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

class VPTreeNode<P, E extends P> {
    private final int capacity;
    private final DistanceFunction<P> distanceFunction;
    private final ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy;
    private ArrayList<E> points;
    private final E vantagePoint;
    private double threshold;
    private VPTreeNode<P, E> closer;
    private VPTreeNode<P, E> farther;

    public VPTreeNode(Collection<E> points, DistanceFunction<P> distanceFunction, ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy, int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive.");
        }
        if (points.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a VPTreeNode with an empty list of points.");
        }
        this.capacity = capacity;
        this.distanceFunction = distanceFunction;
        this.thresholdSelectionStrategy = thresholdSelectionStrategy;
        this.points = new ArrayList<E>(points);
        this.vantagePoint = this.points.get(new Random().nextInt(points.size()));
        this.anneal();
    }

    protected void anneal() {
        if (this.points == null) {
            int closerSize = this.closer.size();
            int fartherSize = this.farther.size();
            if (closerSize == 0 || fartherSize == 0) {
                this.points = new ArrayList(closerSize + fartherSize);
                this.addAllPointsToCollection(this.points);
                this.closer = null;
                this.farther = null;
                this.anneal();
            } else {
                this.closer.anneal();
                this.farther.anneal();
            }
        } else if (this.points.size() > this.capacity) {
            this.threshold = this.thresholdSelectionStrategy.selectThreshold(this.points, this.vantagePoint, this.distanceFunction);
            try {
                int firstIndexPastThreshold = VPTreeNode.partitionPoints(this.points, this.vantagePoint, this.threshold, this.distanceFunction);
                this.closer = new VPTreeNode<P, E>(this.points.subList(0, firstIndexPastThreshold), this.distanceFunction, this.thresholdSelectionStrategy, this.capacity);
                this.farther = new VPTreeNode<P, E>(this.points.subList(firstIndexPastThreshold, this.points.size()), this.distanceFunction, this.thresholdSelectionStrategy, this.capacity);
                this.points = null;
            }
            catch (PartitionException e) {
                this.closer = null;
                this.farther = null;
            }
        }
    }

    public int size() {
        if (this.points == null) {
            return this.closer.size() + this.farther.size();
        }
        return this.points.size();
    }

    public void add(E point) {
        if (this.points == null) {
            this.getChildNodeForPoint(point).add(point);
        } else {
            this.points.add(point);
        }
    }

    public boolean remove(E point) {
        boolean modified = this.points == null ? this.getChildNodeForPoint(point).remove(point) : this.points.remove(point);
        return modified;
    }

    public boolean retainAll(Collection<?> points) {
        boolean modified;
        if (this.points == null) {
            boolean modifiedCloser = this.closer.retainAll(points);
            boolean modifiedFarther = this.farther.retainAll(points);
            modified = modifiedCloser || modifiedFarther;
        } else {
            modified = this.points.retainAll(points);
        }
        return modified;
    }

    public boolean contains(E point) {
        return this.points == null ? this.getChildNodeForPoint(point).contains(point) : this.points.contains(point);
    }

    public void collectNearestNeighbors(NearestNeighborCollector<P, E> collector) {
        block4: {
            block2: {
                double distanceFromQueryPointToFarthestPoint;
                double distanceFromVantagePointToQueryPoint;
                block3: {
                    if (this.points != null) break block2;
                    VPTreeNode<P, E> firstNodeSearched = this.getChildNodeForPoint(collector.getQueryPoint());
                    firstNodeSearched.collectNearestNeighbors(collector);
                    distanceFromVantagePointToQueryPoint = this.distanceFunction.getDistance(this.vantagePoint, collector.getQueryPoint());
                    distanceFromQueryPointToFarthestPoint = this.distanceFunction.getDistance(collector.getQueryPoint(), collector.getFarthestPoint());
                    if (firstNodeSearched != this.closer) break block3;
                    double distanceFromQueryPointToThreshold = this.threshold - distanceFromVantagePointToQueryPoint;
                    if (distanceFromQueryPointToFarthestPoint > distanceFromQueryPointToThreshold) {
                        this.farther.collectNearestNeighbors(collector);
                    }
                    break block4;
                }
                double distanceFromQueryPointToThreshold = distanceFromVantagePointToQueryPoint - this.threshold;
                if (!(distanceFromQueryPointToThreshold <= distanceFromQueryPointToFarthestPoint)) break block4;
                this.closer.collectNearestNeighbors(collector);
                break block4;
            }
            for (E point : this.points) {
                collector.offerPoint(point);
            }
        }
    }

    public void collectAllWithinDistance(P queryPoint, double maxDistance, Collection<E> collection) {
        if (this.points == null) {
            double distanceFromVantagePointToQueryPoint = this.distanceFunction.getDistance(this.vantagePoint, queryPoint);
            if (distanceFromVantagePointToQueryPoint <= this.threshold + maxDistance) {
                this.closer.collectAllWithinDistance(queryPoint, maxDistance, collection);
            }
            if (distanceFromVantagePointToQueryPoint + maxDistance > this.threshold) {
                this.farther.collectAllWithinDistance(queryPoint, maxDistance, collection);
            }
        } else {
            for (E point : this.points) {
                if (!(this.distanceFunction.getDistance(queryPoint, point) <= maxDistance)) continue;
                collection.add(point);
            }
        }
    }

    private VPTreeNode<P, E> getChildNodeForPoint(P point) {
        return this.distanceFunction.getDistance(this.vantagePoint, point) <= this.threshold ? this.closer : this.farther;
    }

    private void addAllPointsToCollection(Collection<E> collection) {
        if (this.points == null) {
            super.addAllPointsToCollection(collection);
            super.addAllPointsToCollection(collection);
        } else {
            collection.addAll(this.points);
        }
    }

    public int addPointsToArray(Object[] array, int offset) {
        int pointsAdded;
        if (this.points == null) {
            int pointsAddedFromCloserNode = this.closer.addPointsToArray(array, offset);
            int pointsAddedFromFartherNode = this.farther.addPointsToArray(array, offset + pointsAddedFromCloserNode);
            pointsAdded = pointsAddedFromCloserNode + pointsAddedFromFartherNode;
        } else {
            System.arraycopy(this.points.toArray(), 0, array, offset, this.points.size());
            pointsAdded = this.points.size();
        }
        return pointsAdded;
    }

    public void collectIterators(Collection<Iterator<E>> collection) {
        if (this.points == null) {
            this.closer.collectIterators(collection);
            this.farther.collectIterators(collection);
        } else {
            collection.add(this.points.iterator());
        }
    }

    private static <E> int partitionPoints(List<E> points, E vantagePoint, double threshold, DistanceFunction<? super E> distanceFunction) throws PartitionException {
        int firstIndexPastThreshold;
        int i;
        int j = points.size() - 1;
        block0: for (i = 0; i <= j; ++i) {
            if (!(distanceFunction.getDistance(vantagePoint, points.get(i)) > threshold)) continue;
            while (j >= i) {
                if (distanceFunction.getDistance(vantagePoint, points.get(j)) <= threshold) {
                    Collections.swap(points, i, j--);
                    continue block0;
                }
                --j;
            }
        }
        int n = firstIndexPastThreshold = distanceFunction.getDistance(vantagePoint, points.get(i - 1)) > threshold ? i - 1 : i;
        if (distanceFunction.getDistance(vantagePoint, points.get(0)) <= threshold && distanceFunction.getDistance(vantagePoint, points.get(points.size() - 1)) > threshold) {
            return firstIndexPastThreshold;
        }
        throw new PartitionException();
    }
}

