/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.jvptree;

import com.eatthepath.jvptree.DistanceFunction;
import com.eatthepath.jvptree.MetaIterator;
import com.eatthepath.jvptree.NearestNeighborCollector;
import com.eatthepath.jvptree.SpatialIndex;
import com.eatthepath.jvptree.ThresholdSelectionStrategy;
import com.eatthepath.jvptree.VPTreeNode;
import com.eatthepath.jvptree.util.SamplingMedianDistanceThresholdSelectionStrategy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VPTree<P, E extends P>
implements SpatialIndex<P, E> {
    private final DistanceFunction<P> distanceFunction;
    private final ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy;
    private final int nodeCapacity;
    private VPTreeNode<P, E> rootNode;
    public static final int DEFAULT_NODE_CAPACITY = 32;

    public VPTree(DistanceFunction<P> distanceFunction) {
        this(distanceFunction, (Collection)null);
    }

    public VPTree(DistanceFunction<P> distanceFunction, Collection<E> points) {
        this(distanceFunction, new SamplingMedianDistanceThresholdSelectionStrategy(32), 32, points);
    }

    public VPTree(DistanceFunction<P> distanceFunction, ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy) {
        this(distanceFunction, thresholdSelectionStrategy, 32, null);
    }

    public VPTree(DistanceFunction<P> distanceFunction, ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy, Collection<E> points) {
        this(distanceFunction, thresholdSelectionStrategy, 32, points);
    }

    public VPTree(DistanceFunction<P> distanceFunction, ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy, int nodeCapacity) {
        this(distanceFunction, thresholdSelectionStrategy, nodeCapacity, null);
    }

    public VPTree(DistanceFunction<P> distanceFunction, ThresholdSelectionStrategy<P, E> thresholdSelectionStrategy, int nodeCapacity, Collection<E> points) {
        this.distanceFunction = distanceFunction;
        this.thresholdSelectionStrategy = thresholdSelectionStrategy;
        this.nodeCapacity = nodeCapacity;
        if (points != null && !points.isEmpty()) {
            this.rootNode = new VPTreeNode<P, E>(points, this.distanceFunction, this.thresholdSelectionStrategy, this.nodeCapacity);
        }
    }

    @Override
    public List<E> getNearestNeighbors(P queryPoint, int maxResults) {
        List nearestNeighbors;
        if (this.rootNode == null) {
            nearestNeighbors = null;
        } else {
            NearestNeighborCollector collector = new NearestNeighborCollector(queryPoint, this.distanceFunction, maxResults);
            this.rootNode.collectNearestNeighbors(collector);
            nearestNeighbors = collector.toSortedList();
        }
        return nearestNeighbors;
    }

    @Override
    public List<E> getAllWithinDistance(P queryPoint, double maxDistance) {
        ArrayList pointsWithinRange;
        if (this.rootNode == null) {
            pointsWithinRange = null;
        } else {
            pointsWithinRange = new ArrayList();
            this.rootNode.collectAllWithinDistance(queryPoint, maxDistance, pointsWithinRange);
        }
        return pointsWithinRange;
    }

    @Override
    public int size() {
        return this.rootNode == null ? 0 : this.rootNode.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        try {
            return this.rootNode == null ? false : this.rootNode.contains(o);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> points) {
        for (Object point : points) {
            if (this.contains(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        ArrayList iterators = new ArrayList();
        if (this.rootNode != null) {
            this.rootNode.collectIterators(iterators);
        }
        return new MetaIterator(iterators);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        if (this.rootNode != null) {
            this.rootNode.addPointsToArray(array, 0);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] arrayToPopulate = array.length < this.size() ? (Object[])Array.newInstance(array.getClass().getComponentType(), this.size()) : array;
        if (this.rootNode != null) {
            this.rootNode.addPointsToArray(arrayToPopulate, 0);
        }
        return arrayToPopulate;
    }

    @Override
    public boolean add(E point) {
        return this.addAll(Collections.singletonList(point));
    }

    @Override
    public boolean addAll(Collection<? extends E> points) {
        boolean modified;
        boolean bl = modified = !points.isEmpty();
        if (this.rootNode == null) {
            this.rootNode = new VPTreeNode<P, E>(points, this.distanceFunction, this.thresholdSelectionStrategy, this.nodeCapacity);
        } else {
            for (E point : points) {
                this.rootNode.add(point);
            }
            if (modified) {
                this.rootNode.anneal();
            }
        }
        return modified;
    }

    @Override
    public boolean remove(Object point) {
        return this.removeAll(Collections.singletonList(point));
    }

    @Override
    public boolean removeAll(Collection<?> points) {
        boolean pointRemoved = false;
        if (this.rootNode == null) {
            pointRemoved = false;
        } else {
            for (Object point : points) {
                try {
                    pointRemoved = this.rootNode.remove(point) || pointRemoved;
                }
                catch (ClassCastException classCastException) {}
            }
        }
        if (pointRemoved) {
            this.rootNode.anneal();
        }
        return pointRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> points) {
        boolean modified;
        boolean bl = modified = this.rootNode == null ? false : this.rootNode.retainAll(points);
        if (modified) {
            this.rootNode.anneal();
        }
        return modified;
    }

    @Override
    public void clear() {
        this.rootNode = null;
    }
}

