/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.jvptree;

import com.eatthepath.jvptree.DistanceComparator;
import com.eatthepath.jvptree.DistanceFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;

class NearestNeighborCollector<P, E extends P> {
    private final P queryPoint;
    private final int capacity;
    private final DistanceFunction<P> distanceFunction;
    private final DistanceComparator<P> distanceComparator;
    private final PriorityQueue<E> priorityQueue;
    private double distanceToFarthestPoint;

    public NearestNeighborCollector(P queryPoint, DistanceFunction<P> distanceFunction, int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive.");
        }
        this.queryPoint = queryPoint;
        this.distanceFunction = distanceFunction;
        this.capacity = capacity;
        this.distanceComparator = new DistanceComparator<P>(queryPoint, distanceFunction);
        this.priorityQueue = new PriorityQueue<P>(this.capacity, Collections.reverseOrder(this.distanceComparator));
    }

    public P getQueryPoint() {
        return this.queryPoint;
    }

    public void offerPoint(E point) {
        boolean pointAdded;
        if (this.priorityQueue.size() < this.capacity) {
            this.priorityQueue.add(point);
            pointAdded = true;
        } else {
            assert (this.priorityQueue.size() > 0);
            double distanceToNewPoint = this.distanceFunction.getDistance(this.queryPoint, point);
            if (distanceToNewPoint < this.distanceToFarthestPoint) {
                this.priorityQueue.poll();
                this.priorityQueue.add(point);
                pointAdded = true;
            } else {
                pointAdded = false;
            }
        }
        if (pointAdded) {
            this.distanceToFarthestPoint = this.distanceFunction.getDistance(this.queryPoint, this.priorityQueue.peek());
        }
    }

    public E getFarthestPoint() {
        return this.priorityQueue.peek();
    }

    public List<E> toSortedList() {
        ArrayList<E> sortedList = new ArrayList<E>(this.priorityQueue);
        Collections.sort(sortedList, this.distanceComparator);
        return sortedList;
    }
}

