/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.otp;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public class HmacOneTimePasswordGenerator {
    private final Mac mac;
    private final int passwordLength;
    private final ByteBuffer buffer;
    private final int modDivisor;
    private final String formatString;
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final String HOTP_HMAC_ALGORITHM = "HmacSHA1";

    public HmacOneTimePasswordGenerator() throws NoSuchAlgorithmException {
        this(6);
    }

    public HmacOneTimePasswordGenerator(int passwordLength) throws NoSuchAlgorithmException {
        this(passwordLength, HOTP_HMAC_ALGORITHM);
    }

    protected HmacOneTimePasswordGenerator(int passwordLength, String algorithm) throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(algorithm);
        switch (passwordLength) {
            case 6: {
                this.modDivisor = 1000000;
                this.formatString = "%06d";
                break;
            }
            case 7: {
                this.modDivisor = 10000000;
                this.formatString = "%07d";
                break;
            }
            case 8: {
                this.modDivisor = 100000000;
                this.formatString = "%08d";
                break;
            }
            default: {
                throw new IllegalArgumentException("Password length must be between 6 and 8 digits.");
            }
        }
        this.passwordLength = passwordLength;
        this.buffer = ByteBuffer.allocate(this.mac.getMacLength());
    }

    public synchronized int generateOneTimePassword(Key key, long counter) throws InvalidKeyException {
        this.buffer.clear();
        this.buffer.putLong(0, counter);
        try {
            byte[] array = this.buffer.array();
            this.mac.init(key);
            this.mac.update(array, 0, 8);
            this.mac.doFinal(array, 0);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException(e);
        }
        int offset = this.buffer.get(this.buffer.capacity() - 1) & 0xF;
        return (this.buffer.getInt(offset) & Integer.MAX_VALUE) % this.modDivisor;
    }

    public String generateOneTimePasswordString(Key key, long counter) throws InvalidKeyException {
        return this.generateOneTimePasswordString(key, counter, Locale.getDefault());
    }

    public String generateOneTimePasswordString(Key key, long counter, Locale locale) throws InvalidKeyException {
        return this.formatOneTimePassword(this.generateOneTimePassword(key, counter), locale);
    }

    protected String formatOneTimePassword(int oneTimePassword, Locale locale) {
        return String.format(locale, this.formatString, oneTimePassword);
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

