/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.otp;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public class HmacOneTimePasswordGenerator {
    private final String algorithm;
    private final int passwordLength;
    private final int modDivisor;
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final String HOTP_HMAC_ALGORITHM = "HmacSHA1";

    public HmacOneTimePasswordGenerator() throws NoSuchAlgorithmException {
        this(6);
    }

    public HmacOneTimePasswordGenerator(int passwordLength) throws NoSuchAlgorithmException {
        this(passwordLength, HOTP_HMAC_ALGORITHM);
    }

    protected HmacOneTimePasswordGenerator(int passwordLength, String algorithm) throws NoSuchAlgorithmException {
        switch (passwordLength) {
            case 6: {
                this.modDivisor = 1000000;
                break;
            }
            case 7: {
                this.modDivisor = 10000000;
                break;
            }
            case 8: {
                this.modDivisor = 100000000;
                break;
            }
            default: {
                throw new IllegalArgumentException("Password length must be between 6 and 8 digits.");
            }
        }
        this.passwordLength = passwordLength;
        Mac.getInstance(algorithm);
        this.algorithm = algorithm;
    }

    public int generateOneTimePassword(Key key, long counter) throws InvalidKeyException {
        Mac mac;
        try {
            mac = Mac.getInstance(this.algorithm);
            mac.init(key);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, counter);
        byte[] hmac = mac.doFinal(buffer.array());
        int offset = hmac[hmac.length - 1] & 0xF;
        for (int i = 0; i < 4; ++i) {
            buffer.put(i, hmac[i + offset]);
        }
        int hotp = buffer.getInt(0) & Integer.MAX_VALUE;
        return hotp % this.modDivisor;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

