/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class UploadAndDownloadFilesApi {
    private ApiClient apiClient;

    public UploadAndDownloadFilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UploadAndDownloadFilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call orgNameAppNameChatfilesFilestreamGetCall(String orgName, String appName, String authorization, String filestream, String shareSecret, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatfiles/{filestream}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{filestream\\}", this.apiClient.escapeString(filestream.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (shareSecret != null) {
            localVarHeaderParams.put("share-secret", this.apiClient.parameterToString(shareSecret));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatfilesFilestreamGetValidateBeforeCall(String orgName, String appName, String authorization, String filestream, String shareSecret, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatfilesFilestreamGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatfilesFilestreamGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatfilesFilestreamGet(Async)");
        }
        if (filestream == null) {
            throw new ApiException("Missing the required parameter 'filestream' when calling orgNameAppNameChatfilesFilestreamGet(Async)");
        }
        if (shareSecret == null) {
            throw new ApiException("Missing the required parameter 'shareSecret' when calling orgNameAppNameChatfilesFilestreamGet(Async)");
        }
        Call call = this.orgNameAppNameChatfilesFilestreamGetCall(orgName, appName, authorization, filestream, shareSecret, progressListener, progressRequestListener);
        return call;
    }

    public File orgNameAppNameChatfilesFilestreamGet(String orgName, String appName, String authorization, String filestream, String shareSecret) throws ApiException {
        ApiResponse<File> resp = this.orgNameAppNameChatfilesFilestreamGetWithHttpInfo(orgName, appName, authorization, filestream, shareSecret);
        return resp.getData();
    }

    public ApiResponse<File> orgNameAppNameChatfilesFilestreamGetWithHttpInfo(String orgName, String appName, String authorization, String filestream, String shareSecret) throws ApiException {
        Call call = this.orgNameAppNameChatfilesFilestreamGetValidateBeforeCall(orgName, appName, authorization, filestream, shareSecret, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatfilesFilestreamGetAsync(String orgName, String appName, String authorization, String filestream, String shareSecret, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatfilesFilestreamGetValidateBeforeCall(orgName, appName, authorization, filestream, shareSecret, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatfilesPostCall(String orgName, String appName, String authorization, File file, Boolean restrictAccess, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatfiles".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (restrictAccess != null) {
            localVarHeaderParams.put("restrict-access", this.apiClient.parameterToString(restrictAccess));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatfilesPostValidateBeforeCall(String orgName, String appName, String authorization, File file, Boolean restrictAccess, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatfilesPost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatfilesPost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatfilesPost(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling orgNameAppNameChatfilesPost(Async)");
        }
        Call call = this.orgNameAppNameChatfilesPostCall(orgName, appName, authorization, file, restrictAccess, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatfilesPost(String orgName, String appName, String authorization, File file, Boolean restrictAccess) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatfilesPostWithHttpInfo(orgName, appName, authorization, file, restrictAccess);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatfilesPostWithHttpInfo(String orgName, String appName, String authorization, File file, Boolean restrictAccess) throws ApiException {
        Call call = this.orgNameAppNameChatfilesPostValidateBeforeCall(orgName, appName, authorization, file, restrictAccess, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatfilesPostAsync(String orgName, String appName, String authorization, File file, Boolean restrictAccess, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatfilesPostValidateBeforeCall(orgName, appName, authorization, file, restrictAccess, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatfilesUuidGetCall(String orgName, String appName, String authorization, String uuid, String shareSecret, Boolean thumbnail, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatfiles/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (shareSecret != null) {
            localVarHeaderParams.put("share-secret", this.apiClient.parameterToString(shareSecret));
        }
        if (thumbnail != null) {
            localVarHeaderParams.put("thumbnail", this.apiClient.parameterToString(thumbnail));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatfilesUuidGetValidateBeforeCall(String orgName, String appName, String authorization, String uuid, String shareSecret, Boolean thumbnail, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatfilesUuidGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatfilesUuidGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatfilesUuidGet(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling orgNameAppNameChatfilesUuidGet(Async)");
        }
        if (shareSecret == null) {
            throw new ApiException("Missing the required parameter 'shareSecret' when calling orgNameAppNameChatfilesUuidGet(Async)");
        }
        if (thumbnail == null) {
            throw new ApiException("Missing the required parameter 'thumbnail' when calling orgNameAppNameChatfilesUuidGet(Async)");
        }
        Call call = this.orgNameAppNameChatfilesUuidGetCall(orgName, appName, authorization, uuid, shareSecret, thumbnail, progressListener, progressRequestListener);
        return call;
    }

    public File orgNameAppNameChatfilesUuidGet(String orgName, String appName, String authorization, String uuid, String shareSecret, Boolean thumbnail) throws ApiException {
        ApiResponse<File> resp = this.orgNameAppNameChatfilesUuidGetWithHttpInfo(orgName, appName, authorization, uuid, shareSecret, thumbnail);
        return resp.getData();
    }

    public ApiResponse<File> orgNameAppNameChatfilesUuidGetWithHttpInfo(String orgName, String appName, String authorization, String uuid, String shareSecret, Boolean thumbnail) throws ApiException {
        Call call = this.orgNameAppNameChatfilesUuidGetValidateBeforeCall(orgName, appName, authorization, uuid, shareSecret, thumbnail, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatfilesUuidGetAsync(String orgName, String appName, String authorization, String uuid, String shareSecret, Boolean thumbnail, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatfilesUuidGetValidateBeforeCall(orgName, appName, authorization, uuid, shareSecret, thumbnail, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

