/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Group;
import io.swagger.client.model.ModifyGroup;
import io.swagger.client.model.NewOwner;
import io.swagger.client.model.UserNames;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class GroupsApi {
    private ApiClient apiClient;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call orgNameAppNameChatgroupsGetCall(String orgName, String appName, String authorization, String limit, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGetValidateBeforeCall(String orgName, String appName, String authorization, String limit, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGet(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGetCall(orgName, appName, authorization, limit, cursor, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGet(String orgName, String appName, String authorization, String limit, String cursor) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGetWithHttpInfo(orgName, appName, authorization, limit, cursor);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGetWithHttpInfo(String orgName, String appName, String authorization, String limit, String cursor) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGetValidateBeforeCall(orgName, appName, authorization, limit, cursor, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGetAsync(String orgName, String appName, String authorization, String limit, String cursor, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGetValidateBeforeCall(orgName, appName, authorization, limit, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersGetCall(String orgName, String appName, String authorization, String groupId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/blocks/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersGetValidateBeforeCall(String orgName, String appName, String authorization, String groupId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersGet(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersGet(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersGetCall(orgName, appName, authorization, groupId, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdBlocksUsersGet(String orgName, String appName, String authorization, String groupId) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdBlocksUsersGetWithHttpInfo(orgName, appName, authorization, groupId);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdBlocksUsersGetWithHttpInfo(String orgName, String appName, String authorization, String groupId) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersGetValidateBeforeCall(orgName, appName, authorization, groupId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdBlocksUsersGetAsync(String orgName, String appName, String authorization, String groupId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersGetValidateBeforeCall(orgName, appName, authorization, groupId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersPostCall(String orgName, String appName, String authorization, String groupId, UserNames body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UserNames localVarPostBody = body;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/blocks/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersPostValidateBeforeCall(String orgName, String appName, String authorization, String groupId, UserNames body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersPost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersPost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersPost(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersPost(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersPostCall(orgName, appName, authorization, groupId, body, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdBlocksUsersPost(String orgName, String appName, String authorization, String groupId, UserNames body) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdBlocksUsersPostWithHttpInfo(orgName, appName, authorization, groupId, body);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdBlocksUsersPostWithHttpInfo(String orgName, String appName, String authorization, String groupId, UserNames body) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersPostValidateBeforeCall(orgName, appName, authorization, groupId, body, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdBlocksUsersPostAsync(String orgName, String appName, String authorization, String groupId, UserNames body, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersPostValidateBeforeCall(orgName, appName, authorization, groupId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteCall(String orgName, String appName, String authorization, String groupId, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/blocks/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteValidateBeforeCall(String orgName, String appName, String authorization, String groupId, String username, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDelete(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDelete(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDelete(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDelete(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteWithHttpInfo(orgName, appName, authorization, groupId, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteWithHttpInfo(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteValidateBeforeCall(orgName, appName, authorization, groupId, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteAsync(String orgName, String appName, String authorization, String groupId, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernameDeleteValidateBeforeCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostCall(String orgName, String appName, String authorization, String groupId, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/blocks/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostValidateBeforeCall(String orgName, String appName, String authorization, String groupId, String username, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePost(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePost(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePost(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePost(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostWithHttpInfo(orgName, appName, authorization, groupId, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostWithHttpInfo(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostValidateBeforeCall(orgName, appName, authorization, groupId, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostAsync(String orgName, String appName, String authorization, String groupId, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamePostValidateBeforeCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteCall(String orgName, String appName, String authorization, String groupId, String usernames, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/blocks/users/{usernames}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{usernames\\}", this.apiClient.escapeString(usernames.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteValidateBeforeCall(String orgName, String appName, String authorization, String groupId, String usernames, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDelete(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDelete(Async)");
        }
        if (usernames == null) {
            throw new ApiException("Missing the required parameter 'usernames' when calling orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDelete(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteCall(orgName, appName, authorization, groupId, usernames, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDelete(String orgName, String appName, String authorization, String groupId, String usernames) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteWithHttpInfo(orgName, appName, authorization, groupId, usernames);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteWithHttpInfo(String orgName, String appName, String authorization, String groupId, String usernames) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteValidateBeforeCall(orgName, appName, authorization, groupId, usernames, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteAsync(String orgName, String appName, String authorization, String groupId, String usernames, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdBlocksUsersUsernamesDeleteValidateBeforeCall(orgName, appName, authorization, groupId, usernames, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdDeleteCall(String orgName, String appName, String authorization, String groupId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdDeleteValidateBeforeCall(String orgName, String appName, String authorization, String groupId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdDelete(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdDelete(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdDeleteCall(orgName, appName, authorization, groupId, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdDelete(String orgName, String appName, String authorization, String groupId) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdDeleteWithHttpInfo(orgName, appName, authorization, groupId);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdDeleteWithHttpInfo(String orgName, String appName, String authorization, String groupId) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdDeleteValidateBeforeCall(orgName, appName, authorization, groupId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdDeleteAsync(String orgName, String appName, String authorization, String groupId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdDeleteValidateBeforeCall(orgName, appName, authorization, groupId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdPutCall(String orgName, String appName, String authorization, String groupId, ModifyGroup body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ModifyGroup localVarPostBody = body;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdPutValidateBeforeCall(String orgName, String appName, String authorization, String groupId, ModifyGroup body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdPut(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdPut(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdPut(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameChatgroupsGroupIdPut(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdPutCall(orgName, appName, authorization, groupId, body, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdPut(String orgName, String appName, String authorization, String groupId, ModifyGroup body) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdPutWithHttpInfo(orgName, appName, authorization, groupId, body);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdPutWithHttpInfo(String orgName, String appName, String authorization, String groupId, ModifyGroup body) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdPutValidateBeforeCall(orgName, appName, authorization, groupId, body, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdPutAsync(String orgName, String appName, String authorization, String groupId, ModifyGroup body, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdPutValidateBeforeCall(orgName, appName, authorization, groupId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersGetCall(String orgName, String appName, String authorization, String groupId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersGetValidateBeforeCall(String orgName, String appName, String authorization, String groupId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdUsersGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdUsersGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdUsersGet(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdUsersGet(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersGetCall(orgName, appName, authorization, groupId, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdUsersGet(String orgName, String appName, String authorization, String groupId) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdUsersGetWithHttpInfo(orgName, appName, authorization, groupId);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdUsersGetWithHttpInfo(String orgName, String appName, String authorization, String groupId) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersGetValidateBeforeCall(orgName, appName, authorization, groupId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdUsersGetAsync(String orgName, String appName, String authorization, String groupId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersGetValidateBeforeCall(orgName, appName, authorization, groupId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersMembersDeleteCall(String orgName, String appName, String authorization, String groupId, String members, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/users/{members}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{members\\}", this.apiClient.escapeString(members.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersMembersDeleteValidateBeforeCall(String orgName, String appName, String authorization, String groupId, String members, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdUsersMembersDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdUsersMembersDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdUsersMembersDelete(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdUsersMembersDelete(Async)");
        }
        if (members == null) {
            throw new ApiException("Missing the required parameter 'members' when calling orgNameAppNameChatgroupsGroupIdUsersMembersDelete(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersMembersDeleteCall(orgName, appName, authorization, groupId, members, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdUsersMembersDelete(String orgName, String appName, String authorization, String groupId, String members) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdUsersMembersDeleteWithHttpInfo(orgName, appName, authorization, groupId, members);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdUsersMembersDeleteWithHttpInfo(String orgName, String appName, String authorization, String groupId, String members) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersMembersDeleteValidateBeforeCall(orgName, appName, authorization, groupId, members, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdUsersMembersDeleteAsync(String orgName, String appName, String authorization, String groupId, String members, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersMembersDeleteValidateBeforeCall(orgName, appName, authorization, groupId, members, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersPostCall(String orgName, String appName, String authorization, String groupId, UserNames body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UserNames localVarPostBody = body;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersPostValidateBeforeCall(String orgName, String appName, String authorization, String groupId, UserNames body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdUsersPost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdUsersPost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdUsersPost(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdUsersPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameChatgroupsGroupIdUsersPost(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersPostCall(orgName, appName, authorization, groupId, body, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdUsersPost(String orgName, String appName, String authorization, String groupId, UserNames body) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdUsersPostWithHttpInfo(orgName, appName, authorization, groupId, body);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdUsersPostWithHttpInfo(String orgName, String appName, String authorization, String groupId, UserNames body) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersPostValidateBeforeCall(orgName, appName, authorization, groupId, body, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdUsersPostAsync(String orgName, String appName, String authorization, String groupId, UserNames body, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersPostValidateBeforeCall(orgName, appName, authorization, groupId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteCall(String orgName, String appName, String authorization, String groupId, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteValidateBeforeCall(String orgName, String appName, String authorization, String groupId, String username, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdUsersUsernameDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdUsersUsernameDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdUsersUsernameDelete(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdUsersUsernameDelete(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameChatgroupsGroupIdUsersUsernameDelete(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdUsersUsernameDelete(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteWithHttpInfo(orgName, appName, authorization, groupId, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteWithHttpInfo(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteValidateBeforeCall(orgName, appName, authorization, groupId, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteAsync(String orgName, String appName, String authorization, String groupId, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersUsernameDeleteValidateBeforeCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersUsernamePostCall(String orgName, String appName, String authorization, String groupId, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_id}/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_id\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdUsersUsernamePostValidateBeforeCall(String orgName, String appName, String authorization, String groupId, String username, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdUsersUsernamePost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdUsersUsernamePost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdUsersUsernamePost(Async)");
        }
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling orgNameAppNameChatgroupsGroupIdUsersUsernamePost(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameChatgroupsGroupIdUsersUsernamePost(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersUsernamePostCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdUsersUsernamePost(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdUsersUsernamePostWithHttpInfo(orgName, appName, authorization, groupId, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdUsersUsernamePostWithHttpInfo(String orgName, String appName, String authorization, String groupId, String username) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersUsernamePostValidateBeforeCall(orgName, appName, authorization, groupId, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdUsersUsernamePostAsync(String orgName, String appName, String authorization, String groupId, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdUsersUsernamePostValidateBeforeCall(orgName, appName, authorization, groupId, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupIdsGetCall(String orgName, String appName, String authorization, String groupIds, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{group_ids}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{group_ids\\}", this.apiClient.escapeString(groupIds.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupIdsGetValidateBeforeCall(String orgName, String appName, String authorization, String groupIds, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupIdsGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupIdsGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupIdsGet(Async)");
        }
        if (groupIds == null) {
            throw new ApiException("Missing the required parameter 'groupIds' when calling orgNameAppNameChatgroupsGroupIdsGet(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdsGetCall(orgName, appName, authorization, groupIds, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupIdsGet(String orgName, String appName, String authorization, String groupIds) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupIdsGetWithHttpInfo(orgName, appName, authorization, groupIds);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupIdsGetWithHttpInfo(String orgName, String appName, String authorization, String groupIds) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupIdsGetValidateBeforeCall(orgName, appName, authorization, groupIds, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupIdsGetAsync(String orgName, String appName, String authorization, String groupIds, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupIdsGetValidateBeforeCall(orgName, appName, authorization, groupIds, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsGroupidPutCall(String orgName, String appName, String authorization, String groupid, NewOwner body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        NewOwner localVarPostBody = body;
        String localVarPath = "/{org_name}/{app_name}/chatgroups/{groupid}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{groupid\\}", this.apiClient.escapeString(groupid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsGroupidPutValidateBeforeCall(String orgName, String appName, String authorization, String groupid, NewOwner body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsGroupidPut(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsGroupidPut(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsGroupidPut(Async)");
        }
        if (groupid == null) {
            throw new ApiException("Missing the required parameter 'groupid' when calling orgNameAppNameChatgroupsGroupidPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameChatgroupsGroupidPut(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsGroupidPutCall(orgName, appName, authorization, groupid, body, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsGroupidPut(String orgName, String appName, String authorization, String groupid, NewOwner body) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsGroupidPutWithHttpInfo(orgName, appName, authorization, groupid, body);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsGroupidPutWithHttpInfo(String orgName, String appName, String authorization, String groupid, NewOwner body) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsGroupidPutValidateBeforeCall(orgName, appName, authorization, groupid, body, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsGroupidPutAsync(String orgName, String appName, String authorization, String groupid, NewOwner body, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsGroupidPutValidateBeforeCall(orgName, appName, authorization, groupid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatgroupsPostCall(String orgName, String appName, String authorization, Group body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Group localVarPostBody = body;
        String localVarPath = "/{org_name}/{app_name}/chatgroups".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call orgNameAppNameChatgroupsPostValidateBeforeCall(String orgName, String appName, String authorization, Group body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatgroupsPost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatgroupsPost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatgroupsPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameChatgroupsPost(Async)");
        }
        Call call = this.orgNameAppNameChatgroupsPostCall(orgName, appName, authorization, body, progressListener, progressRequestListener);
        return call;
    }

    public String orgNameAppNameChatgroupsPost(String orgName, String appName, String authorization, Group body) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatgroupsPostWithHttpInfo(orgName, appName, authorization, body);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatgroupsPostWithHttpInfo(String orgName, String appName, String authorization, Group body) throws ApiException {
        Call call = this.orgNameAppNameChatgroupsPostValidateBeforeCall(orgName, appName, authorization, body, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatgroupsPostAsync(String orgName, String appName, String authorization, Group body, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatgroupsPostValidateBeforeCall(orgName, appName, authorization, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

