/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper.properties;

public class ExpansionBuffer {
    private final StringBuilder resolved = new StringBuilder();
    private String unresolved;

    public ExpansionBuffer(String unresolved) {
        this.unresolved = unresolved != null ? unresolved : "";
    }

    public boolean hasMoreLegalPlaceholders() {
        int prefixPos = this.unresolved.indexOf("${");
        int suffixPos = this.unresolved.indexOf("}", prefixPos + 2);
        return prefixPos >= 0 && suffixPos >= 0;
    }

    public String extractPropertyKey() {
        this.advanceToNextPrefix();
        this.discardPrefix();
        String key = this.beforeNextSuffix();
        this.discardToAfterNextSuffix();
        return key;
    }

    public String toString() {
        return this.resolved.toString() + this.unresolved;
    }

    public void add(String newKey, String newValue) {
        if (this.replaced(newValue)) {
            this.expandFurther(newValue);
        } else {
            this.skipUnresolvedPlaceholder(newKey);
        }
    }

    private boolean replaced(String value) {
        return value != null;
    }

    private void expandFurther(String value) {
        this.unresolved = value + this.unresolved;
    }

    private void skipUnresolvedPlaceholder(String newKey) {
        this.resolved.append("${").append(newKey).append("}");
    }

    private void discardToAfterNextSuffix() {
        int propertySuffixPos = this.unresolved.indexOf("}");
        this.unresolved = this.unresolved.substring(propertySuffixPos + 1);
    }

    private void advanceToNextPrefix() {
        this.resolved.append(this.beforePrefix());
    }

    private void discardPrefix() {
        int propertyPrefixPos = this.unresolved.indexOf("${");
        this.unresolved = this.unresolved.substring(propertyPrefixPos + 2);
    }

    private String beforePrefix() {
        int propertyPrefixPos = this.unresolved.indexOf("${");
        return this.unresolved.substring(0, propertyPrefixPos);
    }

    private String beforeNextSuffix() {
        int propertySuffixPos = this.unresolved.indexOf("}");
        return this.unresolved.substring(0, propertySuffixPos);
    }
}

