/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import com.e_gineering.maven.gitflowhelper.properties.ExpansionBuffer;
import com.e_gineering.maven.gitflowhelper.properties.PropertyResolver;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class ScmUtils {
    private static final String DEFAULT_URL_EXPRESSION = "${env.GIT_URL}";
    private static final String DEFAULT_BRANCH_EXPRESSION = "${env.GIT_BRANCH}";
    private Properties systemEnvVars;
    private ScmManager scmManager;
    private MavenProject project;
    private Log log;
    private String masterBranchPattern;
    private String supportBranchPattern;
    private String releaseBranchPattern;
    private String hotfixBranchPattern;
    private String developmentBranchPattern;
    private String featureOrBugfixBranchPattern;

    public ScmUtils(Properties systemEnvVars, ScmManager scmManager, MavenProject project, Log log, String masterBranchPattern, String supportBranchPattern, String releaseBranchPattern, String hotfixBranchPattern, String developmentBranchPattern) {
        this.systemEnvVars = systemEnvVars;
        this.scmManager = scmManager;
        this.project = project;
        this.log = log;
        this.masterBranchPattern = masterBranchPattern;
        this.supportBranchPattern = supportBranchPattern;
        this.releaseBranchPattern = releaseBranchPattern;
        this.hotfixBranchPattern = hotfixBranchPattern;
        this.developmentBranchPattern = developmentBranchPattern;
        this.featureOrBugfixBranchPattern = this.featureOrBugfixBranchPattern;
    }

    public static String resolveUrlOrExpression(MavenProject project) {
        if (project.getScm() != null) {
            String connectionUrl = project.getScm().getDeveloperConnection();
            if (StringUtils.isBlank((String)connectionUrl)) {
                connectionUrl = project.getScm().getConnection();
            }
            if (!StringUtils.isBlank((String)connectionUrl)) {
                return connectionUrl;
            }
        }
        return DEFAULT_URL_EXPRESSION;
    }

    public GitBranchInfo resolveBranchInfo(String gitBranchExpression) {
        ExpansionBuffer eb;
        String resolvedBranchName;
        String branchNameOrExpression = gitBranchExpression;
        String connectionUrl = ScmUtils.resolveUrlOrExpression(this.project);
        try {
            ScmRepository repository = this.scmManager.makeScmRepository(connectionUrl);
            if (!"git".equals(this.scmManager.getProviderByRepository(repository).getScmType())) {
                throw new ScmException("Unable to resolve branches from non-git <scm> definitions.");
            }
            GitScmProviderRepository gitScmProviderRepository = (GitScmProviderRepository)repository.getProviderRepository();
            ScmFileSet fileSet = new ScmFileSet(this.project.getBasedir());
            ScmLogDispatcher scmLogger = new ScmLogDispatcher();
            try {
                branchNameOrExpression = GitBranchCommand.getCurrentBranch((ScmLogger)scmLogger, (GitScmProviderRepository)gitScmProviderRepository, (ScmFileSet)fileSet);
            }
            catch (ScmException scme) {
                this.log.debug((CharSequence)"Exception attempting to resolve a local branch. Attempting detached HEAD resolution");
                String sha1 = ScmUtils.sha1ForHEAD((ScmLogger)scmLogger, fileSet);
                this.log.debug((CharSequence)("HEAD is pointing at " + sha1));
                Set<String> branches = ScmUtils.branchesForSha1(sha1, (ScmLogger)scmLogger, fileSet);
                this.log.debug((CharSequence)("Found the following branches for " + sha1 + ": " + branches));
                GitBranchType type = null;
                String name = null;
                for (String candidateName : branches) {
                    GitBranchType candidateType = this.resolveBranchType(candidateName).getType();
                    if (type == null) {
                        type = candidateType;
                        name = candidateName;
                        continue;
                    }
                    if (candidateType != type) {
                        throw new ScmException("Multiple branches with different types resolved for " + sha1);
                    }
                    if (!GitBranchType.UNIQUELY_VERSIONED_TYPES.contains((Object)candidateType)) continue;
                    throw new ScmException("Multiple branches of different type reference the same release version for " + sha1);
                }
                branchNameOrExpression = name;
            }
        }
        catch (ScmException scme) {
            this.log.warn((CharSequence)"Unable to resolve a branch from SCM. Falling back to property replacement.", (Throwable)scme);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug((CharSequence)"IllegalArgumentException likely the result of the <scm> block missing from the pom.xml", (Throwable)iae);
        }
        if (branchNameOrExpression == null) {
            branchNameOrExpression = DEFAULT_BRANCH_EXPRESSION;
        }
        if ((!branchNameOrExpression.equals(resolvedBranchName = PropertyResolver.resolveValue(branchNameOrExpression, this.project.getProperties(), this.systemEnvVars)) || this.log.isDebugEnabled()) && this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Resolved gitBranchExpression: '" + gitBranchExpression + " to '" + resolvedBranchName + "'"));
        }
        if ((eb = new ExpansionBuffer(resolvedBranchName)).hasMoreLegalPlaceholders()) {
            resolvedBranchName = null;
        }
        return this.resolveBranchType(resolvedBranchName);
    }

    private GitBranchInfo resolveBranchType(String branchName) {
        if (branchName == null || branchName.equals("") || branchName.equals(DEFAULT_BRANCH_EXPRESSION)) {
            return new GitBranchInfo("", GitBranchType.UNDEFINED, null);
        }
        if (branchName.matches(this.masterBranchPattern)) {
            return new GitBranchInfo(branchName, GitBranchType.MASTER, this.masterBranchPattern);
        }
        if (branchName.matches(this.supportBranchPattern)) {
            return new GitBranchInfo(branchName, GitBranchType.SUPPORT, this.supportBranchPattern);
        }
        if (branchName.matches(this.releaseBranchPattern)) {
            return new GitBranchInfo(branchName, GitBranchType.RELEASE, this.releaseBranchPattern);
        }
        if (branchName.matches(this.hotfixBranchPattern)) {
            return new GitBranchInfo(branchName, GitBranchType.HOTFIX, this.hotfixBranchPattern);
        }
        if (branchName.matches(this.developmentBranchPattern)) {
            return new GitBranchInfo(branchName, GitBranchType.DEVELOPMENT, this.developmentBranchPattern);
        }
        return new GitBranchInfo(branchName, GitBranchType.OTHER, null);
    }

    private static String sha1ForHEAD(ScmLogger logger, ScmFileSet fileSet) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)fileSet.getBasedir(), (String)"rev-parse");
        cl.createArg().setValue("HEAD");
        RevParseConsumer rpConsumer = new RevParseConsumer(logger);
        ScmUtils.execGitCmd(logger, (StreamConsumer)rpConsumer, cl);
        return rpConsumer.getRev();
    }

    private static Set<String> branchesForSha1(String sha1, ScmLogger logger, ScmFileSet fileSet) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)fileSet.getBasedir(), (String)"show-ref");
        ShowRefForSha1Consumer srConsumer = new ShowRefForSha1Consumer(sha1, logger);
        ScmUtils.execGitCmd(logger, (StreamConsumer)srConsumer, cl);
        return srConsumer.getBranches();
    }

    private static void execGitCmd(ScmLogger logger, StreamConsumer consumer, Commandline cl) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        int exitCode = GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)logger);
        if (exitCode != 0) {
            throw new ScmException("Git command failed: " + stderr.getOutput());
        }
    }

    private static class ShowRefForSha1Consumer
    extends AbstractConsumer {
        private static final Pattern SHOW_REF_PATTERN = Pattern.compile("(?<sha1>[a-z0-9]{40}) (?:refs/heads/|refs/remotes/[\\w-.]+/)(?<branch>[\\w-/.]+)");
        private final String sha1HEAD;
        private final Set<String> branches = new HashSet<String>();

        public ShowRefForSha1Consumer(String sha1HEAD, ScmLogger logger) {
            super(logger);
            this.sha1HEAD = sha1HEAD;
        }

        public void consumeLine(String line) {
            String sha1;
            Matcher m = SHOW_REF_PATTERN.matcher(line.trim());
            if (m.matches() && (sha1 = m.group("sha1")).equals(this.sha1HEAD)) {
                String branch = m.group("branch");
                this.branches.add(branch);
            }
        }

        public Set<String> getBranches() {
            return this.branches;
        }
    }

    private static class RevParseConsumer
    extends AbstractConsumer {
        private String rev;

        public RevParseConsumer(ScmLogger logger) {
            super(logger);
        }

        public void consumeLine(String line) {
            this.rev = line.trim();
        }

        public String getRev() {
            return this.rev;
        }
    }
}

