/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import com.e_gineering.maven.gitflowhelper.properties.ExpansionBuffer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="tag-master", defaultPhase=LifecyclePhase.INSTALL)
public class TagMasterMojo
extends AbstractGitflowBranchMojo {
    @Parameter(property="gitURLExpression")
    private String gitURLExpression;
    @Parameter(defaultValue="${project.version}", property="tag", required=true)
    private String tag;
    @Parameter(defaultValue="org.apache.maven.plugins", property="tag.plugin.groupId", required=true)
    private String tagGroupId;
    @Parameter(defaultValue="maven-scm-plugin", property="tag.plugin.artifactId", required=true)
    private String tagArtifactId;
    @Parameter(defaultValue="1.9.4", property="tag.plugin.version", required=true)
    private String tagVersion;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    protected void execute(GitBranchType type, String gitBranch, String branchPattern) throws MojoExecutionException, MojoFailureException {
        if (this.project.isExecutionRoot() && type.equals((Object)GitBranchType.MASTER)) {
            if (this.gitURLExpression == null) {
                this.gitURLExpression = "${env.GIT_URL}";
            }
            String gitURL = this.resolveExpression(this.gitURLExpression);
            this.getLog().debug((CharSequence)("gitURLExpression: '" + this.gitURLExpression + "' resolved to: '" + gitURL + "'"));
            ExpansionBuffer eb = new ExpansionBuffer(gitURL);
            if (!eb.hasMoreLegalPlaceholders()) {
                this.getLog().info((CharSequence)("Invoking scm:tag for CI build matching branchPattern: [" + branchPattern + "]"));
                MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.tagGroupId), (String)MojoExecutor.artifactId((String)this.tagArtifactId), (String)MojoExecutor.version((String)this.tagVersion)), (String)MojoExecutor.goal((String)"tag"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"tag"), (String)this.tag), MojoExecutor.element((String)MojoExecutor.name((String)"developerConnectionUrl"), (String)("scm:git:" + gitURL))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            } else {
                throw new MojoFailureException("Unable to resolve gitURLExpression: " + this.gitURLExpression + ". Leaving build configuration unaltered.");
            }
        }
    }
}

